/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.util;

import java.util.ArrayList;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.print.IVariantParser;
import kd.bos.print.core.model.ui.component.PainterInfo;

public class KPrintUtil {
    public static final float LOMETRIC_PER_INCH = 254.3f;
    public static final int SCREEN_RESOLUTION = KDToolkit.getCurrentDpi();

    public static double lomToPrintPoint(double dfLom) {
        return dfLom / (double)254.3f * (double)SCREEN_RESOLUTION;
    }

    public static double printPointToLom(double prtPoint) {
        return Math.round(prtPoint * (double)254.3f / (double)SCREEN_RESOLUTION);
    }

    public static String parsePageVariant(String var, int pageTotal) {
        if ((var = var.replace("&[pageTotal]", String.valueOf(pageTotal))) != null && var.startsWith("&[") && var.endsWith("]")) {
            var = var.substring(2, var.length() - 1);
        }
        return var;
    }

    public static String parseVariant(PainterInfo info, String name) {
        IVariantParser parser = info.getDefaultVariantParser();
        IVariantParser customparser = info.getVariantParser();
        return KPrintUtil.parseVariant(parser, customparser, name, info);
    }

    public static ArrayList parseVariantText(String text) {
        String[] strings = text.split("&\\[");
        ArrayList<String> textList = new ArrayList<String>();
        textList.add(strings[0]);
        for (int i = 1; i < strings.length; ++i) {
            int varEnd = strings[i].indexOf("]");
            String varStr = "";
            String otherStr = "";
            if (varEnd == -1) {
                varStr = strings[i];
                textList.add("&[" + varStr);
                continue;
            }
            varStr = strings[i].substring(0, varEnd);
            otherStr = strings[i].substring(varEnd + 1);
            textList.add("&[" + varStr);
            textList.add(otherStr);
        }
        return textList;
    }

    private static String parseVariant(IVariantParser defaultParser, IVariantParser customParser, String variant, PainterInfo info) {
        String str = null;
        if (defaultParser != null) {
            str = defaultParser.parse(variant, info);
        }
        if (str == null && customParser != null) {
            str = customParser.parse(variant, info);
        }
        return str;
    }
}

