/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.util;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.watermark.WaterMark;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.svc.watermark.IWaterMarkProxy;
import kd.bos.print.core.ctrl.print.io.PdfWatermarkDrawer;
import kd.bos.print.core.ctrl.print.io.PrintFontMapper;
import kd.bos.print.core.ctrl.swing.KDFont;
import kd.bos.service.ServiceFactory;

public class PdfWaterMarkUtil {
    private static final Log log = LogFactory.getLog(PdfWaterMarkUtil.class);
    private static ILicenseService iLicenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);

    private static String getRealBillFormId(String billFormId) {
        try {
            FormConfig formConfig = FormMetadataCache.getFormConfig((String)billFormId);
            return formConfig.getEntityTypeId();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return billFormId;
        }
    }

    public static boolean checkIsTempLicense() {
        String licenseType = iLicenseService.getLicenseType();
        return StringUtils.isNotBlank((CharSequence)licenseType);
    }

    public static WaterMark getWaterMark(String formId) {
        String realBillFormId = PdfWaterMarkUtil.getRealBillFormId(formId);
        IWaterMarkProxy waterMarkService = (IWaterMarkProxy)ServiceFactory.getService(IWaterMarkProxy.class);
        return waterMarkService.loadFromCache(realBillFormId);
    }

    public static void addWaterMark(PdfWriter writer, Document document, com.lowagie.text.Font font, WaterMark waterMark) {
        new PdfWatermarkDrawer().addWaterMark(writer, document, font, waterMark);
    }

    private static BaseFont createBaseFont() {
        String fontName = "\u601d\u6e90\u5b8b\u4f53 CN";
        Font kf = KDFont.loadFontFromJAR(fontName, 0, 12.0f);
        return PrintFontMapper.createInstance().awtToPdf(kf);
    }

    public static com.lowagie.text.Font getFont(WaterMark waterMark) {
        com.lowagie.text.Font textFont = null;
        BaseFont bfChinese = null;
        try {
            bfChinese = PdfWaterMarkUtil.createBaseFont();
        }
        catch (Exception ex) {
            log.warn("\u6c34\u5370\u6253\u5370--\u521b\u5efa\u6253\u5370\u5b57\u4f53\u5931\u8d25, \u5c06\u5c1d\u8bd5\u4f7f\u7528\u5b57\u4f53\u5305\u521b\u5efa\u5b57\u4f53\u3002 --- " + ex.getCause());
            try {
                bfChinese = BaseFont.createFont((String)"STSong-Light", (String)"UniGB-UCS2-H", (boolean)false);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (bfChinese != null) {
            textFont = PdfWaterMarkUtil.createFont(bfChinese, waterMark);
        }
        return textFont;
    }

    private static com.lowagie.text.Font createFont(BaseFont bfChinese, WaterMark waterMark) {
        int fontSize = 12;
        String size = waterMark.getFontSize();
        if (StringUtils.isNotBlank((CharSequence)size)) {
            try {
                size = size.replace("px", "");
                fontSize = Integer.parseInt(size);
            }
            catch (Exception ignore) {
                log.warn("watermark font transfer error\uff1afontSize=%s", (Object)size);
                fontSize = 12;
            }
            return new com.lowagie.text.Font(bfChinese, (float)fontSize, 0);
        }
        return new com.lowagie.text.Font(bfChinese, (float)fontSize, 0, (Color)new GrayColor(0.85f));
    }
}

