/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.ExportException;
import java.util.HashMap;
import kd.bos.print.core.ctrl.print.xls.translater.AR1PNode_V2X;
import kd.bos.print.core.ctrl.print.xls.translater.DividableObject_V2X;
import kd.bos.print.core.ctrl.print.xls.widget.IXlsNode;
import kd.bos.print.core.execute.exporter.ExportObjectFactory;
import kd.bos.print.core.execute.render.painter.PaintContext;
import kd.bos.print.core.execute.render.painter.share.AwtImageShare;
import kd.bos.print.core.execute.render.painter.share.ShareResource;
import kd.bos.print.core.model.ui.component.IPainter;
import org.apache.log4j.Logger;

public class R1PrintV2XExporter {
    private ExportObjectFactory _objFactory;
    private HashMap _catchFactory = new HashMap();
    private PaintContext paintContext;
    protected Logger _log = Logger.getLogger((String)"R1PrintV2XExporter");
    private static final String DIVIDEV2XKEY = "divideObject";

    public R1PrintV2XExporter() throws ExportException {
        String config = "/PrtView2Xls.xml";
        try (InputStream in = this.getClass().getResourceAsStream(config);){
            if (in == null) {
                throw new ExportException("ObjectFactory config xml not found:" + config);
            }
            this._catchFactory.put(DIVIDEV2XKEY, new DividableObject_V2X());
            this._objFactory = new ExportObjectFactory(in);
        }
        catch (IOException e) {
            throw new ExportException("initError", e);
        }
    }

    private AR1PNode_V2X createExporter(IPainter painter) {
        String key = painter.getClass().getName();
        AR1PNode_V2X exporter = (AR1PNode_V2X)this._catchFactory.get(key);
        if (exporter == null) {
            exporter = (AR1PNode_V2X)this._objFactory.newObject(key);
            this._catchFactory.put(key, exporter);
        }
        return exporter;
    }

    public IXlsNode translate(IPainter painter, IXlsNode parent) {
        AR1PNode_V2X translater = this.createExporter(painter);
        translater.setExporter(this);
        translater.setNode(painter);
        translater.setPaintContext(this.getPaintContext());
        return translater.export(parent);
    }

    public PaintContext getPaintContext() {
        if (this.paintContext == null) {
            this.paintContext = new PaintContext();
            this.paintContext.setShareResource(new ShareResource());
            this.paintContext.getShareResource().setImageShare(new AwtImageShare());
        }
        return this.paintContext;
    }

    public void setPaintContext(PaintContext paintContext) {
        this.paintContext = paintContext;
    }
}

