/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import java.util.ArrayList;
import kd.bos.print.core.ctrl.print.xls.exception.OutOfSizeException;
import kd.bos.print.core.ctrl.print.xls.output.Location;

public class LinesList
extends ArrayList {
    float _maxIngore = 1.0f;
    int _maxSize = 0;
    int _rollbackOff = 0;
    private ArrayList _tempList = null;

    public LinesList() {
    }

    public LinesList(int size) {
        this.setMaxSize(size);
    }

    public void add(Location obj) throws OutOfSizeException {
        if (this._maxSize != 0 && super.size() >= this._maxSize) {
            throw new OutOfSizeException("output.LinesList.beyondMaxSize " + this._maxSize);
        }
        obj.setMaxIngore(this._maxIngore);
        float value = this.isIn(obj);
        if (value != -1.0f) {
            obj.setValue(value);
        } else {
            super.add(obj);
        }
    }

    @Override
    public boolean add(LinesList list) throws OutOfSizeException {
        Location line;
        int i;
        this._tempList = new ArrayList();
        this._rollbackOff = 0;
        for (i = 0; i < list.size(); ++i) {
            line = list.getChild(i);
            if (this._maxSize != 0 && super.size() + this._tempList.size() >= this._maxSize + this._rollbackOff) {
                return false;
            }
            line.setMaxIngore(this._maxIngore);
            float value = this.isIn(line);
            if (value != -1.0f) {
                ++this._rollbackOff;
            }
            this._tempList.add(line);
        }
        for (i = 0; i < this._tempList.size(); ++i) {
            line = (Location)this._tempList.get(i);
            this.add(line);
        }
        return true;
    }

    private float isIn(Location loc) {
        int index = this.indexOf(loc);
        float value = -1.0f;
        if (index != -1) {
            value = ((Location)this.get(index)).getValue();
        }
        return value;
    }

    public void setMaxIngore(float value) {
        this._maxIngore = value;
    }

    public Location getChild(int index) {
        return (Location)super.get(index);
    }

    public void setMaxSize(int size) {
        this._maxSize = size;
    }
}

