/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import java.util.Map;
import kd.bos.print.core.ctrl.print.xls.exobject.BasicCell;
import kd.bos.print.core.ctrl.print.xls.output.StyleHelper;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;

public class StyleCacheHelper {
    private Map styleCacheMap;
    private static char absent = (char)38;
    private static char comma = (char)44;

    StyleCacheHelper(Map styleCacheMap) {
        this.styleCacheMap = styleCacheMap;
    }

    private static String getMergeKey(CellStyle styleCell, CellStyle contentCell) {
        StringBuilder sb = new StringBuilder();
        sb.append(absent).append(styleCell.getBorderTop());
        sb.append(comma).append(styleCell.getTopBorderColor());
        sb.append(absent).append(styleCell.getBorderLeft());
        sb.append(comma).append(styleCell.getLeftBorderColor());
        sb.append(absent).append(styleCell.getBorderBottom());
        sb.append(comma).append(styleCell.getBottomBorderColor());
        sb.append(absent).append(styleCell.getBorderRight());
        sb.append(comma).append(styleCell.getRightBorderColor());
        sb.append(absent).append(styleCell.getFillForegroundColor());
        sb.append(comma).append(styleCell.getFillPattern());
        sb.append(absent).append(contentCell.getFontIndex());
        sb.append(absent).append(contentCell.getWrapText());
        sb.append(absent).append(contentCell.getAlignment());
        sb.append(absent).append(contentCell.getVerticalAlignment());
        sb.append(absent).append(contentCell.getIndention());
        return sb.toString();
    }

    public XSSFCellStyle getMergeCellStyle(CellStyle styleCell, CellStyle contentCell) {
        String key = StyleCacheHelper.getMergeKey(styleCell, contentCell);
        XSSFCellStyle newCellStyle = (XSSFCellStyle)this.styleCacheMap.get(key);
        if (newCellStyle == null) {
            XSSFCellStyle xssfCellStyle = (XSSFCellStyle)styleCell;
            newCellStyle = xssfCellStyle.copy();
            StyleHelper.setContentStyle((CellStyle)newCellStyle, contentCell);
            this.styleCacheMap.put(key, newCellStyle);
        }
        return newCellStyle;
    }

    private String getLabelCellStyleKey(XSSFCellStyle cellStyle, XSSFCellStyle xlsCellStyle) {
        if (StyleHelper.isNullBorderBgStyle((CellStyle)xlsCellStyle)) {
            return StyleCacheHelper.getMergeKey((CellStyle)cellStyle, (CellStyle)cellStyle);
        }
        if (StyleHelper.isNullBorderBgStyle((CellStyle)cellStyle)) {
            return StyleCacheHelper.getMergeKey((CellStyle)xlsCellStyle, (CellStyle)cellStyle);
        }
        StringBuilder sb = new StringBuilder();
        if (cellStyle.getBorderTop() != BorderStyle.NONE) {
            sb.append(absent).append(cellStyle.getBorderTop());
            sb.append(comma).append(cellStyle.getTopBorderColor());
        } else {
            sb.append(absent).append(xlsCellStyle.getBorderTop());
            sb.append(comma).append(xlsCellStyle.getTopBorderColor());
        }
        if (cellStyle.getBorderLeft() != BorderStyle.NONE) {
            sb.append(absent).append(cellStyle.getBorderLeft());
            sb.append(comma).append(cellStyle.getLeftBorderColor());
        } else {
            sb.append(absent).append(xlsCellStyle.getBorderLeft());
            sb.append(comma).append(xlsCellStyle.getLeftBorderColor());
        }
        if (cellStyle.getBorderBottom() != BorderStyle.NONE) {
            sb.append(absent).append(cellStyle.getBorderBottom());
            sb.append(comma).append(cellStyle.getBottomBorderColor());
        } else {
            sb.append(absent).append(xlsCellStyle.getBorderBottom());
            sb.append(comma).append(xlsCellStyle.getBottomBorderColor());
        }
        if (cellStyle.getBorderRight() != BorderStyle.NONE) {
            sb.append(absent).append(cellStyle.getBorderRight());
            sb.append(comma).append(cellStyle.getRightBorderColor());
        } else {
            sb.append(absent).append(xlsCellStyle.getBorderRight());
            sb.append(comma).append(xlsCellStyle.getRightBorderColor());
        }
        if (cellStyle.getFillPattern() != FillPatternType.NO_FILL) {
            sb.append(absent).append(cellStyle.getFillForegroundColor());
            sb.append(comma).append(cellStyle.getFillPattern());
        } else {
            sb.append(absent).append(xlsCellStyle.getFillForegroundColor());
            sb.append(comma).append(xlsCellStyle.getFillPattern());
        }
        sb.append(absent).append(cellStyle.getFontIndex());
        sb.append(absent).append(cellStyle.getWrapText());
        sb.append(absent).append(cellStyle.getAlignment());
        sb.append(absent).append(cellStyle.getVerticalAlignment());
        sb.append(absent).append(cellStyle.getIndention());
        return sb.toString();
    }

    public XSSFCellStyle getLabelXSSFCellStyle(Cell xlsCell, BasicCell cell) {
        XSSFCellStyle xlsCellStyle;
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getStyle();
        String key = this.getLabelCellStyleKey(cellStyle, xlsCellStyle = (XSSFCellStyle)xlsCell.getCellStyle());
        XSSFCellStyle newCellStyle = (XSSFCellStyle)this.styleCacheMap.get(key);
        if (newCellStyle != null) {
            return newCellStyle;
        }
        if (StyleHelper.isNullBorderBgStyle((CellStyle)xlsCellStyle)) {
            newCellStyle = cellStyle.copy();
        } else if (StyleHelper.isNullBorderBgStyle((CellStyle)cellStyle)) {
            newCellStyle = xlsCellStyle.copy();
            StyleHelper.setContentStyle((CellStyle)newCellStyle, (CellStyle)cellStyle);
        } else {
            newCellStyle = xlsCellStyle.copy();
            StyleHelper.setContentStyle((CellStyle)newCellStyle, (CellStyle)cellStyle);
            if (cellStyle.getBorderLeft() != BorderStyle.NONE) {
                newCellStyle.setBorderLeft(cellStyle.getBorderLeft());
                newCellStyle.setLeftBorderColor(cellStyle.getLeftBorderXSSFColor());
            }
            if (cellStyle.getBorderRight() != BorderStyle.NONE) {
                newCellStyle.setBorderRight(cellStyle.getBorderRight());
                newCellStyle.setRightBorderColor(cellStyle.getRightBorderXSSFColor());
            }
            if (cellStyle.getBorderTop() != BorderStyle.NONE) {
                newCellStyle.setBorderTop(cellStyle.getBorderTop());
                newCellStyle.setTopBorderColor(cellStyle.getTopBorderXSSFColor());
            }
            if (cellStyle.getBorderBottom() != BorderStyle.NONE) {
                newCellStyle.setBorderBottom(cellStyle.getBorderBottom());
                newCellStyle.setBottomBorderColor(cellStyle.getBottomBorderXSSFColor());
            }
            if (cellStyle.getFillPattern() != FillPatternType.NO_FILL) {
                newCellStyle.setFillPattern(cellStyle.getFillPattern());
                newCellStyle.setFillForegroundColor(cellStyle.getFillForegroundXSSFColor());
            }
        }
        this.styleCacheMap.put(key, newCellStyle);
        return newCellStyle;
    }

    private String getContainerKey(CellStyle cellStyle, CellStyle poiCellStyle, boolean isNewPoiCell, boolean isFirstRow, boolean isLastRow, boolean isFirstCol, boolean isLastCol) {
        StringBuilder sb = new StringBuilder();
        if (isFirstRow) {
            sb.append(absent).append(cellStyle.getBorderTop());
            sb.append(comma).append(cellStyle.getTopBorderColor());
        } else if (!isNewPoiCell) {
            sb.append(absent).append(poiCellStyle.getBorderTop());
            sb.append(comma).append(poiCellStyle.getTopBorderColor());
        } else {
            sb.append(absent).append(BorderStyle.NONE);
            sb.append(comma).append("0");
        }
        if (isFirstCol) {
            sb.append(absent).append(cellStyle.getBorderLeft());
            sb.append(comma).append(cellStyle.getLeftBorderColor());
        } else if (!isNewPoiCell) {
            sb.append(absent).append(poiCellStyle.getBorderLeft());
            sb.append(comma).append(poiCellStyle.getLeftBorderColor());
        } else {
            sb.append(absent).append(BorderStyle.NONE);
            sb.append(comma).append("0");
        }
        if (isLastRow) {
            sb.append(absent).append(cellStyle.getBorderBottom());
            sb.append(comma).append(cellStyle.getBottomBorderColor());
        } else if (!isNewPoiCell) {
            sb.append(absent).append(poiCellStyle.getBorderBottom());
            sb.append(comma).append(poiCellStyle.getBottomBorderColor());
        } else {
            sb.append(absent).append(BorderStyle.NONE);
            sb.append(comma).append("0");
        }
        if (isLastCol) {
            sb.append(absent).append(cellStyle.getBorderRight());
            sb.append(comma).append(cellStyle.getRightBorderColor());
        } else if (!isNewPoiCell) {
            sb.append(absent).append(poiCellStyle.getBorderRight());
            sb.append(comma).append(poiCellStyle.getRightBorderColor());
        } else {
            sb.append(absent).append(BorderStyle.NONE);
            sb.append(comma).append("0");
        }
        if (cellStyle.getFillPattern() == FillPatternType.NO_FILL) {
            sb.append(absent).append(poiCellStyle.getFillForegroundColorColor());
            sb.append(comma).append(poiCellStyle.getFillPattern());
        } else {
            sb.append(absent).append(cellStyle.getFillForegroundColorColor());
            sb.append(comma).append(cellStyle.getFillPattern());
        }
        sb.append(absent).append(cellStyle.getFontIndex());
        sb.append(absent).append(cellStyle.getWrapText());
        sb.append(absent).append(cellStyle.getAlignment());
        sb.append(absent).append(cellStyle.getVerticalAlignment());
        sb.append(absent).append(cellStyle.getIndention());
        return sb.toString();
    }

    public XSSFCellStyle getContainerXSSFCellStyle(BasicCell basicCell, Cell poiCell, boolean isNewPoiCell, Sheet sheet, boolean isFirstRow, boolean isLastRow, boolean isFirstCol, boolean isLastCol) {
        CellStyle poiCellStyle;
        XSSFCellStyle cellStyle = (XSSFCellStyle)basicCell.getStyle();
        String key = this.getContainerKey((CellStyle)cellStyle, poiCellStyle = poiCell.getCellStyle(), isNewPoiCell, isFirstRow, isLastRow, isFirstCol, isLastCol);
        XSSFCellStyle newCellStyle = (XSSFCellStyle)this.styleCacheMap.get(key);
        if (newCellStyle != null) {
            return newCellStyle;
        }
        newCellStyle = (XSSFCellStyle)sheet.getWorkbook().createCellStyle();
        if (!isNewPoiCell) {
            newCellStyle.setBorderTop(poiCellStyle.getBorderTop());
            newCellStyle.setTopBorderColor(poiCellStyle.getTopBorderColor());
            newCellStyle.setBorderLeft(poiCellStyle.getBorderLeft());
            newCellStyle.setLeftBorderColor(poiCellStyle.getLeftBorderColor());
            newCellStyle.setBorderRight(poiCellStyle.getBorderRight());
            newCellStyle.setRightBorderColor(poiCellStyle.getRightBorderColor());
            newCellStyle.setBorderBottom(poiCellStyle.getBorderBottom());
            newCellStyle.setBottomBorderColor(poiCellStyle.getBottomBorderColor());
        }
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        XSSFColor borderLeftColor = cellStyle.getLeftBorderXSSFColor();
        BorderStyle borderRight = cellStyle.getBorderRight();
        XSSFColor borderRightColor = cellStyle.getRightBorderXSSFColor();
        BorderStyle borderTop = cellStyle.getBorderTop();
        XSSFColor borderTopColor = cellStyle.getTopBorderXSSFColor();
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        XSSFColor borderBottomColor = cellStyle.getBottomBorderXSSFColor();
        if (isFirstRow && borderTop != BorderStyle.NONE) {
            newCellStyle.setBorderTop(borderTop);
            newCellStyle.setTopBorderColor(borderTopColor);
        }
        if (isLastRow && borderBottom != BorderStyle.NONE) {
            newCellStyle.setBorderBottom(borderBottom);
            newCellStyle.setBottomBorderColor(borderBottomColor);
        }
        if (isFirstCol && borderLeft != BorderStyle.NONE) {
            newCellStyle.setBorderLeft(borderLeft);
            newCellStyle.setLeftBorderColor(borderLeftColor);
        }
        if (isLastCol && borderRight != BorderStyle.NONE) {
            newCellStyle.setBorderRight(borderRight);
            newCellStyle.setRightBorderColor(borderRightColor);
        }
        if (cellStyle.getFillPattern() == FillPatternType.NO_FILL) {
            if (poiCellStyle instanceof XSSFCellStyle) {
                newCellStyle.setFillForegroundColor((XSSFColor)poiCellStyle.getFillForegroundColorColor());
            } else {
                newCellStyle.setFillForegroundColor(poiCellStyle.getFillForegroundColor());
            }
            newCellStyle.setFillPattern(poiCellStyle.getFillPattern());
        } else {
            newCellStyle.setFillForegroundColor(cellStyle.getFillForegroundColorColor());
            newCellStyle.setFillPattern(cellStyle.getFillPattern());
        }
        StyleHelper.setContentStyle((CellStyle)newCellStyle, (CellStyle)cellStyle);
        this.styleCacheMap.put(key, newCellStyle);
        return newCellStyle;
    }
}

