/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import java.awt.Color;
import java.util.Map;
import java.util.WeakHashMap;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.xls.exobject.BasicCell;
import kd.bos.print.core.ctrl.print.xls.output.StyleGuide;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class StyleHelper {
    private static Map<String, XSSFColor> xssfColorMap = new WeakHashMap<String, XSSFColor>();
    private static IndexedColorMap indexedColorMap = new DefaultIndexedColorMap();
    public static final String NONESTYLEKEY = "cellstyleisnull!!!";
    static char absent = (char)38;
    static char comma = (char)44;

    public static String getKey(Style style) {
        StringBuilder sb = new StringBuilder();
        if (style == null) {
            return NONESTYLEKEY;
        }
        sb.append(style.getFontName());
        sb.append("&").append(style.getFontSizeF());
        sb.append("&").append(StyleHelper.color2String(style.getFontColor()));
        sb.append("&").append(style.isItalic() ? "i1" : "i0");
        sb.append("&").append(style.isStrikeThrough() ? "s1" : "s0");
        sb.append("&").append(style.isUnderline() ? "u1" : "u0");
        sb.append("&").append(StyleGuide.translateBorder(style, Styles.Position.LEFT)).append("&").append(StyleHelper.color2String(style.getBorderColor(Styles.Position.LEFT)));
        sb.append("&").append(StyleGuide.translateBorder(style, Styles.Position.RIGHT)).append("&").append(StyleHelper.color2String(style.getBorderColor(Styles.Position.RIGHT)));
        sb.append("&").append(StyleGuide.translateBorder(style, Styles.Position.TOP)).append("&").append(StyleHelper.color2String(style.getBorderColor(Styles.Position.TOP)));
        sb.append("&").append(StyleGuide.translateBorder(style, Styles.Position.BOTTOM)).append("&").append(StyleHelper.color2String(style.getBorderColor(Styles.Position.BOTTOM)));
        sb.append("&").append(StyleHelper.color2String(style.getBackground()));
        sb.append("&").append(style.getHorizontalAlign().getValue());
        sb.append("&").append(style.getVerticalAlign().getValue());
        sb.append("&").append(style.isWrapText() ? "w1" : "w0");
        sb.append("&").append(style.getRotation());
        sb.append("&").append(style.isBold() ? "b1" : "b0");
        sb.append("&").append(style.isShrinkText() ? "st1" : "st0");
        return sb.toString();
    }

    @Deprecated
    public static String getContainerKey(Cell xlsCell, BasicCell basicCell, int firstRow, int firstCol, int r, int c) {
        StringBuilder sb = new StringBuilder();
        sb.append(xlsCell.getColumnIndex());
        sb.append(absent).append(r - firstRow);
        sb.append(comma).append(c - firstCol);
        CellStyle cellStyle = basicCell.getStyle();
        sb.append(absent).append(basicCell.getType());
        sb.append(absent).append(basicCell.getX1());
        sb.append(comma).append(basicCell.getY1());
        sb.append(comma).append(basicCell.getX2());
        sb.append(comma).append(basicCell.getY2());
        sb.append(absent).append(cellStyle.getBorderLeft());
        sb.append(comma).append(cellStyle.getLeftBorderColor());
        sb.append(absent).append(cellStyle.getBorderRight());
        sb.append(comma).append(cellStyle.getRightBorderColor());
        sb.append(absent).append(cellStyle.getBorderTop());
        sb.append(comma).append(cellStyle.getTopBorderColor());
        sb.append(absent).append(cellStyle.getBorderBottom());
        sb.append(comma).append(cellStyle.getBottomBorderColor());
        sb.append(absent).append(cellStyle.getFontIndex());
        sb.append(absent).append(cellStyle.getWrapText());
        sb.append(absent).append(cellStyle.getFillForegroundColor());
        sb.append(comma).append(cellStyle.getFillPattern());
        return sb.toString();
    }

    public static CellStyle getStyle(String key, Workbook wb) {
        if (wb instanceof SXSSFWorkbook || wb instanceof XSSFWorkbook) {
            return StyleHelper.getXSSFStyle(key, wb);
        }
        return StyleHelper.getHSSFStyle(key, wb);
    }

    private static CellStyle getXSSFStyle(String key, Workbook wb) {
        String[] styles = key.split("&");
        XSSFCellStyle cellStyle = (XSSFCellStyle)wb.createCellStyle();
        XSSFFont font = (XSSFFont)wb.createFont();
        font.setFontName(styles[0]);
        if ("b1".equals(styles[19])) {
            font.setBold(true);
        }
        double fontSize = Double.parseDouble(styles[1]);
        fontSize = 72.0 / (double)KDToolkit.getCurrentDpi() * fontSize;
        long count = Math.round(fontSize / 0.5);
        fontSize = 0.5 * (double)count;
        font.setFontHeight(fontSize);
        font.setColor(new XSSFColor(StyleHelper.String2Color(styles[2]), (IndexedColorMap)new DefaultIndexedColorMap()));
        font.setItalic("i1".equals(styles[3]));
        if ("u1".equals(styles[5])) {
            font.setUnderline((byte)1);
        }
        font.setStrikeout("s1".equals(styles[4]));
        cellStyle.setBorderLeft(BorderStyle.valueOf((short)Short.parseShort(styles[6])));
        cellStyle.setLeftBorderColor(StyleHelper.getXSSColor(styles[7]));
        cellStyle.setBorderRight(BorderStyle.valueOf((short)Short.parseShort(styles[8])));
        cellStyle.setRightBorderColor(StyleHelper.getXSSColor(styles[9]));
        cellStyle.setBorderTop(BorderStyle.valueOf((short)Short.parseShort(styles[10])));
        cellStyle.setTopBorderColor(StyleHelper.getXSSColor(styles[11]));
        cellStyle.setBorderBottom(BorderStyle.valueOf((short)Short.parseShort(styles[12])));
        cellStyle.setBottomBorderColor(StyleHelper.getXSSColor(styles[13]));
        if (StyleHelper.String2Color(styles[14]).getAlpha() != 0) {
            cellStyle.setFillForegroundColor(StyleHelper.getXSSColor(styles[14]));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        } else {
            cellStyle.setFillPattern(FillPatternType.NO_FILL);
        }
        cellStyle.setAlignment(HorizontalAlignment.forInt((int)StyleGuide.translateAliment(Integer.parseInt(styles[15]))));
        cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)StyleGuide.translateVerticalAliment(Integer.parseInt(styles[16]))));
        cellStyle.setWrapText("w1".equals(styles[17]));
        short rotation = Short.parseShort(styles[18]);
        rotation = (short)(0 - rotation);
        if (Integer.parseInt(styles[18]) != 0) {
            cellStyle.setRotation(rotation);
        }
        cellStyle.setShrinkToFit("st1".equals(styles[20]));
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private static XSSFColor getXSSColor(String colorStr) {
        XSSFColor xssfColor = xssfColorMap.get(colorStr);
        if (xssfColor != null) {
            return xssfColor;
        }
        Color color = StyleHelper.String2Color(colorStr);
        xssfColor = new XSSFColor(color, indexedColorMap);
        xssfColorMap.put(colorStr, xssfColor);
        return xssfColor;
    }

    public static CellStyle getHSSFStyle(String key, Workbook wb) {
        String[] styles = key.split("&");
        CellStyle cellStyle = wb.createCellStyle();
        Font font = wb.createFont();
        font.setFontName(styles[0]);
        if ("b1".equals(styles[19])) {
            font.setBold(true);
        }
        short fontSize = Short.parseShort(styles[1]);
        fontSize = (short)(72.0 / (double)KDToolkit.getCurrentDpi() * (double)fontSize);
        font.setFontHeightInPoints(fontSize);
        font.setColor(StyleGuide.translateColor(StyleHelper.String2Color(styles[2])));
        font.setItalic("i1".equals(styles[3]));
        if ("u1".equals(styles[5])) {
            font.setUnderline((byte)1);
        }
        font.setStrikeout("s1".equals(styles[4]));
        cellStyle.setBorderLeft(BorderStyle.valueOf((short)Short.parseShort(styles[6])));
        cellStyle.setLeftBorderColor(StyleGuide.translateColor(StyleHelper.String2Color(styles[7])));
        cellStyle.setBorderRight(BorderStyle.valueOf((short)Short.parseShort(styles[8])));
        cellStyle.setRightBorderColor(StyleGuide.translateColor(StyleHelper.String2Color(styles[9])));
        cellStyle.setBorderTop(BorderStyle.valueOf((short)Short.parseShort(styles[10])));
        cellStyle.setTopBorderColor(StyleGuide.translateColor(StyleHelper.String2Color(styles[11])));
        cellStyle.setBorderBottom(BorderStyle.valueOf((short)Short.parseShort(styles[12])));
        cellStyle.setBottomBorderColor(StyleGuide.translateColor(StyleHelper.String2Color(styles[13])));
        if (StyleHelper.String2Color(styles[14]).getAlpha() != 0) {
            cellStyle.setFillForegroundColor(StyleGuide.translateColor(StyleHelper.String2Color(styles[14])));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        } else {
            cellStyle.setFillPattern(FillPatternType.NO_FILL);
        }
        cellStyle.setAlignment(HorizontalAlignment.forInt((int)StyleGuide.translateAliment(Integer.parseInt(styles[15]))));
        cellStyle.setVerticalAlignment(VerticalAlignment.forInt((int)StyleGuide.translateVerticalAliment(Integer.parseInt(styles[16]))));
        cellStyle.setWrapText("w1".equals(styles[17]));
        short rotation = Short.parseShort(styles[18]);
        rotation = (short)(0 - rotation);
        if (Integer.parseInt(styles[18]) != 0) {
            cellStyle.setRotation(rotation);
        }
        cellStyle.setShrinkToFit("st1".equals(styles[20]));
        cellStyle.setFont(font);
        return cellStyle;
    }

    private static String color2String(Color color) {
        return color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha();
    }

    private static Color String2Color(String color) {
        String[] colors = color.split(",");
        return new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]), Integer.parseInt(colors[3]));
    }

    public static boolean isNullBorderBgStyle(CellStyle cellStyle) {
        return cellStyle.getBorderLeft() == BorderStyle.NONE && cellStyle.getBorderRight() == BorderStyle.NONE && cellStyle.getBorderTop() == BorderStyle.NONE && cellStyle.getBorderBottom() == BorderStyle.NONE && (cellStyle.getFillPattern() == FillPatternType.NO_FILL || cellStyle.getFillForegroundColorColor() == null);
    }

    public static void setContentStyle(CellStyle newStyle, CellStyle cellStyle) {
        XSSFCellStyle hNewStyle = (XSSFCellStyle)newStyle;
        XSSFCellStyle hCellStyle = (XSSFCellStyle)cellStyle;
        hNewStyle.setAlignment(hCellStyle.getAlignment());
        hNewStyle.setFont((Font)hCellStyle.getFont());
        hNewStyle.setVerticalAlignment(hCellStyle.getVerticalAlignment());
        hNewStyle.setWrapText(hCellStyle.getWrapText());
        hNewStyle.setIndention(hCellStyle.getIndention());
    }
}

