/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import com.google.zxing.BarcodeFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.CustomParam;
import kd.bos.print.core.ctrl.kdf.util.render.CellImageRender;
import kd.bos.print.core.ctrl.kdf.util.style.PenStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.StyleUtil;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.print.xls.exobject.APaper;
import kd.bos.print.core.ctrl.print.xls.exobject.BasicCell;
import kd.bos.print.core.ctrl.print.xls.output.LinesList;
import kd.bos.print.core.ctrl.print.xls.output.Location;
import kd.bos.print.core.ctrl.print.xls.output.StyleCacheHelper;
import kd.bos.print.core.ctrl.print.xls.output.StyleHelper;
import kd.bos.print.core.ctrl.print.xls.output.XlsContext;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.barcode.BarcodeUtils;
import kd.bos.print.core.model.widget.barcode.QRCodeUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.util.Units;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;

public class XlsHelper {
    private Drawing drawing = null;
    private Sheet _sheet;
    private static final double MTP = 25.39999918;
    private HashMap _imageCache;
    private MessageDigest _digest;
    private Logger _log = Logger.getLogger(XlsHelper.class);
    Map conStyleMap;
    private XlsContext xlsContext;
    private StyleCacheHelper styleCacheHelper;
    private boolean isFirstPage = true;
    private Map<String, Object> para = new HashMap<String, Object>(16);
    private int lastRow = 0;
    private boolean isFastModel;

    public Map<String, Object> getPara() {
        return this.para;
    }

    public void setPara(Map<String, Object> para) {
        this.para = para;
    }

    public XlsHelper() {
        this.xlsContext = new XlsContext();
    }

    public XlsHelper(XlsContext xlsContext) {
        this.xlsContext = xlsContext;
        CustomParam customParam = new CustomParam();
        HashSet<String> set = new HashSet<String>();
        String searchKey = "PRINT_TO_EXCEL_FAST";
        set.add(searchKey);
        customParam.setSearchKeySet(set);
        String fastModel = SystemParamServiceHelper.loadCustomParameterFromCache((CustomParam)customParam).getOrDefault(searchKey, "true");
        this.isFastModel = Boolean.parseBoolean(fastModel);
    }

    private Drawing getDrawing() {
        if (this.drawing != null) {
            return this.drawing;
        }
        this.drawing = this._sheet.createDrawingPatriarch();
        return this.drawing;
    }

    public void setFirstPage(boolean firstPage) {
        this.isFirstPage = firstPage;
    }

    public void updateSheet(Sheet sheet, Map poiConStyleMap) {
        this._sheet = sheet;
        this.drawing = null;
        this.conStyleMap = poiConStyleMap;
        this.styleCacheHelper = new StyleCacheHelper(poiConStyleMap);
    }

    public void initRows(int offset, float topMargin, float bottomMargin, float hReduce, APaper paper, LinesList horizonLines) {
        int i;
        Iterator iter = horizonLines.iterator();
        Location start = null;
        Location end = (Location)iter.next();
        int n = i = offset == 0 ? offset : offset + 1;
        if (!this.isTurnoffPaging() || this.isFirstPage) {
            this._sheet.createRow(i).setHeight(XlsHelper.getRowHeight(topMargin));
            ++i;
        }
        while (iter.hasNext()) {
            start = end;
            end = (Location)iter.next();
            Row row = this._sheet.createRow(i);
            double height = end.getValue() - start.getValue();
            row.setHeight(XlsHelper.getRowHeight(height, hReduce));
            if (!iter.hasNext()) continue;
            ++i;
        }
        if (!this.isTurnoffPaging()) {
            this._sheet.createRow(++i).setHeight(XlsHelper.getRowHeight(bottomMargin));
        }
        this.lastRow = i;
        this._sheet.setRowBreak(this.lastRow);
    }

    public boolean isTurnoffPaging() {
        return this.getPara() != null && Boolean.parseBoolean(String.valueOf(this.getPara().getOrDefault("turnoffpaging", Boolean.FALSE)));
    }

    public void setLastRowHeight(float bottomMargin) {
        this._sheet.createRow(this.lastRow).setHeight(XlsHelper.getRowHeight(bottomMargin));
    }

    public void initCols(float leftMargin, float rightMargin, float wReduce, LinesList verticalLines) {
        Iterator iter = verticalLines.iterator();
        Location start = null;
        Location end = (Location)iter.next();
        int i = 1;
        this._sheet.setColumnWidth(0, XlsHelper.getColWidth(leftMargin));
        while (iter.hasNext()) {
            start = end;
            end = (Location)iter.next();
            double width = end.getValue() - start.getValue();
            this._sheet.setColumnWidth(i, XlsHelper.getColWidth(width, wReduce));
            ++i;
        }
    }

    public void outputCell(BasicCell cell, boolean[][] map, int offset, int Xstart, int Ystart) {
        int cellIndex;
        if (!cell.isValid()) {
            return;
        }
        boolean turnoffPaging = this.isTurnoffPaging();
        if (!turnoffPaging && !this.isFirstPage) {
            ++offset;
        }
        int startIndex = offset + 1;
        String cellId = cell.getId();
        int rowIndex = cell.getY1() + Ystart + startIndex;
        Row row = this._sheet.getRow(rowIndex);
        Cell xlsCell = row.getCell(cellIndex = cell.getX1() + Xstart + 1);
        if (xlsCell == null) {
            xlsCell = row.createCell(cellIndex);
        }
        switch (cell.getType()) {
            case 0: {
                this.setLabelXSSFCellStyle(xlsCell, cell);
                xlsCell.setCellValue(cell.getText());
                break;
            }
            case 5: {
                this.setLabelXSSFCellStyle(xlsCell, cell);
                xlsCell.setCellValue(cell.getText());
                List<Point> points = this.xlsContext.getPageTotalIndxMap().get(this._sheet.getSheetName());
                if (points == null) {
                    points = new ArrayList<Point>(10);
                    this.xlsContext.getPageTotalIndxMap().put(this._sheet.getSheetName(), points);
                }
                points.add(new Point(rowIndex, cellIndex));
                break;
            }
            case 2: 
            case 3: {
                this.setXSSCFontainerStyle(cell, offset, Xstart, Ystart);
                return;
            }
            case 1: {
                this.setLabelXSSFCellStyle(xlsCell, cell);
                this.outputImg(cell, offset, Xstart, Ystart);
                break;
            }
            case 4: {
                this.setLabelXSSFCellStyle(xlsCell, cell);
                this.outputImg(cell, offset, Xstart, Ystart);
                break;
            }
            case 6: {
                this.drawLine(cell, offset);
                return;
            }
        }
        try {
            this.mergeCells(cell, map, offset, Xstart, Ystart);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void drawLine(BasicCell cell, int offset) {
        double lienWidth;
        XSSFSimpleShape line;
        this.getDrawing();
        XSSFDrawing drawing = (XSSFDrawing)this._sheet.getDrawingPatriarch();
        PWLine pwLine = (PWLine)cell.getValue();
        String direction = pwLine.getDirection();
        if ("H".equals(direction)) {
            XSSFClientAnchor anchor = new XSSFClientAnchor(0, Units.toEMU((double)StyleUtil.lomToPt(KPrintUtil.printPointToLom(cell.getHeight()))) / 2, Units.toEMU((double)StyleUtil.lomToPt(KPrintUtil.printPointToLom(cell.getWidth()))), Units.toEMU((double)StyleUtil.lomToPt(KPrintUtil.printPointToLom(cell.getHeight()))) / 2, cell.getX1() + 1, offset + cell.getY1() + 1, cell.getX2(), offset + cell.getY1() + 1);
            line = drawing.createSimpleShape(anchor);
            line.setShapeType(1);
            lienWidth = Math.min(KPrintUtil.printPointToLom(cell.getHeight()), pwLine.getRectangle().getHeight());
            line.setLineWidth(StyleUtil.lomToPt(lienWidth));
        } else {
            XSSFClientAnchor anchor = new XSSFClientAnchor(Units.toEMU((double)StyleUtil.lomToPt(KPrintUtil.printPointToLom(cell.getWidth()))) / 2, 0, Units.toEMU((double)StyleUtil.lomToPt(KPrintUtil.printPointToLom(cell.getWidth()))) / 2, Units.toEMU((double)StyleUtil.lomToPt(KPrintUtil.printPointToLom(cell.getHeight()))), cell.getX1() + 1, offset + cell.getY1() + 1, cell.getX1() + 1, offset + cell.getY2());
            line = drawing.createSimpleShape(anchor);
            line.setShapeType(1);
            lienWidth = Math.min(KPrintUtil.printPointToLom(cell.getWidth()), pwLine.getRectangle().getWidth());
            line.setLineWidth(StyleUtil.lomToPt(lienWidth));
        }
        Style style = pwLine.getStyle();
        PenStyle penStyle = style.getBorderPenStyle(Styles.Position.BOTTOM);
        if (PenStyle.PS_DOT.getName().equals(penStyle.getName())) {
            line.setLineStyle(2);
        } else if (PenStyle.PS_DASH.getName().equals(penStyle.getName())) {
            line.setLineStyle(3);
        }
        Color color = style.getBorderColor(Styles.Position.BOTTOM);
        line.setLineStyleColor(color.getRed(), color.getGreen(), color.getBlue());
    }

    private void outputImg(BasicCell cell, int offset, int Xstart, int Ystart) {
        String barcodeType;
        byte[] bytes = null;
        bytes = 1 == cell.getType() ? this.getImageData(cell) : ("QR_CODE".equals(barcodeType = (String)cell.getConfig().get("barcodeType")) ? this.getQRCodeData(cell) : this.getBarcodeData(cell));
        if (bytes == null) {
            return;
        }
        int pictureIdx = this.drawImage(bytes);
        if (this.drawing == null) {
            this.drawing = this._sheet.createDrawingPatriarch();
        }
        XSSFClientAnchor anchor = new XSSFClientAnchor(0, 0, Units.pixelToEMU((int)((int)cell.getWidth())), Units.pixelToEMU((int)((int)cell.getHeight())), (int)((short)(cell.getX1() + Xstart + 1)), cell.getY1() + offset + Ystart + 1, (int)((short)(cell.getX2() + Xstart)), cell.getY2() + offset + Ystart);
        this.drawing.createPicture((ClientAnchor)anchor, pictureIdx);
    }

    private byte[] getImageData(BasicCell cell) {
        Image img = cell.getImage();
        if (img == null) {
            return null;
        }
        byte[] bytes = null;
        Rectangle cellRect = new Rectangle(cell.getX1(), cell.getY1(), (int)cell.getWidth() - 2, (int)cell.getHeight() - 2);
        img = this.scaleImage(img, cellRect, cell.getScaleModel());
        Point position = this.caculatePos(img, cellRect, cell);
        BufferedImage image = new BufferedImage((int)cell.getWidth(), (int)cell.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        g2.drawImage(img, position.x + 1, position.y + 1, null);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", bos);
            bytes = bos.toByteArray();
            bos.close();
        }
        catch (IOException e) {
            this._log.error((Object)String.format(ResManager.loadKDString((String)"%s\u521b\u5efa\u56fe\u7247\u5931\u8d25\u3002", (String)"XlsHelper_1", (String)"bos-print-core", (Object[])new Object[0]), cell.getId()), (Throwable)e);
        }
        return bytes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getQRCodeData(BasicCell cell) {
        Map config = cell.getConfig();
        Rectangle2D.Float rc = (Rectangle2D.Float)config.get("painBounds");
        rc = (Rectangle2D.Float)rc.clone();
        config.put("suffix", "png");
        config.put("width", (int)Math.floor(rc.getWidth()));
        config.put("height", (int)Math.floor(rc.getHeight()));
        BarcodeFormat format = Enum.valueOf(BarcodeFormat.class, config.get("barcodeType").toString());
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            byte[] bytes;
            QRCodeUtils.generateBarcodePicture(os, format, config);
            byte[] byArray = bytes = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            this._log.error((Object)String.format(ResManager.loadKDString((String)"\u4e8c\u7ef4\u7801\u7ed8\u5236\u5f02\u5e38%s\u3002", (String)"XlsHelper_2", (String)"bos-print-core", (Object[])new Object[0]), e.getMessage() + Arrays.toString(e.getStackTrace())));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] getBarcodeData(BasicCell cell) {
        Map config = cell.getConfig();
        Integer dpi = (Integer)config.get("dpi");
        Rectangle2D.Float rc = (Rectangle2D.Float)config.get("painBounds");
        rc = (Rectangle2D.Float)rc.clone();
        Integer barcodeDpi = dpi;
        if (barcodeDpi == null) {
            barcodeDpi = 300;
        }
        double xDpis = barcodeDpi.intValue();
        double yDpis = barcodeDpi.intValue();
        double xScale = xDpis / (double)KPrintUtil.SCREEN_RESOLUTION;
        double yScale = yDpis / (double)KPrintUtil.SCREEN_RESOLUTION;
        BufferedImage bufferedImage = new BufferedImage((int)cell.getWidth(), (int)cell.getHeight(), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.scale(1.0 / xScale, 1.0 / yScale);
        try {
            rc.width = (float)((double)rc.width * xScale);
            rc.height = (float)((double)rc.height * yScale);
            this.drawBarcode(g2, config, rc);
        }
        finally {
            g2.scale(xScale, yScale);
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] bytes;
            ImageIO.write((RenderedImage)bufferedImage, "png", bos);
            byte[] byArray = bytes = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            this._log.error((Object)String.format(ResManager.loadKDString((String)"%s\u521b\u5efa\u6761\u7801\u5931\u8d25\u3002", (String)"XlsHelper_3", (String)"bos-print-core", (Object[])new Object[0]), cell.getId()), (Throwable)e);
            return null;
        }
    }

    private void drawBarcode(Graphics g, Map config, Rectangle2D.Float rc) {
        BarcodeUtils.paintBarcode(g, (int)Math.floor(rc.getWidth()), (int)Math.floor(rc.getHeight()), config);
    }

    private int drawImage(byte[] data) {
        Integer num = null;
        byte[] keys = this.getDigest().digest(data);
        ByteBuffer bytes = ByteBuffer.wrap(keys);
        Charset converter = Charset.forName("ASCII");
        String key = converter.decode(bytes).toString();
        num = (Integer)this.getImageCache().get(key);
        if (num == null) {
            int index = this._sheet.getWorkbook().addPicture(data, 5);
            this.getImageCache().put(key, index);
            num = index;
        }
        return num;
    }

    private void mergeCells(BasicCell cell, boolean[][] map, int offset, int Xstart, int Ystart) throws Exception {
        if (cell.getX2() - cell.getX1() <= 1 && cell.getY2() - cell.getY1() <= 1) {
            return;
        }
        for (int r = cell.getY1(); r < cell.getY2(); ++r) {
            for (int c = cell.getX1(); c < cell.getX2(); ++c) {
                if (map[r][c]) {
                    for (int c2 = c; c2 >= 0; --c2) {
                        map[r][c2] = false;
                    }
                    for (int r2 = r; r2 >= 0; --r2) {
                        for (int c2 = cell.getX2(); c2 >= 0; --c2) {
                            map[r][c2] = false;
                        }
                    }
                    throw new Exception(String.format(ResManager.loadKDString((String)"\u5185\u5bb9\u4e3a\uff1a%s\u7684\u5355\u5143\u4e0e\u5176\u5b83\u5355\u5143\u683c\u91cd\u53e0\uff0c\u8fd9\u53ef\u80fd\u662f\u6a21\u3002", (String)"XlsHelper_8", (String)"bos-print-core", (Object[])new Object[0]), cell.getText()));
                }
                map[r][c] = true;
            }
        }
        int firstRow = cell.getY1() + offset + Ystart + 1;
        int lastRow = cell.getY2() + offset + Ystart;
        int firstCol = cell.getX1() + Xstart + 1;
        int lastCol = cell.getX2() + Xstart;
        try {
            if (this.isFastModel) {
                this._sheet.addMergedRegionUnsafe(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
            } else {
                this._sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        CellStyle cellStyle = cell.getStyle();
        for (int r = firstRow; r <= lastRow; ++r) {
            for (int c = firstCol; c <= lastCol; ++c) {
                XSSFCellStyle xssfCellStyle;
                XSSFCellStyle newCellStyle;
                if (r == firstRow && c == firstCol) continue;
                Cell mergeCell = this._sheet.getRow(r).getCell(c);
                if (mergeCell == null) {
                    mergeCell = this._sheet.getRow(r).createCell(c);
                }
                CellStyle mergeCellStyle = mergeCell.getCellStyle();
                if (StyleHelper.isNullBorderBgStyle(cellStyle)) {
                    if (this.isFastModel) {
                        newCellStyle = this.styleCacheHelper.getMergeCellStyle(mergeCellStyle, cellStyle);
                        mergeCell.setCellStyle((CellStyle)newCellStyle);
                        continue;
                    }
                    if (mergeCellStyle instanceof XSSFCellStyle) {
                        xssfCellStyle = (XSSFCellStyle)mergeCellStyle;
                        mergeCellStyle = xssfCellStyle.copy();
                    }
                    StyleHelper.setContentStyle(mergeCellStyle, cellStyle);
                    mergeCell.setCellStyle(mergeCellStyle);
                    continue;
                }
                if (!(cellStyle instanceof XSSFCellStyle)) continue;
                if (this.isFastModel) {
                    newCellStyle = this.styleCacheHelper.getMergeCellStyle(cellStyle, cellStyle);
                    mergeCell.setCellStyle((CellStyle)newCellStyle);
                    continue;
                }
                xssfCellStyle = (XSSFCellStyle)cellStyle;
                cellStyle = xssfCellStyle.copy();
                mergeCell.setCellStyle(cellStyle);
            }
        }
    }

    private void setLabelXSSFCellStyle(Cell xlsCell, BasicCell cell) {
        if (this.isFastModel) {
            XSSFCellStyle labelXSSFCellStyle = this.styleCacheHelper.getLabelXSSFCellStyle(xlsCell, cell);
            if (!StyleHelper.isNullBorderBgStyle(xlsCell.getCellStyle()) && !StyleHelper.isNullBorderBgStyle(cell.getStyle())) {
                cell.setStyle((CellStyle)labelXSSFCellStyle);
            }
            xlsCell.setCellStyle((CellStyle)labelXSSFCellStyle);
            return;
        }
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getStyle();
        XSSFCellStyle xlsCellStyle = (XSSFCellStyle)xlsCell.getCellStyle();
        if (StyleHelper.isNullBorderBgStyle((CellStyle)xlsCellStyle)) {
            cellStyle = cellStyle.copy();
            xlsCell.setCellStyle((CellStyle)cellStyle);
        } else if (StyleHelper.isNullBorderBgStyle((CellStyle)cellStyle)) {
            StyleHelper.setContentStyle((CellStyle)xlsCellStyle, (CellStyle)cellStyle);
        } else {
            StyleHelper.setContentStyle((CellStyle)xlsCellStyle, (CellStyle)cellStyle);
            if (cellStyle.getBorderLeft() != BorderStyle.NONE) {
                xlsCellStyle.setBorderLeft(cellStyle.getBorderLeft());
                xlsCellStyle.setLeftBorderColor(cellStyle.getLeftBorderXSSFColor());
            }
            if (cellStyle.getBorderRight() != BorderStyle.NONE) {
                xlsCellStyle.setBorderRight(cellStyle.getBorderRight());
                xlsCellStyle.setRightBorderColor(cellStyle.getRightBorderXSSFColor());
            }
            if (cellStyle.getBorderTop() != BorderStyle.NONE) {
                xlsCellStyle.setBorderTop(cellStyle.getBorderTop());
                xlsCellStyle.setTopBorderColor(cellStyle.getTopBorderXSSFColor());
            }
            if (cellStyle.getBorderBottom() != BorderStyle.NONE) {
                xlsCellStyle.setBorderBottom(cellStyle.getBorderBottom());
                xlsCellStyle.setBottomBorderColor(cellStyle.getBottomBorderXSSFColor());
            }
            if (cellStyle.getFillPattern() != FillPatternType.NO_FILL) {
                xlsCellStyle.setFillPattern(cellStyle.getFillPattern());
                xlsCellStyle.setFillForegroundColor(cellStyle.getFillForegroundXSSFColor());
            }
            cell.setStyle((CellStyle)xlsCellStyle);
        }
    }

    private void setXSSContainerStyle(BasicCell cell, int offset, int Xstart, int Ystart) {
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getStyle();
        if (StyleHelper.isNullBorderBgStyle((CellStyle)cellStyle)) {
            return;
        }
        int firstRow = cell.getY1() + offset + Ystart + 1;
        int lastRow = cell.getY2() + offset + Ystart;
        int firstCol = cell.getX1() + Xstart + 1;
        int lastCol = cell.getX2() + Xstart;
        for (int r = firstRow; r <= lastRow; ++r) {
            for (int c = firstCol; c <= lastCol; ++c) {
                XSSFCellStyle containerXSSFCellStyle;
                Cell poiCell = this._sheet.getRow(r).getCell(c);
                boolean isNewCreate = false;
                if (poiCell == null) {
                    poiCell = this._sheet.getRow(r).createCell(c);
                    isNewCreate = true;
                }
                if (StyleHelper.isNullBorderBgStyle((CellStyle)(containerXSSFCellStyle = this.styleCacheHelper.getContainerXSSFCellStyle(cell, poiCell, isNewCreate, this._sheet, r == firstRow, r == lastRow, c == firstCol, c == lastCol)))) continue;
                poiCell.setCellStyle((CellStyle)containerXSSFCellStyle);
            }
        }
    }

    private void setXSSCFontainerStyle(BasicCell cell, int offset, int Xstart, int Ystart) {
        if (this.isFastModel) {
            this.setXSSContainerStyle(cell, offset, Xstart, Ystart);
            return;
        }
        XSSFCellStyle cellStyle = (XSSFCellStyle)cell.getStyle();
        if (StyleHelper.isNullBorderBgStyle((CellStyle)cellStyle)) {
            return;
        }
        BorderStyle borderLeft = cellStyle.getBorderLeft();
        XSSFColor borderLeftColor = cellStyle.getLeftBorderXSSFColor();
        BorderStyle borderRight = cellStyle.getBorderRight();
        XSSFColor borderRightColor = cellStyle.getRightBorderXSSFColor();
        BorderStyle borderTop = cellStyle.getBorderTop();
        XSSFColor borderTopColor = cellStyle.getTopBorderXSSFColor();
        BorderStyle borderBottom = cellStyle.getBorderBottom();
        XSSFColor borderBottomColor = cellStyle.getBottomBorderXSSFColor();
        int firstRow = cell.getY1() + offset + Ystart + 1;
        int lastRow = cell.getY2() + offset + Ystart;
        int firstCol = cell.getX1() + Xstart + 1;
        int lastCol = cell.getX2() + Xstart;
        for (int r = firstRow; r <= lastRow; ++r) {
            for (int c = firstCol; c <= lastCol; ++c) {
                String key;
                CellStyle cStyle;
                boolean newCreate = false;
                Cell poiCell = this._sheet.getRow(r).getCell(c);
                if (poiCell == null) {
                    poiCell = this._sheet.getRow(r).createCell(c);
                    newCreate = true;
                }
                if ((cStyle = (CellStyle)this.conStyleMap.get(key = StyleHelper.getContainerKey(poiCell, cell, firstRow, firstCol, r, c))) != null) {
                    poiCell.setCellStyle(cStyle);
                    continue;
                }
                XSSFCellStyle poiCellStyle = (XSSFCellStyle)this._sheet.getWorkbook().createCellStyle();
                CellStyle poiStyle = poiCell.getCellStyle();
                if (!newCreate) {
                    poiCellStyle.setBorderTop(poiStyle.getBorderTop());
                    poiCellStyle.setTopBorderColor(poiStyle.getTopBorderColor());
                    poiCellStyle.setBorderLeft(poiStyle.getBorderLeft());
                    poiCellStyle.setLeftBorderColor(poiStyle.getLeftBorderColor());
                    poiCellStyle.setBorderRight(poiStyle.getBorderRight());
                    poiCellStyle.setRightBorderColor(poiStyle.getRightBorderColor());
                    poiCellStyle.setBorderBottom(poiStyle.getBorderBottom());
                    poiCellStyle.setBottomBorderColor(poiStyle.getBottomBorderColor());
                }
                if (r == firstRow && borderTop != BorderStyle.NONE) {
                    poiCellStyle.setBorderTop(borderTop);
                    poiCellStyle.setTopBorderColor(borderTopColor);
                }
                if (r == lastRow && borderBottom != BorderStyle.NONE) {
                    poiCellStyle.setBorderBottom(borderBottom);
                    poiCellStyle.setBottomBorderColor(borderBottomColor);
                }
                if (c == firstCol && borderLeft != BorderStyle.NONE) {
                    poiCellStyle.setBorderLeft(borderLeft);
                    poiCellStyle.setLeftBorderColor(borderLeftColor);
                }
                if (c == lastCol && borderRight != BorderStyle.NONE) {
                    poiCellStyle.setBorderRight(borderRight);
                    poiCellStyle.setRightBorderColor(borderRightColor);
                }
                if (cellStyle.getFillPattern() == FillPatternType.NO_FILL) {
                    if (poiStyle instanceof XSSFCellStyle) {
                        poiCellStyle.setFillForegroundColor((XSSFColor)poiStyle.getFillForegroundColorColor());
                    } else {
                        poiCellStyle.setFillForegroundColor(poiStyle.getFillForegroundColor());
                    }
                    poiCellStyle.setFillPattern(poiStyle.getFillPattern());
                } else {
                    poiCellStyle.setFillForegroundColor(cellStyle.getFillForegroundColorColor());
                    poiCellStyle.setFillPattern(cellStyle.getFillPattern());
                }
                StyleHelper.setContentStyle((CellStyle)poiCellStyle, (CellStyle)cellStyle);
                poiCell.setCellStyle((CellStyle)poiCellStyle);
                this.conStyleMap.put(key, poiCellStyle);
            }
        }
    }

    private static int reduce(double num, float var) {
        return (int)(num *= (double)var);
    }

    private static short getRowHeight(double height, float var) {
        double num = 0.1 * KPrintUtil.printPointToLom(height);
        num = num * 72.0 * 20.0 / 25.39999918;
        return (short)XlsHelper.reduce(num, var);
    }

    private static short getRowHeight(double height) {
        return XlsHelper.getRowHeight(height, 1.0f);
    }

    private static int getColWidth(double width, float var) {
        double num = 0.1 * KPrintUtil.printPointToLom(width);
        num = num * 12.0 * 256.0 / 25.39999918;
        return XlsHelper.reduce(num, var);
    }

    private static int getColWidth(double width) {
        return XlsHelper.getColWidth(width, 1.0f);
    }

    public Map getImageCache() {
        if (this._imageCache == null) {
            this._imageCache = new HashMap();
        }
        return this._imageCache;
    }

    public MessageDigest getDigest() {
        if (this._digest == null) {
            try {
                this._digest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException e) {
                this._log.error((Object)ResManager.loadKDString((String)"\u627e\u4e0d\u5230SHAMessageDigest\u2014\u2014\u56fe\u7247\u7f13\u5b58\u3002", (String)"XlsHelper_7", (String)"bos-print-core", (Object[])new Object[0]));
            }
        }
        return this._digest;
    }

    private Image scaleImage(Image image, Rectangle cellRect, int mode) {
        if (mode == 1) {
            image = image.getScaledInstance((int)cellRect.getWidth(), (int)cellRect.getHeight(), 1);
        }
        if (mode == 3) {
            int imageHeight;
            double yRate;
            double rate;
            int imageWidth = image.getWidth(null);
            double xRate = (double)imageWidth / (double)cellRect.width;
            double d = rate = xRate > (yRate = (double)(imageHeight = image.getHeight(null)) / (double)cellRect.height) ? xRate : yRate;
            if (rate == xRate) {
                imageWidth = cellRect.width;
                imageHeight = (int)((double)imageHeight / rate);
            } else {
                imageWidth = (int)((double)imageWidth / rate);
                imageHeight = cellRect.height;
            }
            image = image.getScaledInstance(imageWidth, imageHeight, 4);
            this.waitForImage(new CellImageRender(), image);
        }
        return image;
    }

    private void waitForImage(Component comp, Image image) {
        try {
            MediaTracker tracker = new MediaTracker(comp);
            tracker.addImage(image, 0);
            tracker.waitForID(0);
        }
        catch (InterruptedException err) {
            this._log.error((Object)ResManager.loadKDString((String)"\u4e2d\u65ad\u5f02\u5e38\u3002", (String)"XlsHelper_9", (String)"bos-print-core", (Object[])new Object[0]), (Throwable)err);
        }
        comp = null;
    }

    private Point caculatePos(Image image, Rectangle cellRect, BasicCell cell) {
        Point pos = new Point(0, 0);
        CellStyle style = cell.getStyle();
        if (image != null) {
            int imageWidth = image.getWidth(null);
            int imageHeight = image.getHeight(null);
            if (style == null) {
                pos.x = 0;
                pos.y = 0;
                return pos;
            }
            if (style.getAlignment() == HorizontalAlignment.CENTER) {
                pos.x += (cellRect.width - imageWidth) / 2;
            } else if (style.getAlignment() == HorizontalAlignment.RIGHT) {
                pos.x += cellRect.width - imageWidth;
            }
            if (style.getVerticalAlignment() == VerticalAlignment.CENTER) {
                pos.y += (cellRect.height - imageHeight) / 2;
            } else if (style.getVerticalAlignment() == VerticalAlignment.BOTTOM) {
                pos.y += cellRect.height - imageHeight;
            }
        }
        return pos;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setLastRow(int lastRow) {
        this.lastRow = lastRow;
    }
}

