/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.print.xls.output;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.bos.print.core.ctrl.print.xls.widget.XlsPaper;
import org.apache.log4j.Logger;

public class XlsNodeContainer {
    private int _limit = 10;
    private List _nodeCache;
    private int _size = 0;
    private RandomAccessFile _file;
    private Logger _log = Logger.getLogger(XlsNodeContainer.class);
    private boolean _reachLimit = false;
    private FileInputStream _is = null;

    public XlsNodeContainer(int count) {
        this._limit = count;
        this._nodeCache = new ArrayList(count);
    }

    public void add(XlsPaper node) {
        this._nodeCache.add(node);
        ++this._size;
    }

    public void clear() {
        try {
            if (this._file != null) {
                this._file.close();
                this._file = null;
            }
            if (this._is != null) {
                this._is.close();
            }
            this._size = 0;
            this._nodeCache.clear();
            this._reachLimit = false;
        }
        catch (IOException e) {
            this._log.error((Object)"XlsNodeContainer clear faild");
        }
    }

    public Iterator iterator() {
        return new Iterator(){
            private int _currentIndex = 0;

            @Override
            public boolean hasNext() {
                return XlsNodeContainer.this._size > 0;
            }

            public Object next() {
                Object obj = null;
                obj = XlsNodeContainer.this._nodeCache.get(this._currentIndex);
                return obj;
            }

            @Override
            public void remove() {
                XlsNodeContainer.this._nodeCache.remove(this._currentIndex);
                XlsNodeContainer.this._size--;
            }
        };
    }

    public int size() {
        return this._size;
    }
}

