/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.swing.ImageIcon;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.util.StreamUtil;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.kdf.util.BMPReader;

public class ImageUtil {
    private static final Log log = LogFactory.getLog(ImageUtil.class);

    public static Number[] calcImageSize(int imageWidth, int imageHeight, int boxWidth, int boxHeight) {
        float b1 = (float)imageWidth / (float)boxWidth;
        float b2 = (float)imageHeight / (float)boxHeight;
        if (b1 <= 1.0f && b2 <= 1.0f) {
            return new Number[]{imageWidth, imageHeight};
        }
        if (b1 <= 1.0f && b2 > 1.0f) {
            return new Number[]{Float.valueOf((float)imageWidth / b2), boxHeight};
        }
        if (b1 > 1.0f && b2 < 1.0f) {
            return new Number[]{boxWidth, Float.valueOf((float)imageHeight / b1)};
        }
        float b = b1 > b2 ? b1 : b2;
        return new Number[]{Float.valueOf((float)imageWidth / b), Float.valueOf((float)imageHeight / b)};
    }

    public static Image getImage(String str) {
        byte[] bytes = ImageUtil.getImageByteContent(str);
        if (bytes != null) {
            return ImageUtil.makeImage(bytes);
        }
        return null;
    }

    public static final Image makeImage(byte[] data) {
        if (data.length > 1 && data[0] == 66 && data[1] == 77) {
            return BMPReader.loadBitMap(data);
        }
        return new ImageIcon(data).getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getImageByteContent(String str) {
        if (!StringUtil.isEmptyString(str)) {
            String filePath = str;
            if (str.startsWith("file://")) {
                filePath = str.substring(7);
            }
            InputStream in = null;
            try {
                in = new FileInputStream(new File(filePath));
            }
            catch (FileNotFoundException e) {
                log.warn("The file below is not found: " + filePath, (Throwable)e);
                byte[] byArray = new byte[]{};
                return byArray;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        log.warn("Read Picture I/O error.", (Throwable)e);
                    }
                }
            }
            byte[] content = null;
            try {
                content = StreamUtil.readInputStream(in);
                return content;
            }
            catch (IOException e1) {
                log.warn("Read Picture I/O error.", (Throwable)e1);
            }
        }
        return new byte[0];
    }

    public static byte[] getImageByUrl(String imageUrl) {
        return ExecuteService.getAttachService().getImage(imageUrl);
    }

    @Deprecated
    public static byte[] readImageFromNet(String fullUrl) throws IOException {
        return ExecuteService.getAttachService().getImage(fullUrl);
    }

    public static String getImageBase64StringByBytes(byte[] args) {
        String imageString = "";
        if (args != null) {
            Base64.Encoder encoder1 = Base64.getEncoder();
            imageString = "data:image/jpeg;base64," + encoder1.encodeToString(args);
        }
        return imageString;
    }

    private static String getHtmlImageString(String imageString) {
        return "<img style='width:100%;height:100%'  src=\"" + imageString + "\"/>";
    }

    public static String getHtmlImageDisplayStringByBuytes(byte[] args) {
        return ImageUtil.getHtmlImageString(ImageUtil.getImageBase64StringByBytes(args));
    }

    public static Rectangle calculateAutomatic(byte[] content, Rectangle cellRect) {
        int imageHeight;
        double yRate;
        double rate;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.createImage(content);
        int imageWidth = ImageUtil.getDelayWidth(image);
        double xRate = (double)imageWidth / (double)cellRect.width;
        double d = rate = xRate > (yRate = (double)(imageHeight = ImageUtil.getDelayHeight(image)) / (double)cellRect.height) ? xRate : yRate;
        if (rate == xRate) {
            imageWidth = cellRect.width;
            imageHeight = (int)((double)imageHeight / rate);
        } else {
            imageWidth = (int)((double)imageWidth / rate);
            imageHeight = cellRect.height;
        }
        return new Rectangle(cellRect.x, cellRect.y, imageWidth, imageHeight);
    }

    private static int getDelayWidth(Image image) {
        int imageWidth = -1;
        for (int i = 0; imageWidth == -1 && i <= 10000; ++i) {
            imageWidth = image.getWidth(null);
        }
        return imageWidth;
    }

    private static int getDelayHeight(Image image) {
        int imageHeight = -1;
        for (int i = 0; imageHeight == -1 && i <= 10000; ++i) {
            imageHeight = image.getHeight(null);
        }
        return imageHeight;
    }

    public static BufferedImage rotateImage(Image src, int angel) {
        int src_width = src.getWidth(null);
        int src_height = src.getHeight(null);
        Rectangle rect_des = ImageUtil.CalcRotatedSize(new Rectangle(new Dimension(src_width, src_height)), angel);
        BufferedImage res = null;
        res = new BufferedImage(rect_des.width, rect_des.height, 1);
        Graphics2D g2 = res.createGraphics();
        g2.translate((rect_des.width - src_width) / 2, (rect_des.height - src_height) / 2);
        g2.rotate(Math.toRadians(angel), src_width / 2, src_height / 2);
        g2.drawImage(src, null, null);
        return res;
    }

    public static Rectangle CalcRotatedSize(Rectangle src, int angel) {
        if (angel >= 90) {
            if (angel / 90 % 2 == 1) {
                int temp = src.height;
                src.height = src.width;
                src.width = temp;
            }
            angel %= 90;
        }
        double r = Math.sqrt(src.height * src.height + src.width * src.width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(angel) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(angel)) / 2.0;
        double angel_dalta_width = Math.atan((double)src.height / (double)src.width);
        double angel_dalta_height = Math.atan((double)src.width / (double)src.height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = src.width + len_dalta_width * 2;
        int des_height = src.height + len_dalta_height * 2;
        return new Rectangle(new Dimension(des_width, des_height));
    }
}

