/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common;

import java.awt.Dimension;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.exception.PrintException;

public class R1PrintInfo
implements Serializable {
    public static final String PORTRAIT = "PORTRAIT";
    public static final String LANDSCAPE = "LANDSCAPE";
    public static final String CustomPaper = "Custom";
    private static final String CUSTOM = "custom";
    public static final String[] CustomPapers = new String[]{"custom", "KP-J101", "KP-J102", "KP-J103", "KP-J104", "KP-J105", "KP-J106", "KP-J107", "KP-J108", "KP-J109"};
    private static final String HEIGHT = "height";
    private static final long serialVersionUID = -2302309186597731383L;
    public static final String Key_PrintInfo = "pi";
    private String paperName = "iso-a4";
    private String orientation = "PORTRAIT";
    private int paperWidth = 2100;
    private int paperHeight = 2970;
    private int marginLeft = 190;
    private int marginRight = 190;
    private int marginTop = 250;
    private int marginBottom = 250;
    private int headerHeight = 150;
    private int headerMargin = 100;
    private int footerHeight = 0;
    private int footerMargin = 100;
    private boolean isDynamicPaperValue;
    private boolean isVerEconomizePaperValue;
    private boolean isHorEconomizePaperValue;
    private int verPageSpace = 0;
    private int horPageSpace = 0;
    private String pageNumType;
    private boolean haveBackgroundPicture;
    private String bgImageUrl;
    private int bgWidth;
    private int bgHeight;
    private boolean showBgImage;

    public static String[] getAllPaperNames() {
        return new MyMediaSizeName().getStringTable();
    }

    @Deprecated
    public static R1PrintInfo readFromMeta(Object metadata) {
        return new R1PrintInfo();
    }

    public static Dimension getPaperSize(String paperName) {
        String newName = "";
        switch (paperName) {
            case "B5": {
                newName = "iso-b5";
                break;
            }
            case "A3": {
                newName = "iso-a3";
                break;
            }
            case "A4": {
                newName = "iso-a4";
                break;
            }
            default: {
                newName = paperName;
            }
        }
        MediaSize ms = null;
        try {
            Class<?> clazz = Class.forName("kd.bos.print.core.ctrl.print.util.KDPrinterUtils");
            Method method = clazz.getMethod("getMediaSizeForName", MediaSizeName.class);
            Object invokeVal = method.invoke(null, newName);
            ms = (MediaSize)invokeVal;
        }
        catch (Exception e) {
            throw new PrintException(ResManager.loadKDString((String)"\u53cd\u5c04getMediaSizeForName\u5931\u8d25\u3002", (String)"XlsExport_5", (String)"bos-print-core", (Object[])new Object[0]), e);
        }
        int w = (int)ms.getX(1000) * 10;
        int h = (int)ms.getY(1000) * 10;
        return new Dimension(w, h);
    }

    public R1PrintInfo() {
    }

    public R1PrintInfo(R1PrintInfo old) {
        this.paperName = old.paperName;
        this.orientation = old.orientation;
        this.paperWidth = old.paperWidth;
        this.paperHeight = old.paperHeight;
        this.marginLeft = old.marginLeft;
        this.marginRight = old.marginRight;
        this.marginTop = old.marginTop;
        this.marginBottom = old.marginBottom;
        this.headerHeight = old.headerHeight;
        this.headerMargin = old.headerMargin;
        this.footerHeight = old.footerHeight;
        this.footerMargin = old.footerMargin;
        this.isDynamicPaperValue = old.isDynamicPaperValue;
        this.isVerEconomizePaperValue = old.isVerEconomizePaperValue;
        this.isHorEconomizePaperValue = old.isHorEconomizePaperValue;
        this.horPageSpace = old.horPageSpace;
        this.verPageSpace = old.verPageSpace;
        this.haveBackgroundPicture = old.haveBackgroundPicture;
    }

    public String getPaperName() {
        return this.paperName;
    }

    public void setPaperName(String name) {
        this.paperName = name;
    }

    public boolean isCustomPaper() {
        return StringUtil.equalsIgnoreCase(this.getPaperName(), CustomPaper);
    }

    public void setPaperWidth(int paperWidth) {
        this.paperWidth = paperWidth;
    }

    public void setPaperHeight(int paperHeight) {
        this.paperHeight = paperHeight;
    }

    public void setCustomPaper(int width, int height) {
        this.setPaperName(CustomPaper);
        this.paperWidth = width;
        this.paperHeight = height;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public int getCustomWidth() {
        return this.paperWidth;
    }

    public int getCustomHeight() {
        return this.paperHeight;
    }

    public Dimension getPaperSize() {
        return new Dimension(this.paperWidth, this.paperHeight);
    }

    public Dimension getPrintablePaperSize() {
        int height;
        int width;
        Dimension paperSize = this.getPaperSize();
        if (this.getOrientation().equals(LANDSCAPE)) {
            width = paperSize.height;
            height = paperSize.width;
        } else {
            width = paperSize.width;
            height = paperSize.height;
        }
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public Dimension getPrintableAreaSize() {
        Dimension paperSize = this.getPaperSize();
        int width = paperSize.width - this.getMarginLeft() - this.getMarginRight();
        int height = paperSize.height - this.getMarginTop() - this.getMarginBottom();
        if (width < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        return new Dimension(width, height);
    }

    public void setPrintableAreaSize(Dimension pageSize) {
        int height;
        int width;
        if (this.getOrientation().equals(LANDSCAPE)) {
            width = pageSize.height + this.getMarginTop() + this.getMarginBottom();
            height = pageSize.width + this.getMarginLeft() + this.getMarginRight();
        } else {
            width = pageSize.width + this.getMarginLeft() + this.getMarginRight();
            height = pageSize.height + this.getMarginTop() + this.getMarginBottom();
        }
        this.setCustomPaper(width, height);
    }

    public void setMarginLeft(int value) {
        this.marginLeft = value;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginRight(int value) {
        this.marginRight = value;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginTop(int value) {
        this.marginTop = value;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginBottom(int value) {
        this.marginBottom = value;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public boolean isDynamicPaper() {
        if (this.isVerEconomizePaper() || this.isHorEconomizePaper()) {
            return false;
        }
        return this.isDynamicPaperValue;
    }

    public void setDynamicPaper(boolean value) {
        if (!this.isVerEconomizePaper() && !this.isHorEconomizePaper()) {
            this.isDynamicPaperValue = value;
        }
    }

    public int getHeaderHeight() {
        return this.headerHeight;
    }

    public void setHeaderHeight(int value) {
        this.headerHeight = value;
    }

    public int getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(int value) {
        this.headerMargin = value;
    }

    public int getFooterHeight() {
        return this.footerHeight;
    }

    public void setFooterHeight(int value) {
        this.footerHeight = value;
    }

    public int getFooterMargin() {
        return this.footerMargin;
    }

    public void setFooterMargin(int value) {
        this.footerMargin = value;
    }

    public boolean getHaveBackground() {
        return this.haveBackgroundPicture;
    }

    public void setHaveBackground(boolean value) {
        this.haveBackgroundPicture = value;
    }

    public boolean isVerEconomizePaper() {
        return this.isVerEconomizePaperValue;
    }

    public void setVerEconomizePaper(boolean value) {
        this.isVerEconomizePaperValue = value;
    }

    public boolean isHorEconomizePaper() {
        return this.isHorEconomizePaperValue;
    }

    public void setHorEconomizePaper(boolean value) {
        this.isHorEconomizePaperValue = value;
    }

    public int getHorPageSpace() {
        return this.horPageSpace;
    }

    public void setHorPageSpace(int value) {
        this.horPageSpace = value;
    }

    public int getVerPageSpace() {
        return this.verPageSpace;
    }

    public void setVerPageSpace(int value) {
        this.verPageSpace = value;
    }

    public String getPageNumType() {
        return this.pageNumType;
    }

    public void setPageNumType(String pageNumType) {
        this.pageNumType = pageNumType;
    }

    public String getBgImageUrl() {
        return this.bgImageUrl;
    }

    public void setBgImageUrl(String bgImageUrl) {
        this.bgImageUrl = bgImageUrl;
    }

    public int getBgWidth() {
        return this.bgWidth;
    }

    public void setBgWidth(int bgWidth) {
        this.bgWidth = bgWidth;
    }

    public int getBgHeight() {
        return this.bgHeight;
    }

    public void setBgHeight(int bgHeight) {
        this.bgHeight = bgHeight;
    }

    public boolean isShowBgImage() {
        return this.showBgImage;
    }

    public void setShowBgImage(boolean showBgImage) {
        this.showBgImage = showBgImage;
    }

    static class MyMediaSizeName
    extends MediaSizeName {
        protected MyMediaSizeName() {
            super(0);
        }

        @Override
        public String[] getStringTable() {
            return super.getStringTable();
        }
    }
}

