/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.reportone.r1.print.common.currency;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TreeSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.currency.ICurrencyUpperFunction;
import kd.bos.print.core.ctrl.common.util.StringUtil;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.ctrl.kdf.formatter.NumberTranslate;
import kd.bos.print.core.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import kd.bos.print.core.ctrl.reportone.r1.print.common.currency.CurrencyFormatInfo;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class CurrencyFormatManager {
    private static final Log log = LogFactory.getLog(CurrencyFormatManager.class);
    private static NumberTranslate numberTranslate = new NumberTranslate(PRCChineseBigNumberResource.getInstance());
    private static CurrencyFormatManager instance;
    private HashMap _infos;

    private String getMsError() {
        return ResManager.loadKDString((String)"\u5b9e\u4f8b\u5316\u91d1\u989d\u5927\u5199\u683c\u5f0f\u5316\u51fd\u6570\u5f02\u5e38\u3002", (String)"CurrencyFormatManager_0", (String)"bos-print-core", (Object[])new Object[0]);
    }

    public static CurrencyFormatManager shareInstance() {
        if (instance == null) {
            instance = new CurrencyFormatManager();
        }
        return instance;
    }

    private HashMap getInfos() {
        if (this._infos == null) {
            this._infos = new HashMap();
            Element root = this.loadConfigFile();
            if (root != null) {
                this.parseConfigFile(root, this._infos);
            }
        }
        return this._infos;
    }

    private Element loadConfigFile() {
        Element root = null;
        try (InputStream is = CurrencyFormatManager.class.getResourceAsStream("/PrtCurrencyformat.xml");){
            root = CurrencyFormatManager.loadXmlStream(is);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return root;
    }

    private static Element loadXmlStream(InputStream is) throws IOException, DocumentException {
        SAXReader builder = new SAXReader();
        Document doc = null;
        try {
            doc = builder.read(is);
        }
        catch (DocumentException je) {
            log.error((Throwable)je);
            throw je;
        }
        if (doc != null) {
            return doc.getRootElement();
        }
        return null;
    }

    private void parseConfigFile(Element xmlRoot, HashMap mapInfos) {
        Element nodeFuncs = xmlRoot.element("UpperFormatFunctions");
        Element nodeCodes = xmlRoot.element("Codes");
        HashMap<String, ICurrencyUpperFunction> mapFuncs = new HashMap<String, ICurrencyUpperFunction>();
        Iterator itFuncs = nodeFuncs.elementIterator();
        while (itFuncs.hasNext()) {
            ICurrencyUpperFunction func;
            Element nodeFunc = (Element)itFuncs.next();
            String id = nodeFunc.attributeValue("id");
            String funcClassName = nodeFunc.attributeValue("function");
            if (StringUtils.isEmpty((CharSequence)id) || StringUtils.isEmpty((CharSequence)funcClassName) || (func = this.createUpperFunction(funcClassName)) == null) continue;
            mapFuncs.put(id, func);
        }
        Iterator itCodes = nodeCodes.elementIterator();
        while (itCodes.hasNext()) {
            Element nodeCode = (Element)itCodes.next();
            String id = nodeCode.attributeValue("id");
            String symbol = nodeCode.attributeValue("symbol");
            String upperPrefix = nodeCode.attributeValue("upperPrefix");
            String upperFunc = nodeCode.attributeValue("upperFunction");
            if (StringUtil.isEmptyString(id)) continue;
            CurrencyFormatInfo info = new CurrencyFormatInfo();
            info.setCurrencyCode(id);
            info.setSymbol(symbol);
            info.setUpperPrefix(upperPrefix);
            info.setUpperFunction((ICurrencyUpperFunction)mapFuncs.get(upperFunc));
            mapInfos.put(id, info);
        }
    }

    private ICurrencyUpperFunction createUpperFunction(String className) {
        ICurrencyUpperFunction func = null;
        try {
            func = (ICurrencyUpperFunction)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.error(String.format(this.getMsError(), className), (Throwable)e);
        }
        return func;
    }

    public String getSymbol(String code) {
        CurrencyFormatInfo info = (CurrencyFormatInfo)this.getInfos().get(code);
        if (info != null) {
            return info.getSymbol();
        }
        return "";
    }

    public ICurrencyUpperFunction getUpperFunction(String code) {
        CurrencyFormatInfo info = (CurrencyFormatInfo)this.getInfos().get(code);
        if (info != null) {
            return info.getUpperFunction();
        }
        return new DefaultUpperFunction();
    }

    public String upperFomat(String code, Locale locale, Variant value, boolean isAddPrefix) {
        return this.getUpperFunction(code).format(locale, value, isAddPrefix);
    }

    public String upperFomat(String num) {
        return numberTranslate.toNumber(num);
    }

    public String[] getAllCodes() {
        TreeSet set = new TreeSet(this.getInfos().keySet());
        return set.toArray(new String[0]);
    }

    static class DefaultUpperFunction
    implements ICurrencyUpperFunction {
        DefaultUpperFunction() {
        }

        @Override
        public String format(Locale locale, Variant variant, boolean isAddPrefix) {
            CurrencyFormatManager formater = CurrencyFormatManager.shareInstance();
            String num = variant.toString();
            num = num.replace(",", "");
            return formater.upperFomat(num);
        }
    }
}

