/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.ctrl.swing;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.font.TextAttribute;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteService;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.service.PrtFont;

public class KDFont
extends Font {
    private static final Log log = LogFactory.getLog(KDFont.class);
    private static final long serialVersionUID = -5008956562051634709L;
    private static int currentDpi = -1;
    private static String[] sysFamilyName;
    private float realSize;
    private static boolean isTableMode;
    private static boolean isFormDrawing;
    private Font formFont = null;

    private static LocalMemoryCache getFontLocalCache() {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(86400);
        info.setMaxMemSize(1000);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "KDFontCache", info);
    }

    private static int getCurrentDpi() {
        if (currentDpi == -1) {
            currentDpi = KDToolkit.getCurrentDpi();
        }
        return currentDpi;
    }

    @Deprecated
    public KDFont(String name, int style, int size) {
        super(name, style, Math.round((float)size * (float)KDFont.getCurrentDpi() / 72.0f));
        this.realSize = size;
    }

    public KDFont(String name, int style, float size) {
        super(name, style, Math.round(size * (float)KDFont.getCurrentDpi() / 72.0f));
        this.realSize = size;
    }

    public KDFont(Map attributes) {
        super(attributes);
        Object obj = attributes.get(TextAttribute.SIZE);
        if (obj instanceof Integer) {
            this.realSize = ((Integer)obj).floatValue();
            this.realSize = BigDecimal.valueOf(this.realSize * 72.0f / (float)KDFont.getCurrentDpi()).setScale(2, RoundingMode.UP).floatValue();
        } else {
            this.realSize = obj instanceof Float ? BigDecimal.valueOf(((Float)obj).floatValue() * 72.0f / (float)KDFont.getCurrentDpi()).setScale(2, RoundingMode.UP).floatValue() : 12.0f;
        }
    }

    @Override
    @Deprecated
    public int getSize() {
        return (int)this.realSize;
    }

    @Override
    public float getSize2D() {
        return this.realSize;
    }

    public Font deriveFont(Map attributes) {
        Map<TextAttribute, ?> newAttrs = this.getAttributes();
        AttributedCharacterIterator.Attribute[] validAttribs = this.getAvailableAttributes();
        for (int i = 0; i < validAttribs.length; ++i) {
            Object obj = attributes.get(validAttribs[i]);
            if (obj == null) continue;
            newAttrs.put((TextAttribute)validAttribs[i], obj);
        }
        return new KDFont(newAttrs);
    }

    public static void setTableMode(boolean is) {
        isTableMode = is;
    }

    public static void setFormDrawing(boolean is) {
        isFormDrawing = is;
    }

    public Font getFont() {
        if (isTableMode || !isFormDrawing) {
            return this;
        }
        if (this.formFont == null) {
            this.formFont = this.deriveFont(this.realSize);
        }
        return this.formFont;
    }

    @Deprecated
    public static Font loadFontFromJAR(String name, int style, int size) {
        return KDFont.loadFontFromJAR(name, style, (float)size);
    }

    public static Font loadFontFromJAR(String name, int style, float size) {
        return KDFont.createFont(name, style, size);
    }

    @Deprecated
    public static Font createFont(String name, int style, int size) {
        return KDFont.createFont(name, style, (float)size);
    }

    public static Font createFont(String name, int style, float size) {
        List<PrtFont> fonts = ExecuteService.getFontService().getFonts();
        String finalName = name;
        Optional<PrtFont> option = fonts.stream().filter(prtFont -> StringUtils.equals((CharSequence)prtFont.getFontName(), (CharSequence)finalName)).findAny();
        Font font = null;
        font = !option.isPresent() ? KDFont.loadFont(ExecuteService.getDefaultFont()) : KDFont.loadFont(option.get());
        if (font != null) {
            return font.deriveFont(style, size);
        }
        return null;
    }

    private static Font loadFont(PrtFont prtFont) {
        Font font;
        String name;
        block7: {
            PrtFont defaultFont = ExecuteService.getDefaultFont();
            name = prtFont.getFontName();
            font = null;
            if (KDFont.getFontLocalCache().contains(name)) {
                return (Font)KDFont.getFontLocalCache().get(name);
            }
            if (StringUtils.equals((CharSequence)defaultFont.getFontName(), (CharSequence)name)) {
                return KDFont.loadDefaultFont();
            }
            String fileName = prtFont.getFontFileName();
            String fontDir = ExecuteService.getFontService().getFontFilesDir();
            String fileFullName = fontDir + File.separator + fileName;
            File fontFile = new File(fileFullName);
            boolean fontExist = fontFile.exists();
            if (!fontExist) {
                fontFile = ExecuteService.getFontService().downloadFont(prtFont);
                fontExist = fontFile.exists();
            }
            if (fontExist) {
                try {
                    font = Font.createFont(0, fontFile);
                    KDFont.getFontLocalCache().put(name, (Object)font);
                }
                catch (Exception e) {
                    log.warn("\u521b\u5efa\u5b57\u4f53\u5931\u8d25:" + e);
                    if (!(e instanceof FontFormatException) && !(e instanceof IOException) || !fontFile.exists() || fontFile.delete()) break block7;
                    log.info("\u5f02\u5e38\u5b57\u4f53\u5220\u9664\u5931\u8d25\uff1a" + fontFile.getAbsolutePath());
                }
            }
        }
        if (font != null) {
            return font;
        }
        Font loadDefaultFont = KDFont.loadDefaultFont();
        KDFont.getFontLocalCache().put(name, (Object)loadDefaultFont);
        return loadDefaultFont;
    }

    public static Font loadDefaultFont() {
        Font font;
        block30: {
            font = null;
            PrtFont defaultFont = ExecuteService.getDefaultFont();
            String name = defaultFont.getFontName();
            if (KDFont.getFontLocalCache().contains(name)) {
                return (Font)KDFont.getFontLocalCache().get(name);
            }
            String fontDir = ExecuteService.getFontService().getFontFilesDir();
            String fileName = defaultFont.getFontFileName();
            String fullFontPath = fontDir + File.separatorChar + fileName;
            File fontFile = new File(fullFontPath);
            try {
                if (!fontFile.exists()) {
                    try (InputStream ios = KDFont.class.getClassLoader().getResourceAsStream(fileName);){
                        fontFile.createNewFile();
                        try (FileOutputStream fos = new FileOutputStream(fontFile);){
                            byte[] bytes = new byte[1024];
                            int index = 0;
                            while ((index = ios.read(bytes)) != -1) {
                                fos.write(bytes, 0, index);
                                fos.flush();
                            }
                            ios.close();
                        }
                    }
                    log.debug("\u6253\u5370\uff1a \u5df2\u6210\u529f\u5c06\u9ed8\u8ba4\u5b57\u4f53\u5199\u5165\u5b57\u4f53\u76ee\u5f55 :" + fontFile.getPath());
                }
                font = Font.createFont(0, fontFile);
                KDFont.getFontLocalCache().put(font.getFontName(), (Object)font);
                KDFont.getFontLocalCache().put(defaultFont.getFontName(), (Object)font);
                KDFont.getFontLocalCache().put(defaultFont.getFontCode(), (Object)font);
            }
            catch (Exception e) {
                log.warn((Throwable)e);
                if (!(e instanceof FontFormatException) && !(e instanceof IOException) || !fontFile.exists() || fontFile.delete()) break block30;
                log.info("\u5f02\u5e38\u5b57\u4f53\u5220\u9664\u5931\u8d25\uff1a" + fontFile.getAbsolutePath());
            }
        }
        return font;
    }

    public static synchronized boolean isSystemDefineFont(String name) {
        if (sysFamilyName == null || sysFamilyName.length != 0) {
            sysFamilyName = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        }
        for (int i = 0; i < sysFamilyName.length; ++i) {
            if (!sysFamilyName[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    static {
        isTableMode = false;
        isFormDrawing = false;
    }
}

