/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.utils.FilterUtil;

public class FormDataVisitor
extends R1PDataVisitor {
    public FormDataVisitor(PrtDataSource ds) {
        super(ds);
    }

    @Override
    public CollectionField getCollectionField(String ds) {
        return this.getCollectionField(ds, true);
    }

    @Override
    public CollectionField getCollectionField(String ds, boolean sortAble) {
        return this.getCollectionField(ds, sortAble, null);
    }

    @Override
    public CollectionField getCollectionField(String ds, String controlKey) {
        return this.getCollectionField(ds, true, controlKey);
    }

    @Override
    public CollectionField getCollectionField(String ds, boolean sortAble, String controlKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return new CollectionField();
        }
        if (StringUtils.equals((CharSequence)ds, (CharSequence)this.dataSource.getDsName())) {
            return new CollectionField(this.cacheRows);
        }
        String key = ds.substring(ds.lastIndexOf(46) + 1);
        Field field = ((DataRowSet)this.cacheRows.get(this.cursor)).getField(key);
        if (field instanceof CollectionField) {
            CollectionField entryField = (CollectionField)field;
            CollectionField collectionField = FilterUtil.filter(this.dataSource, ds, controlKey, (List<DataRowSet>)entryField.getValue());
            return sortAble ? new CollectionField(this.executeSort((List<DataRowSet>)collectionField.getValue(), ds, controlKey)) : collectionField;
        }
        PrtDataSource prtDataSource = this.searchDs(ds);
        if (prtDataSource == null) {
            return CollectionField.EMPTY_LIST;
        }
        DsType dsType = prtDataSource.getDsType();
        EntityType entityType = ((FormDataSource)this.dataSource).getEntityType(ds);
        if (dsType == DsType.SUBENTRY) {
            CollectionField collectionField = new CollectionField();
            CollectionField entryField = ((DataRowSet)this.cacheRows.get(this.cursor)).getCollectionField(entityType.getParent().getName());
            Object values = entryField.getValue();
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                DataRowSet row = (DataRowSet)iterator.next();
                collectionField.addAll(row.getCollectionField(entityType.getName()));
            }
            CollectionField filter = FilterUtil.filter(this.dataSource, ds, controlKey, (List<DataRowSet>)collectionField.getValue());
            if (sortAble) {
                filter.setValue(this.executeSort((List<DataRowSet>)filter.getValue(), ds, controlKey));
            }
            return filter;
        }
        return CollectionField.EMPTY_LIST;
    }

    private List<DataRowSet> executeSort(List<DataRowSet> dataRowSets, String dsKey, String controlKey) {
        List<PrtDataSource> childDsList = ((FormDataSource)this.dataSource).getChildrenDs();
        if (!CollectionUtils.isEmpty(childDsList)) {
            for (PrtDataSource childDs : childDsList) {
                if (!StringUtils.equals((CharSequence)childDs.getDsName(), (CharSequence)dsKey)) continue;
                return super.executeSort(dataRowSets, childDs, controlKey);
            }
        }
        return dataRowSets;
    }

    @Override
    public Field getField(String ds, String fieldKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return NullField.get();
        }
        DataRowSet dataRowSet = (DataRowSet)this.cacheRows.get(this.cursor);
        if (StringUtils.equals((CharSequence)ds, (CharSequence)this.dataSource.getDsName())) {
            return dataRowSet.getField(fieldKey);
        }
        String key = ds.substring(ds.lastIndexOf(46) + 1);
        Field field = dataRowSet.getField(key);
        if (field instanceof CollectionField) {
            CollectionField collectionField = (CollectionField)field;
            return collectionField.getFirstField(fieldKey);
        }
        PrtDataSource prtDataSource = this.searchDs(ds);
        if (prtDataSource == null) {
            return NullField.get();
        }
        DsType dsType = prtDataSource.getDsType();
        if (dsType == DsType.SUBENTRY) {
            EntityType entityType = ((FormDataSource)this.dataSource).getEntityType(ds);
            Field entryField = dataRowSet.getField(entityType.getParent().getName());
            if (entryField instanceof NullField) {
                return NullField.get();
            }
            CollectionField collectionField = (CollectionField)entryField;
            Field firstField = collectionField.getFirstField(entityType.getName());
            if (firstField instanceof CollectionField) {
                return ((CollectionField)firstField).getFirstField(fieldKey);
            }
            return NullField.get();
        }
        if (dsType == DsType.ATTACH) {
            return dataRowSet.getField(fieldKey);
        }
        return NullField.get();
    }
}

