/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.FormDataVisitor;
import kd.bos.print.core.data.QueryPkBatcher;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.plugin.PrintPluginProxy;
import kd.bos.print.core.plugin.event.DataVisitorEvent;

public class MainDataVisitor
extends FormDataVisitor {
    public static final int MAX_QUERY_SIZE = 100;
    public static final int MAX_ENTRY_SIZE = 10000;
    public static final int MAX_BATCH_ENTRY_SIZE = 100000;
    private List<Object> pkIds;
    private int pkIndex = 0;
    private int maxQuerySize = 100;
    private int maxEntrySize = 10000;
    private int maxBatchEntrySize = 100000;
    private QueryPkBatcher queryPkBatcher = null;

    public MainDataVisitor(PrtDataSource ds) {
        super(ds);
    }

    public void setPkIds(List<Object> pkIds) {
        this.pkIds = pkIds;
        PrintPluginProxy pluginProxy = ExecuteContext.get().getPluginProxy();
        if (pluginProxy != null) {
            DataVisitorEvent evt = new DataVisitorEvent();
            if (!((Set)ExecuteContext.get().getHasMergePrintDsMap().getOrDefault(ExecuteContext.get().getTplKey(), new HashSet(0))).isEmpty()) {
                evt.setMaxQuerySize(5000);
            }
            pluginProxy.fireBeforeInitDataVisitor(evt);
            this.maxQuerySize = evt.getMaxQuerySize();
            this.maxEntrySize = evt.getMaxEntrySize();
            this.maxBatchEntrySize = evt.getMaxBatchEntrySize();
        }
        this.queryPkBatcher = new QueryPkBatcher(this.maxEntrySize);
        this.queryPkBatcher.setMaxBatchEntrySize(this.maxBatchEntrySize);
        this.queryPkBatcher.doBatchCalculate((MainDataSource)this.dataSource, pkIds);
    }

    public DataRowSet getDataRow() {
        int size = this.getRowsCount();
        if (size == 0) {
            return new DataRowSet();
        }
        return (DataRowSet)this.cacheRows.get(this.cursor);
    }

    public Object getCurrentPkId() {
        if (this.pkIds != null && this.cursor >= 0 && this.cursor < this.pkIds.size()) {
            return this.pkIds.get(this.cursor);
        }
        return null;
    }

    private List<Object> getQueryPks() {
        if (this.pkIds == null || this.pkIds.isEmpty()) {
            ++this.pkIndex;
            return Collections.emptyList();
        }
        List queryPks = this.queryPkBatcher.getQueryPks();
        if (queryPks.isEmpty()) {
            List batchPks = this.queryPkBatcher.getBatchPks();
            for (int curIndex = this.pkIndex; curIndex < this.pkIds.size() && batchPks.size() < this.maxQuerySize; ++curIndex) {
                batchPks.add(this.pkIds.get(curIndex));
            }
            queryPks = this.queryPkBatcher.getQueryPks();
        }
        this.pkIndex += queryPks.size();
        return queryPks;
    }

    @Override
    protected void init() {
        this.reset();
        List<Object> queryPks = this.getQueryPks();
        if (!((Set)ExecuteContext.get().getHasMergePrintDsMap().getOrDefault(ExecuteContext.get().getTplKey(), new HashSet(0))).isEmpty() && this.pkIds != null && !this.pkIds.isEmpty() && queryPks.size() < this.pkIds.size()) {
            throw new PrintException("-1", String.format(ResManager.loadKDString((String)"\u5408\u5e76\u6253\u5370\u5df2\u8d85\u8fc7%s\u5f20\u5355\u636e\uff0c\u6216\u8005\u5355\u636e\u603b\u5206\u5f55\u5df2\u8d85\u8fc7%s\u6761\uff0c\u8bf7\u5206\u6279\u52fe\u9009\u6253\u5370\u3002", (String)"MainDataVisitor_0", (String)"bos-print-core", (Object[])new Object[0]), this.maxQuerySize, this.maxBatchEntrySize == 100000 ? "10w" : Integer.valueOf(this.maxBatchEntrySize)));
        }
        MainDataSource mainDataSource = (MainDataSource)this.getDataSource();
        mainDataSource.setSortPKIds(queryPks);
        MainEntityType mainEntityType = mainDataSource.getMainEntityType();
        ISimpleProperty primaryKey = mainEntityType.getPrimaryKey();
        if (primaryKey != null && this.pkIds != null && !this.pkIds.isEmpty()) {
            int bdType = primaryKey.getDbType();
            if (bdType == -5) {
                List list = queryPks.stream().map(p -> p instanceof Long ? p : Long.valueOf(Long.parseLong(String.valueOf(p)))).collect(Collectors.toList());
                ArrayList<Object> pkIds = new ArrayList<Object>(list);
                mainDataSource.setSortPKIds(pkIds);
                mainDataSource.setQFilter(new QFilter("id", "in", list));
            } else {
                mainDataSource.setQFilter(new QFilter("id", "in", queryPks));
            }
        }
        super.init();
    }

    public void resetPkIndex() {
        this.pkIndex = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.pkIndex == 0) {
            this.init();
            return true;
        }
        if (this.cursor < this.getRows().size()) {
            return true;
        }
        if (this.pkIds == null || this.pkIds.isEmpty()) {
            return false;
        }
        if (this.pkIndex < this.pkIds.size()) {
            this.init();
            return true;
        }
        return false;
    }
}

