/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.VarcharProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.exception.PrintException;

public class QueryPkBatcher {
    private static Log log = LogFactory.getLog(QueryPkBatcher.class);
    private List batchPks = new ArrayList();
    private int maxBatchEntrySize = 100000;
    private int maxSingleEntrySize;
    private Map<Object, Integer> pkMap = new HashMap<Object, Integer>();

    private void reset() {
        this.batchPks.clear();
        this.pkMap.clear();
    }

    public QueryPkBatcher(int maxSingleEntrySize) {
        this.maxSingleEntrySize = maxSingleEntrySize;
    }

    public void doBatchCalculate(MainDataSource mainDataSource, List pkIds) {
        this.reset();
        List<PrtDataSource> childrenDs = mainDataSource.getChildrenDs();
        for (PrtDataSource childDs : childrenDs) {
            EntityType entityType = this.getEntityType(mainDataSource, childDs.getDsName());
            if (!(entityType instanceof EntryType) || entityType instanceof SubEntryType) continue;
            this.collectionPks((EntryType)entityType, pkIds);
        }
    }

    public List getQueryPks() {
        if (this.batchPks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList usePks = new ArrayList();
        int count = 0;
        Iterator iterator = this.batchPks.iterator();
        while (iterator.hasNext()) {
            Object pk = iterator.next();
            Integer pkCount = this.pkMap.get(pk);
            if (pkCount == null) {
                pkCount = 0;
            }
            count += pkCount.intValue();
            if (pkCount > this.maxSingleEntrySize) {
                throw new PrintException("-1", String.format(ResManager.loadKDString((String)"\u5355\u5f20\u5206\u5f55\u6570\u636e\u8d85\u51fa%s\u3002\u6682\u4e0d\u652f\u6301\u6253\u5370\u3002\u8bf7\u9002\u5f53\u8c03\u6574\u5206\u5f55\u5927\u5c0f\u3002", (String)"QueryPkBatcher_0", (String)"bos-print-core", (Object[])new Object[0]), this.maxSingleEntrySize));
            }
            if (count > this.maxBatchEntrySize) {
                if (usePks.size() == 0) {
                    usePks.add(pk);
                    this.pkMap.remove(pk);
                    iterator.remove();
                }
                log.debug(String.format("\u5206\u5f55\u603b\u6570\u592a\u5927(%s)\uff0c\u5c06\u51cf\u5c0f\u6279\u6b21\uff0c\u672c\u6b21\u6267\u884c%s\u5f20\u5355\uff0c\u5171\u8ba1\u5206\u5f55%s\u6761", count, usePks.size(), count - pkCount));
                break;
            }
            usePks.add(pk);
            this.pkMap.remove(pk);
            iterator.remove();
        }
        return usePks;
    }

    private void collectionPks(EntryType entryType, List pks) {
        if (entryType instanceof SubEntryType || pks.isEmpty() || StringUtils.isEmpty((CharSequence)entryType.getAlias())) {
            return;
        }
        String entityPk = entryType.getParent().getPrimaryKey().getAlias();
        String countSql = "select %s from %s where %s in (%s)";
        if (entryType.getPrimaryKey() instanceof VarcharProp) {
            countSql = "select %s from %s where %s in ('%s')";
        }
        countSql = String.format(countSql, entityPk, entryType.getAlias(), entityPk, StringUtils.join((Object[])pks.toArray(), (String)","));
        DB.query((DBRoute)DBRoute.of((String)entryType.getDBRouteKey()), (String)countSql, null, rSet -> {
            while (rSet.next()) {
                Object key = rSet.getObject(1);
                Integer count = this.pkMap.get(key);
                if (count == null) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                this.pkMap.put(key, count);
            }
            return null;
        });
    }

    private EntityType getEntityType(MainDataSource mainDataSource, String dsName) {
        Map allEntities = mainDataSource.getMainEntityType().getAllEntities();
        String dsKey = dsName.substring(dsName.lastIndexOf(46) + 1);
        return (EntityType)allEntities.get(dsKey);
    }

    public List getBatchPks() {
        return this.batchPks;
    }

    public int getMaxBatchEntrySize() {
        return this.maxBatchEntrySize;
    }

    public void setMaxBatchEntrySize(int maxBatchEntrySize) {
        this.maxBatchEntrySize = maxBatchEntrySize;
    }
}

