/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.IPrintDataProvider;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.prop.SortField;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.IntegerField;
import kd.bos.print.core.data.field.NullField;

public class R1PDataVisitor {
    private static final Log log = LogFactory.getLog(R1PDataVisitor.class);
    protected PrtDataSource dataSource;
    protected IPrintDataProvider dataProvider;
    protected List<DataRowSet> cacheRows;
    private boolean isInitData;
    private R1PDataVisitor relyMainVisitor;
    protected int cursor;

    public R1PDataVisitor(PrtDataSource ds) {
        this.dataSource = ds;
    }

    public PrtDataSource getDataSource() {
        return this.dataSource;
    }

    protected void init() {
        if (!this.isInitData) {
            this.cacheRows = this.dataProvider.getData(this.dataSource);
            this.isInitData = true;
        }
    }

    public void clear() {
        if (this.cacheRows != null) {
            this.cacheRows.clear();
        }
        this.cacheRows = null;
    }

    public void reset() {
        this.isInitData = false;
        if (this.cacheRows != null) {
            this.cacheRows.clear();
        }
        this.cacheRows = null;
        this.cursor = 0;
    }

    public void setDelegate(IPrintDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public void hookRelayMainVisitor(R1PDataVisitor visitor) {
        this.relyMainVisitor = visitor;
    }

    public R1PDataVisitor getRelyMainVisitor() {
        return this.relyMainVisitor;
    }

    public byte[] getImageByte(String imageKey) {
        return this.dataProvider.getImageByte(imageKey);
    }

    public int getRowsCount() {
        if (!this.isInitData) {
            this.init();
        }
        return this.cacheRows.size();
    }

    public boolean hasNext() {
        return this.cursor < this.getRowsCount();
    }

    public void next() {
        ++this.cursor;
    }

    List<DataRowSet> getRows() {
        return this.cacheRows;
    }

    public DataRowSet getDataRowSet() {
        int size = this.getRowsCount();
        if (size == 0) {
            return null;
        }
        DataRowSet dataRowSet = this.cacheRows.get(this.cursor);
        return dataRowSet;
    }

    public Field getField(int index, String fieldKey) {
        int size = this.getRowsCount();
        if (index < 0 || index >= size) {
            return NullField.get();
        }
        DataRowSet dataRowSet = this.cacheRows.get(index);
        return dataRowSet.getField(fieldKey);
    }

    public Field getField(String fieldKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return NullField.get();
        }
        DataRowSet dataRowSet = this.cacheRows.get(this.cursor);
        return dataRowSet.getField(fieldKey);
    }

    public Field getFirstField(String fieldKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return NullField.get();
        }
        DataRowSet dataRowSet = this.cacheRows.get(0);
        return dataRowSet.getField(fieldKey);
    }

    public Field getLastField(String fieldKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return NullField.get();
        }
        DataRowSet dataRowSet = this.cacheRows.get(this.cacheRows.size() - 1);
        return dataRowSet.getField(fieldKey);
    }

    public CollectionField getCollectionField(String ds) {
        return this.getCollectionField(ds, true);
    }

    public CollectionField getCollectionField(String ds, boolean sortAble) {
        return this.getCollectionField(ds, sortAble, null);
    }

    public CollectionField getCollectionField(String ds, String controlKey) {
        return this.getCollectionField(ds, true, controlKey);
    }

    public CollectionField getCollectionField(String ds, boolean sortAble, String controlKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return new CollectionField();
        }
        if (StringUtils.equals((CharSequence)ds, (CharSequence)this.dataSource.getDsName())) {
            return sortAble ? new CollectionField(this.executeSort(this.cacheRows, this.dataSource, controlKey)) : new CollectionField(this.cacheRows);
        }
        CollectionField collectionField = this.cacheRows.get(this.cursor).getCollectionField(ds);
        return sortAble ? new CollectionField(this.executeSort((List<DataRowSet>)collectionField.getValue(), this.dataSource, controlKey)) : collectionField;
    }

    protected List<DataRowSet> executeSort(List<DataRowSet> dataRowSets, PrtDataSource dataSource, String controlKey) {
        List<SortField> sortFields;
        if (controlKey != null && !CollectionUtils.isEmpty(sortFields = dataSource.getSortFields(controlKey))) {
            List<DataRowSet> sortedList = dataRowSets.stream().sorted(SortField.buildComparators(sortFields)).collect(Collectors.toList());
            if (dataSource.getDsType() != DsType.SUBENTRY) {
                this.seqReSorted(sortedList);
            }
            return sortedList;
        }
        if (dataSource.getDsType() != DsType.SUBENTRY) {
            this.seqReSorted(dataRowSets);
        }
        return dataRowSets;
    }

    private void seqReSorted(List<DataRowSet> sortedList) {
        Integer step = 1;
        for (DataRowSet row : sortedList) {
            Field seqField = row.getField("seq");
            if (seqField instanceof NullField) {
                row.put("seq", new IntegerField(step));
            } else if (seqField instanceof IntegerField) {
                seqField.setValue(step);
            } else {
                seqField.setDisplayVal(step.toString());
            }
            Integer n = step;
            Integer n2 = step = Integer.valueOf(step + 1);
        }
    }

    public Field getField(String ds, String fieldKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return NullField.get();
        }
        DataRowSet dataRowSet = this.cacheRows.get(this.cursor);
        if (StringUtils.equals((CharSequence)ds, (CharSequence)this.dataSource.getDsName())) {
            return dataRowSet.getField(fieldKey);
        }
        return NullField.get();
    }

    protected PrtDataSource searchDs(String ds) {
        FormDataSource dataSource = (FormDataSource)this.getDataSource();
        if (StringUtils.equals((CharSequence)dataSource.getDsName(), (CharSequence)ds)) {
            return dataSource;
        }
        List<PrtDataSource> childrenDs = dataSource.getChildrenDs();
        for (PrtDataSource prtDs : childrenDs) {
            if (!StringUtils.equals((CharSequence)prtDs.getDsName(), (CharSequence)ds)) continue;
            return prtDs;
        }
        return null;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public class Iterator
    implements PdIterator<DataRowSet> {
        int cursor;
        int size;

        public Iterator() {
            this.size = R1PDataVisitor.this.getRowsCount();
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext(false);
        }

        @Override
        public boolean hasNext(boolean flag) {
            if (flag) {
                return this.cursor < this.size - 1;
            }
            return this.cursor != this.size;
        }

        @Override
        public DataRowSet next() {
            if (this.cursor >= this.size) {
                throw new IllegalStateException();
            }
            ++this.cursor;
            if (this.cursor < this.size) {
                return this.current();
            }
            return null;
        }

        public int getCursor() {
            return this.cursor;
        }

        @Override
        public Field getField(String key) {
            DataRowSet dataRowSet = this.current();
            Field field = dataRowSet.getField(key);
            return field;
        }

        @Override
        public DataRowSet current() {
            return R1PDataVisitor.this.cacheRows.get(this.cursor);
        }

        @Override
        public int rowSize() {
            return this.size;
        }
    }
}

