/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.FormDataVisitor;
import kd.bos.print.core.data.MainDataVisitor;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.RefDataSource;
import kd.bos.print.core.data.datasource.RefParam;
import kd.bos.print.core.data.field.CollectionField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.utils.FilterUtil;

public class RefDataVisitor
extends FormDataVisitor {
    private static final Log log = LogFactory.getLog(RefDataVisitor.class);

    public RefDataVisitor(PrtDataSource ds) {
        super(ds);
    }

    @Override
    public CollectionField getCollectionField(String ds) {
        return this.getCollectionField(ds, true);
    }

    @Override
    public CollectionField getCollectionField(String ds, boolean sortAble) {
        return this.getCollectionField(ds, sortAble, null);
    }

    @Override
    public CollectionField getCollectionField(String ds, String controlKey) {
        return this.getCollectionField(ds, true, controlKey);
    }

    @Override
    public CollectionField getCollectionField(String ds, boolean sortAble, String controlKey) {
        int size = this.getRowsCount();
        if (size == 0) {
            return new CollectionField();
        }
        FormDataSource dataSource = (FormDataSource)this.getDataSource();
        if (StringUtils.equals((CharSequence)ds, (CharSequence)dataSource.getDsName())) {
            return sortAble ? new CollectionField(super.executeSort(this.cacheRows, dataSource, controlKey)) : new CollectionField(this.cacheRows);
        }
        PrtDataSource prtDataSource = this.searchDs(ds);
        if (prtDataSource == null) {
            return CollectionField.EMPTY_LIST;
        }
        DsType dsType = prtDataSource.getDsType();
        EntityType entityType = dataSource.getEntityType(ds);
        if (dsType == DsType.ENTRY) {
            CollectionField collectionField = new CollectionField();
            for (DataRowSet row : this.cacheRows) {
                CollectionField entryCollection = row.getCollectionField(entityType.getName());
                collectionField.addAll(entryCollection);
            }
            CollectionField filter = FilterUtil.filter(dataSource, ds, controlKey, (List<DataRowSet>)collectionField.getValue());
            return sortAble ? new CollectionField(super.executeSort((List<DataRowSet>)filter.getValue(), prtDataSource, controlKey)) : filter;
        }
        if (dsType == DsType.SUBENTRY) {
            CollectionField collectionField = new CollectionField();
            for (DataRowSet row : this.cacheRows) {
                CollectionField entryField = row.getCollectionField(entityType.getParent().getName());
                Object values = entryField.getValue();
                Iterator iterator = values.iterator();
                while (iterator.hasNext()) {
                    DataRowSet entryRow = (DataRowSet)iterator.next();
                    collectionField.addAll(entryRow.getCollectionField(entityType.getName()));
                }
            }
            CollectionField filter = FilterUtil.filter(dataSource, ds, controlKey, (List<DataRowSet>)collectionField.getValue());
            return sortAble ? new CollectionField(super.executeSort((List<DataRowSet>)filter.getValue(), prtDataSource, controlKey)) : filter;
        }
        if (dsType == DsType.ATTACH) {
            CollectionField collectionField = new CollectionField();
            collectionField.getValue().addAll(this.cacheRows);
            return collectionField;
        }
        return CollectionField.EMPTY_LIST;
    }

    public void notifyRefDsUpdateParam() {
        String refKey;
        String[] refKeyArr;
        MainDataVisitor mainDataVisitor = (MainDataVisitor)this.getRelyMainVisitor();
        RefDataSource refDataSource = (RefDataSource)this.getDataSource();
        RefParam refParam = refDataSource.getRefParam();
        String mainKey = refParam.getMainKey();
        Field field = mainDataVisitor.getField(mainKey);
        MainEntityType mainEntityType = refDataSource.getMainEntityType();
        DynamicProperty property = mainEntityType.getProperty((refKeyArr = (refKey = refParam.getRefKey()).split("\\."))[0]);
        if (property instanceof BasedataProp) {
            BasedataProp prop = (BasedataProp)property;
            property = prop.getDynamicComplexPropertyType().getProperty(refKeyArr[1]);
        }
        Object oriVal = field.getValue();
        Object value = null;
        if (property instanceof FieldProp) {
            FieldProp fieldProp = (FieldProp)property;
            try {
                value = fieldProp.getDbType() == -5 ? Long.valueOf(Long.parseLong(oriVal.toString())) : (fieldProp.getDbType() == 4 ? Integer.valueOf(Integer.parseInt(oriVal.toString())) : (fieldProp.getDbType() == 3 ? new BigDecimal(oriVal.toString()) : String.valueOf(oriVal)));
            }
            catch (Exception e) {
                value = null;
                log.error("\u5173\u8054\u503c\u8f6c\u6362\u5931\u8d25\uff1a", (Throwable)e);
            }
            if (value != null) {
                QFilter qFilter = new QFilter(refParam.getRefKey(), refParam.getUnionCp(), value);
                refDataSource.setQFilter(qFilter);
            }
        }
    }
}

