/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.datasource;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.query.QFilter;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.data.IPrintDataProvider;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.PrtDataSource;

public class FormDataSource
extends PrtDataSource {
    private String formId;
    private MainEntityType mainEntityType;
    private List<PrtDataSource> childrenDs;
    private QFilter qFilter;
    private FilterCondition filterCondition;

    public FormDataSource(String dsName, DsType dsType, String formId) {
        super(dsName, dsType);
        this.formId = formId;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public MainEntityType getMainEntityType() {
        if (this.mainEntityType == null) {
            IPrintDataProvider dataService = ExecuteContext.get().getServiceProxy().getDataService();
            this.mainEntityType = dataService.getMainEntityType(this.getFormId());
        }
        return this.mainEntityType;
    }

    public EntityType getEntityType(String dsName) {
        Map allEntities = this.getMainEntityType().getAllEntities();
        String dsKey = dsName.substring(dsName.lastIndexOf(46) + 1);
        return (EntityType)allEntities.get(dsKey);
    }

    @Override
    public String getDsName() {
        return this.dsName;
    }

    @Override
    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public QFilter getQFilter() {
        return this.qFilter;
    }

    public void setQFilter(QFilter qFilter) {
        this.qFilter = qFilter;
    }

    public FilterCondition getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(FilterCondition filterCondition) {
        this.filterCondition = filterCondition;
    }

    public List<PrtDataSource> getChildrenDs() {
        if (this.childrenDs == null) {
            this.childrenDs = new ArrayList<PrtDataSource>();
        }
        return this.childrenDs;
    }

    public void addChildDs(PrtDataSource ds) {
        this.getChildrenDs().add(ds);
    }
}

