/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.datasource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.datasource.DsType;
import kd.bos.print.core.data.datasource.prop.Condition;
import kd.bos.print.core.data.datasource.prop.SortField;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class PrtDataSource {
    protected String dsName;
    protected DsType dsType;
    protected boolean isMergePrint;
    protected List<String> queryField;
    protected Map<String, List<SortField>> sortFieldMap;
    protected Map<String, List<Condition>> conditionMap = new HashMap<String, List<Condition>>(0);

    public List<Condition> getConditionList(String key) {
        return this.conditionMap.get(key);
    }

    public void putConditionList(String key, List<Condition> conditionList) {
        if (CollectionUtils.isEmpty(conditionList)) {
            return;
        }
        this.getQueryField().addAll(conditionList.stream().map(Condition::getField).collect(Collectors.toList()));
        List<Condition> conditions = this.conditionMap.get(key);
        if (!CollectionUtils.isEmpty(conditions)) {
            conditions.addAll(conditionList);
        } else {
            this.conditionMap.put(key, conditionList);
        }
    }

    public List<SortField> getSortFields(String key) {
        if (this.sortFieldMap == null) {
            return null;
        }
        return this.sortFieldMap.get(key);
    }

    public void setSortFields(String key, List<SortField> sortFields) {
        List<SortField> oriSortFields;
        if (sortFields != null) {
            this.getQueryField().addAll(sortFields.stream().map(SortField::getBindField).collect(Collectors.toList()));
        }
        if (this.sortFieldMap == null) {
            this.sortFieldMap = new HashMap<String, List<SortField>>(8);
        }
        if ((oriSortFields = this.sortFieldMap.get(key)) != null && sortFields != null) {
            oriSortFields.addAll(sortFields);
        } else {
            this.sortFieldMap.put(key, sortFields);
        }
    }

    public PrtDataSource(String dsName, DsType dsType) {
        this.dsName = dsName;
        this.dsType = dsType;
    }

    public String getDsName() {
        return this.dsName;
    }

    public void setDsName(String dsName) {
        this.dsName = dsName;
    }

    public DsType getDsType() {
        return this.dsType;
    }

    public void setDsType(DsType dsType) {
        this.dsType = dsType;
    }

    public List<String> getQueryField() {
        if (this.queryField == null) {
            this.queryField = new ArrayList<String>();
        }
        return this.queryField;
    }

    public void setQueryField(List<String> queryField) {
        this.queryField = queryField;
    }

    public void addField(String field) {
        this.getQueryField().add(field);
    }

    public boolean isMergePrint() {
        return this.isMergePrint;
    }

    public void setMergePrint(boolean mergePrint) {
        this.isMergePrint = mergePrint;
    }
}

