/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.datasource.prop;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.digitalstyle.FormatResult;
import kd.bos.print.core.ctrl.common.digitalstyle.Formats;
import kd.bos.print.core.ctrl.common.variant.Variant;
import kd.bos.print.core.data.datasource.prop.LogicTypes;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NumberField;
import kd.bos.print.core.data.field.TextField;
import kd.bos.print.core.data.field.TimeField;
import kd.bos.service.KDDateUtils;
import org.apache.commons.lang3.time.DateUtils;

public class Condition {
    private static final Log log = LogFactory.getLog(Condition.class);
    private List<LogicTypes> leftBrackets = new ArrayList<LogicTypes>(0);
    private List<LogicTypes> rightBrackets = new ArrayList<LogicTypes>(0);
    private String field;
    private LogicTypes compareType;
    private List<Object> valueList = new ArrayList<Object>(0);
    private SimpleDateFormat simpleDateFormat;
    private LogicTypes logic;

    public Condition() {
    }

    public Condition(List<LogicTypes> leftBrackets, List<LogicTypes> rightBrackets, String field, LogicTypes compareType, List<Object> valueList, LogicTypes logic) {
        this.leftBrackets = leftBrackets;
        this.rightBrackets = rightBrackets;
        this.field = field;
        this.compareType = compareType;
        this.valueList = valueList;
        this.logic = logic;
    }

    public String getField() {
        return this.field;
    }

    public boolean filter(Field fieldValue) {
        try {
            if (LogicTypes.EQUAL == this.compareType) {
                return this.isEquals(fieldValue);
            }
            if (LogicTypes.NOT_EQUAL == this.compareType) {
                return !this.isEquals(fieldValue);
            }
            if (LogicTypes.GREATER_THEN == this.compareType) {
                return this.greaterThan(fieldValue);
            }
            if (LogicTypes.LESS_THEN == this.compareType) {
                return this.lessThan(fieldValue);
            }
            if (LogicTypes.GREATER_OR_EQUAL_THEN == this.compareType) {
                return !this.lessThan(fieldValue);
            }
            if (LogicTypes.LESS_OR_EQUAL_THEN == this.compareType) {
                return !this.greaterThan(fieldValue);
            }
            if (LogicTypes.STRING_CONTAIN == this.compareType) {
                return this.contain(fieldValue);
            }
            if (LogicTypes.NOT_CONTAIN == this.compareType) {
                return !this.contain(fieldValue);
            }
            if (LogicTypes.START_WITH == this.compareType) {
                return this.startWith(fieldValue);
            }
            if (LogicTypes.END_WITH == this.compareType) {
                return this.endWith(fieldValue);
            }
            if (LogicTypes.ISNULL == this.compareType) {
                return this.isNull(fieldValue);
            }
            if (LogicTypes.IS_NOTNULL == this.compareType) {
                return this.isNotNull(fieldValue);
            }
            if (LogicTypes.TODAY == this.compareType) {
                return this.today(fieldValue);
            }
            if (LogicTypes.THIS_WEEK == this.compareType) {
                return this.thisWeek(fieldValue);
            }
            if (LogicTypes.THIS_MONTH == this.compareType) {
                return this.thisMonth(fieldValue);
            }
            if (LogicTypes.LAST_MONTH == this.compareType) {
                return this.lastMonth(fieldValue);
            }
            if (LogicTypes.LAST_THREE_MONTH == this.compareType) {
                return this.lastThreeMonth(fieldValue);
            }
            if (LogicTypes.FROM_TO == this.compareType) {
                return this.fromTo(fieldValue);
            }
            if (LogicTypes.IN == this.compareType) {
                return this.in(fieldValue);
            }
            if (LogicTypes.COLLECTION_CONTAIN == this.compareType) {
                return this.collectionIsContian(fieldValue);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return false;
        }
        return false;
    }

    private boolean collectionIsContian(Field fieldValue) {
        String value = String.valueOf(fieldValue.getValue());
        Set valueSet = Arrays.stream(value.split(",")).collect(Collectors.toSet());
        boolean contain = true;
        for (Object v : this.valueList) {
            if (valueSet.contains(v)) continue;
            contain = false;
            break;
        }
        return contain;
    }

    private boolean today(Field fieldValue) {
        Date date = this.getDateValue(fieldValue);
        if (date == null) {
            return false;
        }
        Date todayStart = KDDateUtils.today();
        Date todayEnd = DateUtils.addDays((Date)todayStart, (int)1);
        return !todayStart.after(date) && todayEnd.after(date);
    }

    private boolean thisWeek(Field fieldValue) {
        Date date = this.getDateValue(fieldValue);
        if (date == null) {
            return false;
        }
        Date weekStart = KDDateUtils.getTheWeekStart((int)0, (Date)KDDateUtils.today(), (int)2);
        Date weekEnd = KDDateUtils.getTheWeekEnd((int)0, (Date)KDDateUtils.today(), (int)2);
        return !weekStart.after(date) && weekEnd.after(date);
    }

    private Date getDateValue(Field fieldValue) {
        Object value = fieldValue.getValue();
        if (!(value instanceof Date)) {
            return null;
        }
        Date date = (Date)fieldValue.getValue();
        return date;
    }

    private boolean thisMonth(Field fieldValue) {
        Date date = this.getDateValue(fieldValue);
        if (date == null) {
            return false;
        }
        Date weekStart = KDDateUtils.getTheMonthStart((int)0, (Date)KDDateUtils.today());
        Date weekEnd = KDDateUtils.getTheMonthEnd((int)0, (Date)KDDateUtils.today());
        return !weekStart.after(date) && weekEnd.after(date);
    }

    private boolean lastMonth(Field fieldValue) {
        Date date = this.getDateValue(fieldValue);
        if (date == null) {
            return false;
        }
        Date weekStart = KDDateUtils.getTheMonthStart((int)-1, (Date)KDDateUtils.today());
        Date weekEnd = KDDateUtils.getTheMonthEnd((int)-1, (Date)KDDateUtils.today());
        return !weekStart.after(date) && weekEnd.after(date);
    }

    private boolean lastThreeMonth(Field fieldValue) {
        Date date = this.getDateValue(fieldValue);
        if (date == null) {
            return false;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(KDDateUtils.today());
        ((Calendar)calendar).add(2, -3);
        Date dateStart = calendar.getTime();
        Date dateEnd = DateUtils.addDays((Date)KDDateUtils.today(), (int)1);
        return !dateStart.after(date) && dateEnd.after(date);
    }

    private boolean fromTo(Field fieldValue) throws ParseException {
        SimpleDateFormat dateFormat = this.getDateFormat(String.valueOf(this.valueList.get(0)));
        Date dateStart = DateUtils.parseDate((String)String.valueOf(this.valueList.get(0)), (String[])new String[]{dateFormat.toPattern()});
        Date dateEnd = DateUtils.parseDate((String)String.valueOf(this.valueList.get(1)), (String[])new String[]{dateFormat.toPattern()});
        Date date = this.getDateValue(fieldValue);
        if (date == null) {
            return false;
        }
        return !dateStart.after(date) && (dateEnd.after(date) || dateEnd.equals(date));
    }

    private boolean in(Field fieldValue) {
        for (Object value : this.valueList) {
            if (!StringUtils.equals((CharSequence)String.valueOf(fieldValue.getValue()), (CharSequence)String.valueOf(value))) continue;
            return true;
        }
        return false;
    }

    private boolean contain(Field fieldValue) {
        return String.valueOf(fieldValue).contains(String.valueOf(this.valueList.get(0)));
    }

    private boolean startWith(Field fieldValue) {
        return String.valueOf(fieldValue).startsWith(String.valueOf(this.valueList.get(0)));
    }

    private boolean endWith(Field fieldValue) {
        return String.valueOf(fieldValue).endsWith(String.valueOf(this.valueList.get(0)));
    }

    private boolean isNull(Field fieldValue) {
        return StringUtils.isBlank((CharSequence)String.valueOf(fieldValue));
    }

    private boolean isNotNull(Field fieldValue) {
        return !StringUtils.isBlank((CharSequence)String.valueOf(fieldValue));
    }

    private boolean greaterThan(Field value) {
        return this.compareTo(value, this.valueList.get(0)) > 0;
    }

    private boolean lessThan(Field value) {
        return this.compareTo(value, this.valueList.get(0)) < 0;
    }

    private boolean isEquals(Field value) {
        return this.compareTo(value, this.valueList.get(0)) == 0;
    }

    private int compareTo(Field leftValue, Object rightValue) {
        String rightV = String.valueOf(rightValue);
        if (leftValue instanceof TimeField) {
            String format = leftValue.getFormat();
            if (StringUtils.isBlank((CharSequence)format)) {
                String displayVal = leftValue.getDisplayVal();
                return String.valueOf(displayVal).compareTo(rightV);
            }
            FormatResult result = Formats.getFormat(format).format(new Variant(leftValue.getValue()));
            return String.valueOf(result).compareTo(rightV);
        }
        if (leftValue instanceof TextField) {
            TextField textField = (TextField)leftValue;
            String fieldValue = (String)textField.getValue();
            return String.valueOf(fieldValue).compareTo(rightV);
        }
        if (leftValue instanceof NumberField) {
            NumberField numberField = (NumberField)leftValue;
            Number numberFieldValue = numberField.getValue();
            if (numberFieldValue == null) {
                return -1;
            }
            BigDecimal rightNumber = new BigDecimal(rightV);
            BigDecimal leftNumber = null;
            leftNumber = numberFieldValue instanceof BigDecimal ? (BigDecimal)numberFieldValue : new BigDecimal(String.valueOf(numberFieldValue));
            return leftNumber.compareTo(rightNumber);
        }
        Object value = leftValue.getValue();
        if (value instanceof Date) {
            Date leftDate = (Date)value;
            SimpleDateFormat dateFormat = this.getDateFormat(rightV);
            return dateFormat.format(leftDate).compareTo(rightV);
        }
        return -1;
    }

    private SimpleDateFormat getDateFormat(String rightV) {
        if (this.simpleDateFormat == null) {
            this.simpleDateFormat = rightV.length() == 10 ? new SimpleDateFormat("yyyy-MM-dd") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return this.simpleDateFormat;
    }

    public List<LogicTypes> getLeftBrackets() {
        return this.leftBrackets;
    }

    public List<LogicTypes> getRightBrackets() {
        return this.rightBrackets;
    }

    public LogicTypes getCompareType() {
        return this.compareType;
    }

    public List<Object> getValueList() {
        return this.valueList;
    }

    public LogicTypes getLogic() {
        return this.logic;
    }
}

