/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.datasource.prop;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;

public class SortField {
    private static final String DEFAULT_ORDER_BY = "DESC";
    private static final String BLANK = "";
    private String dataSource;
    private String bindField;
    private String bindName;
    private String orderBy;
    private Comparator comparator;

    private Comparator<DataRowSet> buildFieldComparator() {
        int nullFactory = DEFAULT_ORDER_BY.equalsIgnoreCase(this.orderBy) ? -1 : 1;
        return (do1, do2) -> {
            if (do1 == do2) {
                return 0;
            }
            Object o1 = this.fetchValue((DataRowSet)do1);
            Object o2 = this.fetchValue((DataRowSet)do2);
            if (o1 == null || BLANK.equals(o1)) {
                return o2 == null || BLANK.equals(o2) ? 0 : -nullFactory;
            }
            if (o2 == null || BLANK.equals(o2)) {
                return nullFactory;
            }
            return DEFAULT_ORDER_BY.equalsIgnoreCase(this.orderBy) ? this.valueComparator().reversed().compare(o1, o2) : this.valueComparator().compare(o1, o2);
        };
    }

    private Comparator<Object> valueComparator() {
        return (o1, o2) -> {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1 instanceof BigDecimal) {
                return ((BigDecimal)o1).compareTo((BigDecimal)o2);
            }
            if (o1 instanceof Date) {
                return ((Date)o1).compareTo((Date)o2);
            }
            if (o1 instanceof Integer) {
                return ((Integer)o1).compareTo((Integer)o2);
            }
            if (o1 instanceof Long) {
                return ((Long)o1).compareTo((Long)o2);
            }
            if (o1 instanceof String) {
                Comparator cmp = this.getComparator();
                if (null == cmp) {
                    return ((String)o1).compareTo((String)o2);
                }
                return cmp.compare(o1, o2);
            }
            if (o1 instanceof BigInteger) {
                return ((BigInteger)o1).compareTo((BigInteger)o2);
            }
            return 0;
        };
    }

    private Object fetchValue(DataRowSet sortedObj) {
        Field field = sortedObj.getField(this.getBindField());
        if (field == null || field instanceof NullField) {
            return null;
        }
        return field.getValue();
    }

    public static <T> Comparator<T> buildComparators(List<SortField> sortFieldList) {
        List comparators;
        if (sortFieldList == null || CollectionUtils.isEmpty(comparators = sortFieldList.stream().map(SortField::buildFieldComparator).collect(Collectors.toList()))) {
            return null;
        }
        Comparator filedComparator = (Comparator)comparators.remove(0);
        for (Comparator comparator : comparators) {
            filedComparator = filedComparator.thenComparing(comparator);
        }
        return filedComparator;
    }

    public String getBindField() {
        return this.bindField;
    }

    public void setBindField(String bindField) {
        this.bindField = bindField;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public static String getDefaultOrderBy() {
        return DEFAULT_ORDER_BY;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getBindName() {
        return this.bindName;
    }

    public void setBindName(String bindName) {
        this.bindName = bindName;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }
}

