/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.field;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bos.print.core.data.field.NumberField;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class BigIntegerField
extends NumberField<BigIntegerField> {
    public BigIntegerField() {
        this(BigInteger.ZERO);
    }

    public BigIntegerField(BigInteger value) {
        super(value);
    }

    @Override
    public Class<?> getFieldType() {
        return BigInteger.class;
    }

    @Override
    public BigInteger getValue() {
        return (BigInteger)super.getValue();
    }

    @Override
    public void add(BigIntegerField field) {
        this.value = this.getValue().add(field.getValue());
    }

    @Override
    public void addNum(Number number) {
        if (number instanceof BigDecimal) {
            this.value = this.getValue().add(((BigDecimal)number).toBigInteger());
        } else if (number instanceof Integer) {
            this.value = this.getValue().add(BigInteger.valueOf(number.intValue()));
        } else if (number instanceof Long) {
            this.value = this.getValue().add(BigInteger.valueOf(number.longValue()));
        }
    }

    @Override
    public void setZero() {
        this.value = BigInteger.ZERO;
    }

    @Override
    public int compareTo(@NotNull BigIntegerField field) {
        return this.getValue().compareTo(field.getValue());
    }

    @Override
    public BigIntegerField copy() {
        return (BigIntegerField)super.copy();
    }
}

