/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.field;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.PdIterator;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CollectionField
extends Field<List<DataRowSet>> {
    public static final CollectionField EMPTY_LIST = new EmptyList();

    public CollectionField() {
        super(new ArrayList());
    }

    public CollectionField(List<DataRowSet> value) {
        super(value);
        if (this.value == null) {
            this.value = new ArrayList();
        }
    }

    @Override
    public Class<?> getFieldType() {
        return List.class;
    }

    @Override
    public List<DataRowSet> getValue() {
        return (List)super.getValue();
    }

    @Override
    public void setValue(List<DataRowSet> value) {
        this.value = value;
    }

    public void add(DataRowSet dataRowSet) {
        ((List)this.value).add(dataRowSet);
    }

    public void addAll(List<DataRowSet> rows) {
        ((List)this.value).addAll(rows);
    }

    public void addAll(CollectionField fields) {
        ((List)this.value).addAll(fields.getValue());
    }

    public int size() {
        return ((List)this.value).size();
    }

    public Field getFirstField(String fileKey) {
        if (this.size() > 0) {
            return ((DataRowSet)this.getValue().get(0)).getField(fileKey);
        }
        return NullField.get();
    }

    @SdkInternal
    public PdIterator iterator() {
        return new Iter();
    }

    public CollectionField copy() {
        return (CollectionField)super.copy();
    }

    private static class EmptyList
    extends CollectionField {
        public EmptyList() {
            this.value = Collections.EMPTY_LIST;
        }
    }

    private class Iter
    implements PdIterator<DataRowSet> {
        int cursor;
        int size;

        private Iter() {
            this.size = CollectionField.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.hasNext(false);
        }

        @Override
        public boolean hasNext(boolean flag) {
            if (flag) {
                return this.cursor < this.size - 1;
            }
            return this.cursor != this.size;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public DataRowSet next() {
            if (this.cursor >= this.size) {
                throw new IllegalStateException();
            }
            ++this.cursor;
            if (this.cursor < this.size) {
                return this.current();
            }
            return null;
        }

        @Override
        public Field getField(String key) {
            DataRowSet dataRowSet = this.current();
            Field field = dataRowSet.getField(key);
            return field;
        }

        @Override
        public DataRowSet current() {
            return (DataRowSet)CollectionField.this.getValue().get(this.cursor);
        }

        @Override
        public int rowSize() {
            return this.size;
        }
    }
}

