/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.field;

import java.math.BigDecimal;
import kd.bos.print.core.data.field.NumberField;
import kd.sdk.annotation.SdkInternal;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class DecimalField
extends NumberField<DecimalField> {
    private int precision;
    private int scale;
    private String symbol;
    private String code;

    public DecimalField() {
        this(BigDecimal.ZERO);
    }

    public DecimalField(BigDecimal value) {
        super(value);
        this.scale = value.scale();
    }

    @Override
    public Object getShowValue() {
        if (this.displayVal != null) {
            return this.displayVal;
        }
        if (!this.isShowZero() && BigDecimal.ZERO.compareTo(this.getValue()) == 0) {
            return "";
        }
        return this.value;
    }

    @Override
    public BigDecimal getValue() {
        return (BigDecimal)super.getValue();
    }

    @Override
    public Class<?> getFieldType() {
        return BigDecimal.class;
    }

    @SdkInternal
    public int getPrecision() {
        return this.precision;
    }

    @SdkInternal
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public void add(DecimalField field) {
        this.value = this.getValue().add(field.getValue());
    }

    @Override
    public void addNum(Number number) {
        if (number instanceof BigDecimal) {
            this.value = this.getValue().add((BigDecimal)number);
        } else if (number instanceof Integer) {
            this.value = this.getValue().add(BigDecimal.valueOf(number.intValue()));
        } else if (number instanceof Long) {
            this.value = this.getValue().add(BigDecimal.valueOf(number.longValue()));
        } else if (number instanceof Double) {
            this.value = this.getValue().add(BigDecimal.valueOf(number.doubleValue()));
        }
    }

    @Override
    public void setZero() {
        this.value = BigDecimal.ZERO;
    }

    @Override
    public int compareTo(DecimalField field) {
        return this.getValue().compareTo(field.getValue());
    }

    @Override
    public DecimalField copy() {
        DecimalField copy = (DecimalField)super.copy();
        copy.code = this.code;
        copy.precision = this.precision;
        copy.scale = this.scale;
        copy.symbol = this.symbol;
        return copy;
    }
}

