/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.field;

import java.io.Serializable;
import java.util.TimeZone;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.print.core.exception.FieldIllegalException;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class Field<T>
implements Serializable {
    protected T value;
    protected String displayVal;
    protected boolean desensitive;
    protected String format;
    private TimeZone timeZone = null;

    public boolean isDesensitive() {
        return this.desensitive;
    }

    public void setDesensitive(boolean desensitive) {
        this.desensitive = desensitive;
    }

    public Field() {
    }

    public Field(T value) {
        this.setValue(value);
    }

    public abstract Class<?> getFieldType();

    public T getValue() {
        return this.value;
    }

    public boolean showDisplayVal() {
        return this.displayVal != null;
    }

    public Object getShowValue() {
        if (this.displayVal != null) {
            return this.displayVal;
        }
        return this.value;
    }

    public void setValue(T value) {
        if (value.getClass() != this.getFieldType()) {
            throw new FieldIllegalException(ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e0d\u7b26\u5408\u3002", (String)"Field_0", (String)"bos-print-core", (Object[])new Object[0]));
        }
        this.value = value;
    }

    public String getDisplayVal() {
        return this.displayVal;
    }

    public void setDisplayVal(String displayVal) {
        this.displayVal = displayVal;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public String toString() {
        Object showValue = this.getShowValue();
        if (showValue != null) {
            return showValue.toString();
        }
        return super.toString();
    }

    public Field<T> copy() {
        Field newField = null;
        try {
            newField = (Field)this.getClass().newInstance();
            newField.setValue(this.value);
            newField.setDisplayVal(this.displayVal);
            newField.setDesensitive(this.desensitive);
            newField.setFormat(this.format);
            newField.setTimeZone(this.timeZone);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return newField;
    }
}

