/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.data.field;

import kd.bos.print.core.data.field.NumberField;
import kd.sdk.annotation.SdkPublic;
import org.jetbrains.annotations.NotNull;

@SdkPublic
public class IntegerField
extends NumberField<IntegerField> {
    public IntegerField() {
        this(0);
    }

    public IntegerField(Integer value) {
        super(value);
    }

    @Override
    public Class<?> getFieldType() {
        return Integer.class;
    }

    @Override
    public Integer getValue() {
        return super.getValue().intValue();
    }

    @Override
    public void add(IntegerField field) {
        int value = this.getValue();
        this.setValue(value += field.getValue().intValue());
    }

    @Override
    public void addNum(Number number) {
        long value = this.getValue().intValue();
        this.setValue(value + (long)number.intValue());
    }

    @Override
    public void setZero() {
        this.value = 0;
    }

    @Override
    public int compareTo(@NotNull IntegerField field) {
        return this.getValue().compareTo(field.getValue());
    }

    @Override
    public IntegerField copy() {
        return (IntegerField)super.copy();
    }
}

