/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.EscUtil;

public class EscPos
implements Closeable,
Flushable,
EscPosConst {
    private final OutputStream outputStream;

    public EscPos(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void write(int b) throws IOException {
        this.outputStream.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.outputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void moveY(int unit) throws IOException {
        byte[] bytes = EscUtil.moveYCmd(unit);
        this.write(bytes, 0, bytes.length);
    }

    public void moveX(int unit) throws IOException {
        byte[] bytes = EscUtil.moveXCmd(unit);
        this.write(bytes, 0, bytes.length);
    }

    public void initializePrinter() throws IOException {
        this.write(27);
        this.write(64);
    }
}

