/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc;

import java.math.BigDecimal;

public interface EscPosConst {
    public static final int DEFAULT_LINE_SPACING = 30;
    public static final int BORDER_TEXT_LINE_SPACING = 25;
    public static final String CN_CHARSET = "GBK";
    public static final double CUM = 2.119166692097982;
    public static final double RUM = 3.5319444868299694;
    public static final double INC10MM = (double)254.3f;
    public static final int ESCP_MOVE_UNIT = 360;
    public static final int ESCP_IMAGE_DPI = 180;
    public static final int ESCP_BARCODE_MOVE_UNIT = 180;
    public static final int DPI = 203;
    public static final int NUL = 0;
    public static final int LF = 10;
    public static final byte HT = 9;
    public static final int ESC = 27;
    public static final byte FS = 28;
    public static final int GS = 29;
    public static final int FF = 12;
    public static final int VT = 11;
    public static final int CR = 13;
    public static final byte DC2 = 18;
    public static final byte SI = 15;

    public static enum BarCodeHRIFont {
        Font_A_Default(48),
        Font_B(49),
        Font_C(50);

        public final int value;

        private BarCodeHRIFont(int value) {
            this.value = value;
        }
    }

    public static enum BarCodeHRIPosition {
        NotPrinted_Default(48),
        AboveBarCode(49),
        BelowBarCode(50),
        AboveAndBelowBarCode(51);

        public final int value;

        private BarCodeHRIPosition(int value) {
            this.value = value;
        }
    }

    public static enum BarCodeSystem {
        UPCA(0, 6, "\\d{11,12}$"),
        UPCA_B(65, 6, "^\\d{11,12}$"),
        UPCE_A(1, 6, "^\\d{6}$|^0{1}\\d{6,7}$|^0{1}\\d{10,11}$"),
        UPCE_B(66, 6, "^\\d{6}$|^0{1}\\d{6,7}$|^0{1}\\d{10,11}$"),
        JAN13_A(2, 0, "^\\d{12,13}$"),
        JAN13_B(67, 0, "^\\d{12,13}$"),
        JAN8_A(3, 1, "^\\d{7,8}$"),
        JAN8_B(68, 1, "^\\d{7,8}$"),
        CODE39_A(4, 5, "^[\\d\\p{Upper}\\ \\$\\%\\*\\+\\-\\.\\/]+$"),
        CODE39_B(69, 5, "^[\\d\\p{Upper}\\ \\$\\%\\*\\+\\-\\.\\/]+$"),
        ITF_A(5, 6, "^([\\d]{2})+$"),
        ITF_B(70, 6, "^([\\d]{2})+$"),
        CODABAR_A(6, 6, "^[A-Da-d][\\d\\$\\+\\-\\.\\/\\:]*[A-Da-d]$"),
        CODABAR_B(71, 6, "^[A-Da-d][\\d\\$\\+\\-\\.\\/\\:]*[A-Da-d]$"),
        CODE93_Default(72, 6, "^[\\x00-\\x7F]+$"),
        CODE128(73, 6, "^\\{[A-C][\\x00-\\x7F]+$"),
        GS1_128(74, 6, "");

        public final int code;
        public final String regex;
        public final int escpCode;

        private BarCodeSystem(int code, int escpCode, String regex) {
            this.code = code;
            this.escpCode = escpCode;
            this.regex = regex;
        }
    }

    public static enum QRSize {
        S_4(4, 10.5f),
        S_7(7, 18.0f),
        S_10(10, 26.0f),
        S_13(13, 34.0f),
        S_15(15, 39.5f);

        public final int size;
        public final float width;

        private QRSize(int size, float width) {
            this.size = size;
            this.width = width;
        }
    }

    public static enum QRErrorCorrectionLevel {
        QR_ECLEVEL_L(48, "L"),
        QR_ECLEVEL_M_Default(49, "M"),
        QR_ECLEVEL_Q(50, "Q"),
        QR_ECLEVEL_H(51, "H");

        public final int value;
        public final String label;

        private QRErrorCorrectionLevel(int value, String label) {
            this.value = value;
            this.label = label;
        }

        public static QRErrorCorrectionLevel getInstance(String label) {
            for (QRErrorCorrectionLevel level : QRErrorCorrectionLevel.values()) {
                if (!level.label.equals(label)) continue;
                return level;
            }
            return QR_ECLEVEL_M_Default;
        }
    }

    public static enum QRModel {
        _1_Default(49),
        _2(50);

        public final int value;

        private QRModel(int value) {
            this.value = value;
        }
    }

    public static enum Underline {
        None_Default(48),
        OneDotThick(49),
        TwoDotThick(50);

        public final int value;

        private Underline(int value) {
            this.value = value;
        }
    }

    public static enum FontSize {
        _1(0, 12.0f),
        _2(1, 16.0f),
        _3(2, 20.0f),
        _4(3, 24.0f),
        _5(4, 28.0f),
        _6(5, 32.0f),
        _7(6, 36.0f),
        _8(7, 38.0f);

        public final int value;
        public final float pxSize;

        private FontSize(int value, float pxSize) {
            this.value = value;
            this.pxSize = pxSize;
        }
    }

    public static enum BitImageMode {
        _8DotSingleDensity(0, 8),
        _8DotDoubleDensity(1, 8),
        _24DotSingleDensity(32, 24),
        _24DotDoubleDensity_Default(33, 24);

        public final int value;
        public final int bitsForVerticalData;

        private BitImageMode(int value, int bitsPerSlice) {
            this.value = value;
            this.bitsForVerticalData = bitsPerSlice;
        }
    }

    public static enum ColorMode {
        BlackOnWhite_Default(0),
        WhiteOnBlack(1);

        public final int value;

        private ColorMode(int value) {
            this.value = value;
        }
    }

    public static enum FontName {
        Font_A_Default(48),
        Font_B(49),
        Font_C(50),
        Font_D(51),
        Font_E(52),
        SPECIAL_Font_A(97),
        SPECIAL_Font_B(98);

        public final int value;

        private FontName(int value) {
            this.value = value;
        }
    }

    public static enum Align {
        Left_Default(48),
        Center(49),
        Right(50);

        public final int value;

        private Align(int value) {
            this.value = value;
        }
    }

    public static enum EscPaperSize {
        _58(new BigDecimal(58), 32, 384),
        _75(new BigDecimal(75), 40, 480),
        _80(new BigDecimal(80), 48, 576),
        _110(new BigDecimal(110), 60, 720);

        public final BigDecimal width;
        public final int charNum;
        public final int rowPxWidth;

        private EscPaperSize(BigDecimal width, int charNum, int rowPxWidth) {
            this.width = width;
            this.charNum = charNum;
            this.rowPxWidth = rowPxWidth;
        }

        public static EscPaperSize match(BigDecimal width) {
            for (EscPaperSize value : EscPaperSize.values()) {
                if (width.compareTo(value.width) != 0) continue;
                return value;
            }
            return null;
        }
    }
}

