/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.common.KDToolkit;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.execute.render.painter.pwpainer.view.ViewWidgetPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;

public class EscUtil
implements EscPosConst {
    private static final Log log = LogFactory.getLog(EscUtil.class);

    public static byte[] moveXCmd(int unit) {
        int nL = unit & 0xFF;
        int nH = (unit & 0xFF00) >> 8;
        byte[] bytes = new byte[]{27, 92, (byte)nL, (byte)nH};
        return bytes;
    }

    public static byte[] moveYCmd(int unit) {
        if (unit < 0 || unit > 255) {
            throw new IllegalArgumentException("moveY motionUnit illegal.");
        }
        byte[] bytes = new byte[]{27, 74, (byte)unit};
        return bytes;
    }

    public static byte[] moveRight(int unit) {
        byte[] bytes = new byte[]{27, 92, (byte)(unit & 0xFF), (byte)((unit & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] moveLeft(int unit) {
        byte[] bytes = new byte[4];
        bytes[0] = 27;
        bytes[1] = 92;
        int n2 = (65536 - unit) / 256;
        int n1 = 65536 - unit - n2 * 256;
        bytes[2] = (byte)n1;
        bytes[3] = (byte)n2;
        return bytes;
    }

    public static byte[] moveBottom(int unit) {
        byte[] bytes = new byte[]{27, 40, 118, 2, 0, (byte)(unit & 0xFF), (byte)((unit & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] moveTop(int unit) {
        byte[] bytes = new byte[7];
        bytes[0] = 27;
        bytes[1] = 40;
        bytes[2] = 118;
        bytes[3] = 2;
        bytes[4] = 0;
        int n2 = (65536 - unit) / 256;
        int n1 = 65536 - unit - n2 * 256;
        bytes[5] = (byte)n1;
        bytes[6] = (byte)n2;
        return bytes;
    }

    public static byte[] fixXPosition(int unit) {
        byte[] bytes = new byte[]{27, 36, (byte)(unit & 0xFF), (byte)((unit & 0xFF00) >> 8)};
        return bytes;
    }

    public static byte[] fixYPosition(int unit) {
        byte[] bytes = new byte[]{27, 40, 86, 2, 0, (byte)(unit & 0xFF), (byte)((unit & 0xFF00) >> 8)};
        return bytes;
    }

    public static BufferedImage drawImageGroup(ImagePaperPainter painter, int height, int dpi) {
        PaintPaperInfo paperInfo = painter.getPaperInfo();
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        r1PrintInfo.setMarginTop(0);
        r1PrintInfo.setMarginBottom(0);
        r1PrintInfo.setMarginLeft(0);
        r1PrintInfo.setMarginRight(0);
        int width = r1PrintInfo.getPaperSize().width;
        int scaleWidthLom = (int)KPrintUtil.lomToPrintPoint(width) + 1;
        int scaleHeightLom = (int)KPrintUtil.lomToPrintPoint(height) + 1;
        try {
            BufferedImage image = new BufferedImage(scaleWidthLom, scaleHeightLom, 1);
            Graphics2D graphic = image.createGraphics();
            graphic.setClip(0, 0, scaleWidthLom, scaleHeightLom);
            graphic.setColor(Color.white);
            graphic.fillRect(0, 0, scaleWidthLom, scaleHeightLom);
            painter.paint(graphic);
            graphic.dispose();
            scaleWidthLom = (int)((double)width / (double)254.3f * (double)dpi) + 1;
            scaleHeightLom = (int)((double)height / (double)254.3f * (double)dpi) + 1;
            BufferedImage scaleImage = new BufferedImage(scaleWidthLom, scaleHeightLom, 1);
            Graphics2D graphics = scaleImage.createGraphics();
            graphics.drawImage(image, 0, 0, scaleWidthLom, scaleHeightLom, null);
            graphics.dispose();
            return scaleImage;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public static BufferedImage drawWidget(ImagePaperPainter painter, AbstractPrintWidget widget, int dpi) {
        Rectangle rectangle = widget.getRectangle();
        int widthPx = (int)(rectangle.getWidth() / (double)254.3f * (double)dpi) + 1;
        int heightPx = (int)(rectangle.getHeight() / (double)254.3f * (double)dpi) + 1;
        try {
            BufferedImage scaledImage = new BufferedImage(widthPx, heightPx, 2);
            Graphics2D graphics = scaledImage.createGraphics();
            ViewWidgetPainter viewWidgetPainter = new ViewWidgetPainter();
            viewWidgetPainter.setPaintContext(painter.getPaintContext());
            viewWidgetPainter.setPaperInfo(painter.getPaperInfo());
            viewWidgetPainter.addPaintObj(widget);
            int currentDpi = KDToolkit.getCurrentDpi();
            rectangle.setRect(0.0, 0.0, (int)(rectangle.getWidth() / (double)currentDpi * (double)dpi), (int)(rectangle.getHeight() / (double)currentDpi * (double)dpi));
            viewWidgetPainter.paint(graphics);
            graphics.dispose();
            return scaledImage;
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return null;
        }
    }

    public static boolean isDoubleWidth(char c) {
        if (c >= '\u4e00' && c <= '\u9fa5') {
            return true;
        }
        if (c >= '\uff00' && c <= '\uffef') {
            return true;
        }
        try {
            return String.valueOf(c).getBytes("GBK").length == 2;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }
}

