/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.esc.convert.PrintWidgetEscConvert;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.model.widget.AbstractPrintWidget;

public class BaseEscConvert
implements PrintWidgetEscConvert {
    protected Deque<WidgetArea> widgetAreas = new LinkedList<WidgetArea>();

    public BaseEscConvert() {
    }

    public BaseEscConvert(Deque<WidgetArea> widgetAreas) {
        this.widgetAreas = widgetAreas;
    }

    public void convert(AbstractPrintWidget widget) {
        Rectangle childRect = widget.getRectangle();
        int curY1 = childRect.y;
        int curY2 = curY1 + childRect.height;
        this.convertToArea(widget, childRect, curY1, curY2);
    }

    protected final void convertToArea(AbstractPrintWidget widget, Rectangle childRect, int curY1, int curY2) {
        EImage eImage = new EImage();
        if (this.widgetAreas.size() > 0) {
            WidgetArea last = this.widgetAreas.getLast();
            if (curY1 >= last.y2 && last.type != WidgetAreaType.ImageGroup) {
                eImage.setTrd(curY1 - last.y2);
                eImage.setLrd(childRect.x);
                WidgetArea widgetArea = this.createWidgetArea(WidgetAreaType.ImageGroup, eImage, curY1, curY2);
                widgetArea.printWidgets.add(widget);
                this.releaseRef(last);
                this.widgetAreas.addLast(widgetArea);
            } else {
                this.createImageGroup(widget, curY1, curY2, last);
            }
        } else {
            this.createFirstArea(WidgetAreaType.ImageGroup, curY1, curY2, widget, eImage);
        }
    }

    protected final void releaseRef(WidgetArea last) {
        if (last.type != WidgetAreaType.Image && last.type != WidgetAreaType.ImageGroup && last.type != WidgetAreaType.TextGroup) {
            last.printWidgets.clear();
        }
    }

    protected final boolean isContainsBorder(Style style) {
        if (style == null) {
            return false;
        }
        LineStyle lineStyle = style.getBorderLineStyle(Styles.Position.TOP);
        if (lineStyle != null && !lineStyle.isNullBorder()) {
            return true;
        }
        lineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
        if (lineStyle != null && !lineStyle.isNullBorder()) {
            return true;
        }
        lineStyle = style.getBorderLineStyle(Styles.Position.LEFT);
        if (lineStyle != null && !lineStyle.isNullBorder()) {
            return true;
        }
        lineStyle = style.getBorderLineStyle(Styles.Position.RIGHT);
        return lineStyle != null && !lineStyle.isNullBorder();
    }

    protected final WidgetArea createWidgetArea(WidgetAreaType type, EBlock block, int curY1, int curY2) {
        WidgetArea widgetArea = new WidgetArea();
        widgetArea.type = type;
        widgetArea.block = block;
        widgetArea.y1 = curY1;
        widgetArea.y2 = curY2;
        return widgetArea;
    }

    protected final void createFirstArea(WidgetAreaType type, int curY1, int curY2, AbstractPrintWidget label, EBlock text) {
        WidgetArea widgetArea = new WidgetArea();
        widgetArea.type = type;
        widgetArea.y1 = curY1;
        widgetArea.y2 = curY2;
        widgetArea.block = text;
        widgetArea.printWidgets.add(label);
        this.widgetAreas.addLast(widgetArea);
    }

    protected final void createImageGroup(AbstractPrintWidget curWidget, int curY1, int curY2, WidgetArea last) {
        WidgetArea target;
        EImageGroup imageGroup = new EImageGroup();
        ArrayList<AbstractPrintWidget> printWidgets = new ArrayList<AbstractPrintWidget>(4);
        printWidgets.addAll(last.printWidgets);
        this.releaseRef(last);
        printWidgets.add(curWidget);
        WidgetArea widgetArea = new WidgetArea();
        widgetArea.type = WidgetAreaType.ImageGroup;
        widgetArea.y1 = Math.min(last.y1, curY1);
        widgetArea.y2 = Math.max(last.y2, curY2);
        widgetArea.block = imageGroup;
        widgetArea.printWidgets = printWidgets;
        this.widgetAreas.removeLast();
        if (this.widgetAreas.size() > 0 && (target = this.widgetAreas.getLast()) != null) {
            imageGroup.setTrd(last.y1 - target.y2);
        } else {
            imageGroup.setTrd(last.y1);
        }
        this.widgetAreas.addLast(widgetArea);
    }

    static class EImageGroup
    extends EBlock {
        EImageGroup() {
        }
    }

    static enum WidgetAreaType {
        Text,
        Barcode,
        QRCode,
        Image,
        Grid,
        ImageGroup,
        TextGroup;

    }

    static class WidgetArea {
        protected int y1;
        protected int y2;
        protected WidgetAreaType type;
        protected EBlock block;
        protected List<AbstractPrintWidget> printWidgets = new ArrayList<AbstractPrintWidget>(4);

        WidgetArea() {
        }
    }
}

