/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert;

import java.awt.Rectangle;
import java.util.Deque;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.MapField;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.convert.BaseEscConvert;
import kd.bos.print.core.esc.model.EBarcode;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EQRCode;
import kd.bos.print.core.model.designer.BarcodeObject;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.barcode.PWBarcode;

public class PWBarcodeEscConvert
extends BaseEscConvert {
    public PWBarcodeEscConvert(Deque<BaseEscConvert.WidgetArea> widgetAreas) {
        this.widgetAreas = widgetAreas;
    }

    @Override
    public void convert(AbstractPrintWidget widget) {
        BaseEscConvert.WidgetAreaType type;
        EBlock block;
        PWBarcode pwCode = (PWBarcode)widget;
        Rectangle childRect = pwCode.getRectangle();
        int curY1 = childRect.y;
        int curY2 = curY1 + childRect.height;
        BarcodeObject barcodeObject = pwCode.getBarcodeObject();
        Field outputValue = pwCode.getOutputValue();
        Object barcodeVal = null;
        String barcodeType = null;
        if (outputValue instanceof MapField) {
            MapField mapField = (MapField)outputValue;
            Map config = (Map)mapField.getValue();
            barcodeType = String.valueOf(config.get("barcodeType"));
            barcodeVal = config.get("barcode");
            if (StringUtils.isBlank((Object)barcodeVal)) {
                barcodeVal = barcodeObject.getSampleTxt();
            }
        }
        if (barcodeVal == null) {
            return;
        }
        if (pwCode.isQRCode()) {
            EQRCode eqrCode = new EQRCode();
            block = eqrCode;
            eqrCode.setEcl(EscPosConst.QRErrorCorrectionLevel.getInstance(barcodeObject.getErrorCorrection()));
            for (EscPosConst.QRSize qrSize : EscPosConst.QRSize.values()) {
                if (Float.compare(qrSize.width, (float)childRect.getWidth() / 10.0f) != 0) continue;
                eqrCode.setSize(qrSize.size);
                break;
            }
            eqrCode.setText(barcodeVal.toString());
        } else {
            EBarcode eBarcode = new EBarcode();
            block = eBarcode;
            eBarcode.setText(barcodeVal.toString());
            int heightPx = (int)KPrintUtil.lomToPrintPoint(childRect.getHeight());
            eBarcode.setHeight(heightPx);
            eBarcode.setHriPosition(barcodeObject.isShowText() ? EscPosConst.BarCodeHRIPosition.BelowBarCode : EscPosConst.BarCodeHRIPosition.NotPrinted_Default);
            this.barcodeSystemConvert(eBarcode, barcodeType);
        }
        Style style = pwCode.getStyle();
        if (style != null) {
            if (style.getHorizontalAlign() == Styles.HorizontalAlignment.LEFT) {
                block.setAlign(EscPosConst.Align.Left_Default);
            } else if (style.getHorizontalAlign() == Styles.HorizontalAlignment.CENTER) {
                block.setAlign(EscPosConst.Align.Center);
            } else if (style.getHorizontalAlign() == Styles.HorizontalAlignment.RIGHT) {
                block.setAlign(EscPosConst.Align.Right);
            }
        }
        BaseEscConvert.WidgetAreaType widgetAreaType = type = pwCode.isQRCode() ? BaseEscConvert.WidgetAreaType.QRCode : BaseEscConvert.WidgetAreaType.Barcode;
        if (this.widgetAreas.size() > 0) {
            BaseEscConvert.WidgetArea last = (BaseEscConvert.WidgetArea)this.widgetAreas.getLast();
            if (curY1 >= last.y2) {
                block.setTrd(curY1 - last.y2);
                block.setLrd(childRect.x);
                BaseEscConvert.WidgetArea widgetArea = this.createWidgetArea(type, block, curY1, curY2);
                widgetArea.printWidgets.add(pwCode);
                this.releaseRef(last);
                this.widgetAreas.addLast(widgetArea);
            } else {
                this.createImageGroup(pwCode, curY1, curY2, last);
            }
        } else {
            block.setTrd(curY1);
            block.setLrd(childRect.x);
            this.createFirstArea(type, curY1, curY2, pwCode, block);
        }
    }

    private void barcodeSystemConvert(EBarcode eBarcode, String barcodeType) {
        if (StringUtils.equals((CharSequence)"ean-13", (CharSequence)barcodeType)) {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.JAN13_A);
        } else if (StringUtils.equals((CharSequence)"code39", (CharSequence)barcodeType)) {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.CODE39_A);
        } else if (StringUtils.equals((CharSequence)"ean-128", (CharSequence)barcodeType)) {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.GS1_128);
        } else {
            eBarcode.setSystem(EscPosConst.BarCodeSystem.CODE128);
            eBarcode.setText("{A" + eBarcode.getText());
        }
    }
}

