/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert;

import java.awt.Rectangle;
import java.util.Deque;
import java.util.List;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.convert.BaseEscConvert;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;

public class PWGridEscConvert
extends BaseEscConvert {
    private final StringBuilder gridSplitLine = new StringBuilder();
    private static final int SINGLE_CHAR_WIDTH = 12;
    private final int rowWidth;

    public PWGridEscConvert(Deque<BaseEscConvert.WidgetArea> widgetAreas, Integer rowWidth) {
        if (rowWidth == null) {
            rowWidth = 384;
        }
        this.widgetAreas = widgetAreas;
        this.rowWidth = rowWidth;
        int charNum = rowWidth / 12;
        for (int i = 0; i < charNum; ++i) {
            this.gridSplitLine.append("-");
        }
        this.gridSplitLine.append("\n");
    }

    @Override
    public void convert(AbstractPrintWidget widget) {
        AbstractPWGrid grid = (AbstractPWGrid)widget;
        List<AbstractPWGridRow> outputRows = grid.getOutputRows();
        int columnCount = grid.getColumnCount();
        StringBuilder result = new StringBuilder();
        this.convertGridToText(outputRows, columnCount, result);
        int sum = outputRows.stream().mapToInt(AbstractPWGridRow::getHeight).sum();
        Rectangle childRect = widget.getRectangle();
        int curY1 = childRect.y;
        int curY2 = curY1 + sum;
        Style style = grid.getStyle();
        EText text = new EText();
        text.setText(result.toString());
        if (style != null) {
            text.setBold(style.isBold());
            if (style.isUnderline()) {
                text.setUnderline(EscPosConst.Underline.OneDotThick);
            }
        }
        text.setW(childRect.width);
        text.setH(sum);
        if (this.widgetAreas.size() > 0) {
            BaseEscConvert.WidgetArea last = (BaseEscConvert.WidgetArea)this.widgetAreas.getLast();
            text.setTrd(Math.max(curY1 - last.y2, 0));
        } else {
            text.setTrd(curY1);
        }
        BaseEscConvert.WidgetArea widgetArea = this.createWidgetArea(BaseEscConvert.WidgetAreaType.Text, text, curY1, curY2);
        widgetArea.printWidgets.add(grid);
        this.widgetAreas.addLast(widgetArea);
    }

    private void convertGridToText(List<AbstractPWGridRow> outputRows, int columnCount, StringBuilder result) {
        int[] startPos = new int[columnCount];
        boolean initPos = false;
        for (AbstractPWGridRow outputRow : outputRows) {
            int rowType = outputRow.getRowType();
            int currentRowWidth = 0;
            if (1 == rowType && !initPos) {
                int avgSpaceNum = this.calcAvgSpaceNum(columnCount, outputRow);
                for (int i = 0; i < columnCount; ++i) {
                    Object cell = outputRow.getCell(i);
                    if (cell == null) continue;
                    String showText = ((AbstractPrintWidgetText)cell).getOutputText();
                    if (showText != null) {
                        showText = showText.replaceAll("\\n", "");
                    }
                    int textWidth = this.calcTextWidth(showText);
                    result.append(showText);
                    if (i == columnCount - 1) {
                        startPos[i] = currentRowWidth;
                        currentRowWidth += textWidth;
                        continue;
                    }
                    if ((currentRowWidth += textWidth) >= this.rowWidth) {
                        result.append("\n");
                        currentRowWidth = 0;
                    } else {
                        for (int j = 0; j < avgSpaceNum; ++j) {
                            result.append(" ");
                            textWidth += 12;
                            currentRowWidth += 12;
                        }
                    }
                    startPos[i] = currentRowWidth - textWidth;
                }
                initPos = true;
            } else {
                result.append((CharSequence)this.gridSplitLine);
                for (int i = 0; i < columnCount; ++i) {
                    Object cell = outputRow.getCell(i);
                    if (cell == null) continue;
                    String showText = ((AbstractPrintWidgetText)cell).getOutputText();
                    if (showText != null) {
                        showText = showText.replaceAll("\\n", "");
                    }
                    int textWidth = this.calcTextWidth(showText);
                    currentRowWidth += this.appendSpace(result, startPos[i], currentRowWidth);
                    result.append(showText);
                    if (i + 1 < columnCount && currentRowWidth + textWidth >= startPos[i + 1]) {
                        result.append("\n");
                        currentRowWidth = 0;
                        continue;
                    }
                    currentRowWidth += textWidth;
                }
            }
            if (result.charAt(result.length() - 1) == '\n') continue;
            result.append("\n");
        }
    }

    private int calcAvgSpaceNum(int columnCount, AbstractPWGridRow outputRow) {
        int titleTextWidth = 0;
        for (int i = 0; i < columnCount; ++i) {
            Object cell = outputRow.getCell(i);
            if (cell == null) continue;
            String showText = ((AbstractPrintWidgetText)cell).getOutputText();
            int textWidth = this.calcTextWidth(showText);
            titleTextWidth += textWidth;
        }
        int avgSpaceNum = (this.rowWidth - titleTextWidth) / 12 / columnCount;
        return avgSpaceNum <= 0 ? 1 : avgSpaceNum;
    }

    private int appendSpace(StringBuilder result, int startPos, int currentRowWidth) {
        int width = 0;
        int maxSpaceNum = this.rowWidth / 12;
        int needSpaceNum = (startPos - currentRowWidth) / 12;
        for (int spaceNum = 0; spaceNum < needSpaceNum % maxSpaceNum; ++spaceNum) {
            result.append(" ");
            width += 12;
        }
        return width;
    }

    private int calcTextWidth(String showValue) {
        if (showValue == null) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < showValue.length(); ++i) {
            sum += this.calcCharWidth(showValue.charAt(i));
        }
        return sum;
    }

    private int calcCharWidth(char c) {
        return EscUtil.isDoubleWidth(c) ? 24 : 12;
    }
}

