/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.convert.BaseEscConvert;
import kd.bos.print.core.esc.convert.PWBarcodeEscConvert;
import kd.bos.print.core.esc.convert.PWGridEscConvert;
import kd.bos.print.core.esc.convert.PWPictureEscConvert;
import kd.bos.print.core.esc.convert.PWTextEscConvert;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.esc.model.EPage;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;

public class PWPageEscConvert
extends BaseEscConvert {
    private Map<Class<? extends AbstractPrintWidget>, BaseEscConvert> convertMap;
    private static final Log log = LogFactory.getLog(PWPageEscConvert.class);
    private Integer rowWidth = null;

    public BaseEscConvert getConvert(AbstractPrintWidget widget) {
        BaseEscConvert convert;
        Class<?> clazz = widget.getClass();
        if (this.convertMap == null) {
            this.convertMap = new HashMap<Class<? extends AbstractPrintWidget>, BaseEscConvert>(4);
        }
        if ((convert = this.convertMap.get(clazz)) == null) {
            if (widget instanceof PWText) {
                convert = new PWTextEscConvert(this.widgetAreas);
            } else if (widget instanceof PWPicture) {
                convert = new PWPictureEscConvert(this.widgetAreas);
            } else if (widget instanceof PWBarcode) {
                convert = "escpos".equals(ExecuteContext.get().getExpType()) ? new PWBarcodeEscConvert(this.widgetAreas) : new BaseEscConvert(this.widgetAreas);
            } else if (widget instanceof AbstractPWGrid) {
                convert = "escpos".equals(ExecuteContext.get().getExpType()) ? new BaseEscConvert(this.widgetAreas){

                    @Override
                    public void convert(AbstractPrintWidget widget) {
                        AbstractPWGrid grid = (AbstractPWGrid)widget;
                        List outputRows = grid.getOutputRows();
                        int sum = outputRows.stream().mapToInt(AbstractPWGridRow::getHeight).sum();
                        Rectangle childRect = widget.getRectangle();
                        int curY1 = childRect.y;
                        int curY2 = curY1 + sum;
                        super.convertToArea(grid, childRect, curY1, curY2);
                    }
                } : new PWGridEscConvert(this.widgetAreas, this.rowWidth);
            } else if (widget instanceof PWLine) {
                convert = new BaseEscConvert(this.widgetAreas);
            } else if (widget instanceof PWTableTail) {
                convert = new BaseEscConvert(this.widgetAreas);
            }
            this.convertMap.put(clazz, convert);
        }
        return convert;
    }

    @Override
    public EPage convert(ImagePaperPainter painter) {
        PWPage page;
        if (this.rowWidth == null) {
            R1PrintInfo r1PrintInfo = painter.getPaperInfo().getR1PrintInfo();
            Dimension paperSize = r1PrintInfo.getPaperSize();
            double width = paperSize.getWidth();
            BigDecimal bigDecimal = BigDecimal.valueOf(width / 10.0);
            EscPosConst.EscPaperSize escPaperSize = null;
            int dpi = ExecuteContext.get().getDpi();
            if (dpi == 0) {
                dpi = 203;
            }
            if (dpi == 203) {
                escPaperSize = EscPosConst.EscPaperSize.match(bigDecimal);
            }
            this.rowWidth = escPaperSize == null ? Integer.valueOf(Math.toIntExact((long)(bigDecimal.intValue() - 10) * Math.round((double)dpi / 25.4))) : Integer.valueOf(escPaperSize.rowPxWidth);
        }
        if ((page = (PWPage)painter.getPaintObj()) == null) {
            return null;
        }
        List children = page.getChildren();
        children = children.stream().sorted((c1, c2) -> {
            Rectangle r1 = c1.getRectangle();
            Rectangle r2 = c2.getRectangle();
            int compare = Double.compare(r1.getY(), r2.getY());
            if (compare == 0) {
                return Double.compare(r1.getX(), r2.getX());
            }
            return compare;
        }).collect(Collectors.toList());
        EPage ePage = new EPage();
        ArrayList<EBlock> blocks = new ArrayList<EBlock>(children.size());
        ePage.setBlocks(blocks);
        for (AbstractPrintWidget child : children) {
            try {
                BaseEscConvert convert = this.getConvert(child);
                if (convert == null) continue;
                convert.convert(child);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        for (BaseEscConvert.WidgetArea widgetArea : this.widgetAreas) {
            if (widgetArea.type == BaseEscConvert.WidgetAreaType.ImageGroup) {
                children.clear();
                children.addAll(widgetArea.printWidgets);
                page.setChildren(children);
                for (AbstractPrintWidget child : children) {
                    Rectangle rectangle = child.getRectangle();
                    rectangle.y -= widgetArea.y1;
                }
                BufferedImage bufferedImage = EscUtil.drawImageGroup(painter, widgetArea.y2 - widgetArea.y1, 203);
                EImage image = new EImage();
                image.setImage(bufferedImage);
                image.setTrd(widgetArea.block.getTrd());
                blocks.add(image);
                continue;
            }
            if (widgetArea.type == BaseEscConvert.WidgetAreaType.Image) {
                AbstractPrintWidget picture;
                if (widgetArea.printWidgets.size() <= 0 || !((picture = widgetArea.printWidgets.get(0)) instanceof PWPicture)) continue;
                BufferedImage bufferedImage = EscUtil.drawWidget(painter, picture, 203);
                ((EImage)widgetArea.block).setImage(bufferedImage);
                blocks.add(widgetArea.block);
                continue;
            }
            blocks.add(widgetArea.block);
        }
        this.widgetAreas.clear();
        return ePage;
    }
}

