/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert;

import java.awt.Rectangle;
import java.util.Deque;
import java.util.List;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.convert.BaseEscConvert;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWText;

public class PWTextEscConvert
extends BaseEscConvert {
    public PWTextEscConvert(Deque<BaseEscConvert.WidgetArea> widgetAreas) {
        this.widgetAreas = widgetAreas;
    }

    @Override
    public void convert(AbstractPrintWidget widget) {
        PWText pwText = (PWText)widget;
        Rectangle childRect = pwText.getRectangle();
        int curY1 = childRect.y;
        int curY2 = curY1 + childRect.height;
        Style style = pwText.getStyle();
        EText text = new EText();
        text.setText(pwText.getOutputText());
        text.setBold(style.isBold());
        text.setW(childRect.width);
        text.setH(childRect.height);
        for (EscPosConst.FontSize fontSize : EscPosConst.FontSize.values()) {
            if (Float.compare(fontSize.pxSize, pwText.getStyle().getFontSizeF()) != 0) continue;
            text.setFontWidth(fontSize);
            text.setFontHeight(fontSize);
            break;
        }
        if (style.isUnderline()) {
            text.setUnderline(EscPosConst.Underline.OneDotThick);
        }
        if (this.widgetAreas.size() > 0) {
            BaseEscConvert.WidgetArea last = (BaseEscConvert.WidgetArea)this.widgetAreas.getLast();
            if (curY1 >= last.y2) {
                text.setTrd(curY1 - last.y2);
                text.setLrd(childRect.x);
                BaseEscConvert.WidgetArea widgetArea = null;
                if (this.isContainsBorder(style)) {
                    if (last.type == BaseEscConvert.WidgetAreaType.ImageGroup) {
                        this.createImageGroup(pwText, curY1, curY2, last);
                    } else {
                        widgetArea = this.createWidgetArea(BaseEscConvert.WidgetAreaType.ImageGroup, text, curY1, curY2);
                    }
                } else {
                    widgetArea = this.createWidgetArea(BaseEscConvert.WidgetAreaType.Text, text, curY1, curY2);
                }
                if (widgetArea != null) {
                    this.releaseRef(last);
                    widgetArea.printWidgets.add(pwText);
                    this.widgetAreas.addLast(widgetArea);
                }
            } else if (last.type == BaseEscConvert.WidgetAreaType.Text) {
                if (curY2 == last.y2 && !this.isContainsBorder(style)) {
                    EText lastText = (EText)last.block;
                    ETextLine eTextLine = new ETextLine();
                    eTextLine.addText(lastText);
                    eTextLine.addText(text);
                    text.setLrd(childRect.x - (lastText.getLrd() + lastText.getW()));
                    BaseEscConvert.WidgetArea widgetArea = this.createWidgetArea(BaseEscConvert.WidgetAreaType.TextGroup, eTextLine, Math.min(last.y1, curY1), Math.max(last.y2, curY2));
                    widgetArea.printWidgets.addAll(last.printWidgets);
                    widgetArea.printWidgets.add(pwText);
                    this.releaseRef(last);
                    this.widgetAreas.removeLast();
                    this.widgetAreas.addLast(widgetArea);
                } else {
                    this.createImageGroup(pwText, curY1, curY2, last);
                }
            } else if (last.type == BaseEscConvert.WidgetAreaType.TextGroup) {
                if (curY2 == last.y2) {
                    ETextLine lastTextLine = (ETextLine)last.block;
                    List<EText> texts = lastTextLine.getTexts();
                    int baseX = texts.stream().mapToInt(m -> m.getLrd() + m.getW()).sum();
                    text.setLrd(childRect.x - baseX);
                    this.releaseRef(last);
                    lastTextLine.addText(text);
                } else {
                    this.createImageGroup(pwText, curY1, curY2, last);
                }
            } else {
                this.createImageGroup(pwText, curY1, curY2, last);
            }
        } else {
            text.setTrd(curY1);
            text.setLrd(childRect.x);
            if (this.isContainsBorder(style)) {
                this.createFirstArea(BaseEscConvert.WidgetAreaType.ImageGroup, curY1, curY2, pwText, text);
            } else {
                this.createFirstArea(BaseEscConvert.WidgetAreaType.Text, curY1, curY2, pwText, text);
            }
        }
    }
}

