/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert.escp;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.convert.PrintWidgetEscConvert;
import kd.bos.print.core.esc.convert.escp.PWBarcodeEscpConvert;
import kd.bos.print.core.esc.convert.escp.PWGridEscpConvert;
import kd.bos.print.core.esc.convert.escp.PWPictureEscpConvert;
import kd.bos.print.core.esc.convert.escp.PWTextEscpConvert;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.esc.model.ETable;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWLine;
import kd.bos.print.core.model.widget.PWPicture;
import kd.bos.print.core.model.widget.PWText;
import kd.bos.print.core.model.widget.barcode.PWBarcode;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;

public class BaseEscpConvert
implements PrintWidgetEscConvert {
    protected static final String TB_SYMBOL = "\u2502";
    protected static final String BLANK = " ";
    protected static final String TB_BLANK = "  ";
    protected final EscpContext context;
    protected ImagePaperPainter painter;
    private Map<Class<? extends AbstractPrintWidget>, BaseEscpConvert> convertMap;

    public BaseEscpConvert(EscpContext context) {
        this.context = context;
    }

    public BaseEscpConvert getConvert(AbstractPrintWidget widget) {
        BaseEscpConvert convert;
        Class<?> clazz = widget.getClass();
        if (this.convertMap == null) {
            this.convertMap = new HashMap<Class<? extends AbstractPrintWidget>, BaseEscpConvert>(4);
        }
        if ((convert = this.convertMap.get(clazz)) == null) {
            if (widget instanceof PWText) {
                convert = new PWTextEscpConvert(this.context);
            } else if (widget instanceof AbstractPWGrid) {
                convert = new PWGridEscpConvert(this.context);
            } else if (widget instanceof PWBarcode) {
                convert = new PWBarcodeEscpConvert(this.context);
            } else if (widget instanceof PWPicture) {
                convert = new PWPictureEscpConvert(this.context);
            } else if (widget instanceof PWLine) {
                convert = new PWPictureEscpConvert(this.context);
            }
            this.convertMap.put(clazz, convert);
        }
        return convert;
    }

    protected final void convertWidget(ImagePaperPainter painter, List<EBlock> blocks, AbstractPrintWidget child, boolean fixed) {
        BaseEscpConvert convert = this.getConvert(child);
        if (convert != null) {
            convert.setPainter(painter);
            EBlock block = convert.convert(child, fixed);
            if (block != null) {
                blocks.add(block);
            }
        }
    }

    public EBlock convert(AbstractPrintWidget widget, boolean fixed) {
        return null;
    }

    protected void release() {
    }

    protected final void setPosition(EBlock block, int x, int y, int width, int height, boolean fixed) {
        if (block == null) {
            return;
        }
        int baseY1 = this.context.getBaseY1();
        int baseX2 = this.context.getBaseX2();
        if (block instanceof ETable) {
            List<ETextLine> rows = ((ETable)block).getRows();
            if (rows != null) {
                for (ETextLine row : rows) {
                    row.setX(x);
                }
            }
            block.setTrd(y - baseY1);
            this.context.setBaseX2(x + width);
        } else if (block instanceof EImage) {
            block.setTrd(y - baseY1);
            block.setX(x);
            this.context.setBaseX2(0);
        } else {
            if (fixed) {
                block.setY(y);
                block.setX(x);
            } else {
                block.setTrd(y - baseY1);
                if (baseX2 > 0 && x > baseX2) {
                    block.setLrd(x - baseX2);
                } else {
                    block.setX(x);
                }
            }
            this.context.setBaseX2(0);
        }
        this.context.setBaseY1(y);
    }

    public void setPainter(ImagePaperPainter painter) {
        this.painter = painter;
    }

    protected final int appendBlank(StringBuilder body, int cn, StringBuilder text, int tempCN, Styles.HorizontalAlignment horizontalAlignment) {
        int i;
        int rightSpaceNum;
        int leftSpaceNum;
        int blankNum = cn - tempCN;
        if (horizontalAlignment == null) {
            horizontalAlignment = Styles.HorizontalAlignment.LEFT;
        }
        if (horizontalAlignment == Styles.HorizontalAlignment.LEFT) {
            leftSpaceNum = 0;
            rightSpaceNum = blankNum;
        } else if (horizontalAlignment == Styles.HorizontalAlignment.RIGHT) {
            rightSpaceNum = 0;
            leftSpaceNum = blankNum;
        } else if (blankNum % 2 == 0) {
            rightSpaceNum = leftSpaceNum = blankNum / 2;
        } else if (blankNum % 2 == 1) {
            leftSpaceNum = blankNum / 2 + 1;
            rightSpaceNum = leftSpaceNum - 1;
        } else {
            leftSpaceNum = 0;
            rightSpaceNum = 0;
        }
        for (i = 0; i < leftSpaceNum; ++i) {
            body.append(BLANK);
        }
        body.append((CharSequence)text);
        for (i = 0; i < rightSpaceNum; ++i) {
            body.append(BLANK);
        }
        return leftSpaceNum;
    }

    protected final void setETextStyle(Style style, EText text, boolean doubleSize) {
        if (style != null) {
            text.setBold(style.isBold());
            if (style.isUnderline()) {
                text.setUnderline(EscPosConst.Underline.OneDotThick);
            }
        }
        if (doubleSize) {
            text.setFontWidth(EscPosConst.FontSize._2);
            text.setFontHeight(EscPosConst.FontSize._2);
        }
    }

    protected final boolean isContainsBorder(Style style) {
        if (style == null) {
            return false;
        }
        LineStyle lineStyle = style.getBorderLineStyle(Styles.Position.TOP);
        if (lineStyle != null && !lineStyle.isNullBorder()) {
            return true;
        }
        lineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM);
        if (lineStyle != null && !lineStyle.isNullBorder()) {
            return true;
        }
        lineStyle = style.getBorderLineStyle(Styles.Position.LEFT);
        if (lineStyle != null && !lineStyle.isNullBorder()) {
            return true;
        }
        lineStyle = style.getBorderLineStyle(Styles.Position.RIGHT);
        return lineStyle != null && !lineStyle.isNullBorder();
    }

    static class EscpContext {
        private int baseY1 = 0;
        private int baseX2 = 0;

        EscpContext() {
        }

        public int getBaseY1() {
            return this.baseY1;
        }

        public void setBaseY1(int baseY1) {
            this.baseY1 = baseY1;
        }

        public int getBaseX2() {
            return this.baseX2;
        }

        public void setBaseX2(int baseX2) {
            this.baseX2 = baseX2;
        }

        public void reset() {
            this.baseY1 = 0;
            this.baseX2 = 0;
        }
    }
}

