/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert.escp;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.convert.escp.BaseEscpConvert;
import kd.bos.print.core.esc.model.ETable;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.model.designer.grid.MergeBlock;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.AbstractPrintWidgetText;
import kd.bos.print.core.model.widget.grid.AbstractPWGrid;
import kd.bos.print.core.model.widget.grid.AbstractPWGridCell;
import kd.bos.print.core.model.widget.grid.AbstractPWGridColumn;
import kd.bos.print.core.model.widget.grid.AbstractPWGridRow;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGrid;
import kd.bos.print.core.model.widget.grid.datagrid.PWDataGridColumn;

public class PWGridEscpConvert
extends BaseEscpConvert {
    private boolean rowRemain = false;
    private boolean containsBorder = true;
    private int bottomGridSumNum = 0;
    private int bottomGridAdd = 0;

    public PWGridEscpConvert(BaseEscpConvert.EscpContext context) {
        super(context);
    }

    private MergeType judgeMergeType(AbstractPWGrid grid, int row, int col) {
        Map<String, MergeBlock> mergeBlocks = grid.getMergeBlocks();
        Iterator<MergeBlock> iterator = mergeBlocks.values().iterator();
        while (iterator.hasNext()) {
            boolean vmerge;
            MergeBlock block;
            MergeBlock mergeBlock = block = iterator.next();
            int top = mergeBlock.getTop();
            int bottom = mergeBlock.getBottom();
            int left = mergeBlock.getLeft();
            int right = mergeBlock.getRight();
            boolean hmerge = row >= top && row <= bottom && col > left && col <= right;
            boolean bl = vmerge = col >= left && col <= right && row > top && row <= bottom;
            if (hmerge && vmerge) {
                return MergeType.HV_MERGED;
            }
            if (hmerge) {
                return MergeType.H_MERGED;
            }
            if (!vmerge) continue;
            return MergeType.V_MERGED;
        }
        return MergeType.NO_MERGED;
    }

    @Override
    public ETable convert(AbstractPrintWidget widget, boolean fixed) {
        AbstractPWGrid grid = (AbstractPWGrid)widget;
        Style gridStyle = grid.getStyle();
        this.containsBorder = this.isContainsBorder(gridStyle);
        List outputRows = grid.getOutputRows();
        ETable table = new ETable();
        ArrayList<ETextLine> textRows = new ArrayList<ETextLine>(10);
        table.setRows(textRows);
        table.setLineSpacing(25);
        boolean ignoreHead = false;
        int hmgFlag = 0;
        int crn = 1;
        int rowIndex = 0;
        while (rowIndex < outputRows.size()) {
            AbstractPWGridRow row = (AbstractPWGridRow)outputRows.get(rowIndex);
            if (row == null) continue;
            boolean adjustHeight = row.isAdjustHeight();
            StringBuilder head = null;
            if (!ignoreHead) {
                head = new StringBuilder();
            }
            ETextLine bodyLine = new ETextLine();
            List<EText> bodyTexts = bodyLine.getTexts();
            double rowHeight = (double)((AbstractPWGridRow)grid.getRow(row.getRowIndex())).getHeight() / 10.0;
            int rn = (int)(rowHeight / 3.5319444868299694) - 1;
            boolean endRow = rowIndex == outputRows.size() - 1 && crn >= rn;
            StringBuilder foot = null;
            if (endRow) {
                foot = new StringBuilder();
            }
            int cellCount = row.getCellCount();
            for (int colIndex = 0; colIndex < cellCount; ++colIndex) {
                Style style;
                Object cell = row.getCell(colIndex);
                String outputText = "";
                int cn = this.calcCharNumFromGrid(grid, colIndex, row.isSubRow());
                if (cell != null) {
                    outputText = ((AbstractPrintWidgetText)cell).getOutputText();
                    ((AbstractPrintWidgetText)cell).setOutputText("");
                    style = ((AbstractPrintWidget)cell).getStyle();
                } else {
                    style = row.getStyle();
                }
                boolean rightBorder = colIndex == cellCount - 1;
                MergeType mergeType = this.judgeMergeType(grid, row.getRowIndex(), colIndex);
                if (head != null) {
                    int fit;
                    if (cell != null) {
                        if (rowIndex == 0) {
                            this.appendBorder(head, CellSymbol.HEAD_LT, CellSymbol.HEAD_CT, CellSymbol.HEAD_RT, CellSymbol.HEAD_SG, rightBorder, colIndex, cn);
                        } else {
                            boolean f;
                            fit = 1 << colIndex;
                            boolean bl = f = (hmgFlag & fit) == fit;
                            if (f) {
                                hmgFlag -= fit;
                            }
                            this.appendBorder(head, CellSymbol.INNER_LM, f ? CellSymbol.INNER_CM2_HMG : CellSymbol.INNER_CM, f ? CellSymbol.INNER_RM2_HMG : CellSymbol.INNER_RM, CellSymbol.INNER_SG, rightBorder, colIndex, cn);
                        }
                    } else if (rowIndex == 0) {
                        this.appendBorder(head, CellSymbol.HEAD_LT, CellSymbol.HEAD_CT_MGED, CellSymbol.HEAD_RT_MGED, CellSymbol.HEAD_SG, rightBorder, colIndex, cn);
                        hmgFlag += 1 << colIndex;
                    } else if (mergeType == MergeType.V_MERGED) {
                        MergeType leftMergeType = this.judgeMergeType(grid, row.getRowIndex(), colIndex - 1);
                        boolean vmg = leftMergeType == MergeType.V_MERGED || leftMergeType == MergeType.HV_MERGED;
                        this.appendBorder(head, CellSymbol.INNER_LM_VMGED, vmg ? CellSymbol.INNER_LM_VMGED : CellSymbol.INNER_CM_VMG, vmg ? CellSymbol.INNER_RM_VMGED : CellSymbol.INNER_RM_VMG, CellSymbol.INNER_SG_VMG, rightBorder, colIndex, cn);
                    } else if (mergeType == MergeType.H_MERGED) {
                        boolean f;
                        fit = 1 << colIndex;
                        boolean bl = f = (hmgFlag & fit) == fit;
                        if (f) {
                            hmgFlag -= fit;
                        }
                        this.appendBorder(head, CellSymbol.INNER_LM, f ? CellSymbol.INNER_CM2_HMGED : CellSymbol.INNER_CM_HMGED, f ? CellSymbol.INNER_RM2_HMGED : CellSymbol.INNER_RM_HMGED, CellSymbol.INNER_SG, rightBorder, colIndex, cn);
                        hmgFlag += 1 << colIndex;
                    } else if (mergeType == MergeType.HV_MERGED) {
                        this.appendBorder(head, CellSymbol.INNER_CM_HVMGED, CellSymbol.INNER_CM_HVMGED, CellSymbol.INNER_CM_HVMGED, CellSymbol.INNER_RM_HVMGED, rightBorder, colIndex, cn);
                    } else {
                        MergeType leftMergeType = this.judgeMergeType(grid, row.getRowIndex(), colIndex - 1);
                        boolean vmg = leftMergeType == MergeType.V_MERGED || leftMergeType == MergeType.HV_MERGED;
                        this.appendBorder(head, CellSymbol.INNER_LM_VMGED, vmg ? CellSymbol.INNER_LM_VMGED : CellSymbol.INNER_CM_VMG, vmg ? CellSymbol.INNER_RM_VMGED : CellSymbol.INNER_RM_VMG, CellSymbol.INNER_SG_VMG, rightBorder, colIndex, cn);
                    }
                }
                boolean hmg = mergeType == MergeType.H_MERGED || mergeType == MergeType.HV_MERGED;
                EText cellEText = this.appendText(outputText, cn, (AbstractPWGridCell)cell, rightBorder, hmg, adjustHeight, style);
                bodyTexts.add(cellEText);
                if (!endRow) continue;
                this.appendBorder(foot, CellSymbol.FOOT_LB, hmg ? CellSymbol.FOOT_CB_HMGED : CellSymbol.FOOT_CB, hmg ? CellSymbol.FOOT_RB_HMGED : CellSymbol.FOOT_RB, CellSymbol.FOOT_SG, rightBorder, colIndex, cn);
            }
            if (head != null) {
                textRows.add(this.createBorderTextLine(head));
            }
            textRows.add(bodyLine);
            if (!this.rowRemain && crn >= rn) {
                ++rowIndex;
                crn = 1;
                ignoreHead = false;
            } else {
                if (foot != null) {
                    foot.setLength(0);
                }
                ++crn;
                ignoreHead = true;
            }
            if (StringUtils.isNotBlank((CharSequence)foot)) {
                textRows.add(this.createBorderTextLine(foot));
            }
            this.rowRemain = false;
        }
        Rectangle childRect = grid.getRectangle();
        this.setPosition(table, childRect.x, childRect.y, childRect.width, childRect.height, fixed);
        return table;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int calcCharNumFromGrid(AbstractPWGrid grid, int colIndex, boolean subRow) {
        void var4_11;
        void var4_9;
        Object var4_4 = null;
        if (grid instanceof PWDataGrid) {
            PWDataGrid dataGrid = (PWDataGrid)grid;
            int gridColumnCount = dataGrid.getColumnCount();
            PWDataGrid subDataGrid = null;
            List<PWDataGrid> subDataGrids = dataGrid.getSubDataGrids();
            if (!CollectionUtils.isEmpty(subDataGrids) && (subDataGrid = subDataGrids.get(0)) != null && "bottom".equals(subDataGrid.getSubGridDirection())) {
                int subGridColumnCount = subDataGrid.getColumnCount();
                if (subGridColumnCount > gridColumnCount) {
                    if (!subRow) return this.calcBottomGridSumNum(colIndex, dataGrid, subDataGrid, gridColumnCount, subGridColumnCount - gridColumnCount);
                    Object c = subDataGrid.getColumn(colIndex);
                } else {
                    if (subRow) {
                        return this.calcBottomGridSumNum(colIndex, subDataGrid, dataGrid, subGridColumnCount, gridColumnCount - subGridColumnCount);
                    }
                    Object c = dataGrid.getColumn(colIndex);
                }
            } else if (subDataGrid != null && "right".equals(subDataGrid.getSubGridDirection())) {
                Object c = subDataGrid.getColumn(colIndex - gridColumnCount);
            }
        }
        if (var4_9 != null) return this.calcCharNum(var4_11.getWidth());
        Object c = grid.getColumn(colIndex);
        return this.calcCharNum(var4_11.getWidth());
    }

    private int calcBottomGridSumNum(int colIndex, PWDataGrid grid, PWDataGrid colGrid, int columnCount, int extraColNum) {
        int num;
        if (this.bottomGridSumNum == 0) {
            for (int i = 0; i < colGrid.getColumnCount(); ++i) {
                PWDataGridColumn column = (PWDataGridColumn)colGrid.getColumn(i);
                int width = column.getWidth();
                this.bottomGridSumNum += this.calcCharNum(width);
            }
            this.bottomGridSumNum += 2 * extraColNum;
        }
        if (columnCount - 1 == colIndex) {
            int cn = this.bottomGridSumNum - this.bottomGridAdd;
            this.bottomGridAdd = 0;
            return cn;
        }
        Object column = grid.getColumn(colIndex);
        this.bottomGridAdd += (num -= (num = (int)Math.round((double)((AbstractPWGridColumn)column).getWidth() / grid.getRectangle().getWidth() * (double)this.bottomGridSumNum)) % 2 == 0 ? 0 : 1);
        return num;
    }

    @Override
    protected void release() {
        super.release();
        this.bottomGridSumNum = 0;
        this.bottomGridAdd = 0;
        this.rowRemain = false;
        this.containsBorder = true;
    }

    private int calcCharNum(int width) {
        int cn;
        return cn -= (cn = (int)Math.round((double)width / 10.0 / 2.119166692097982)) % 2 == 0 ? 0 : 1;
    }

    private ETextLine createBorderTextLine(StringBuilder border) {
        ETextLine borderLine = new ETextLine();
        List<EText> borderTexts = borderLine.getTexts();
        EText borderText = new EText();
        borderText.setText(border.toString());
        borderText.setStart(0);
        borderText.setEnd(border.length());
        borderTexts.add(borderText);
        return borderLine;
    }

    private EText appendText(String outputText, int cn, AbstractPWGridCell cell, boolean rightBorder, boolean hmg, boolean adjustHeight, Style style) {
        StringBuilder text = new StringBuilder();
        if (hmg || !this.containsBorder) {
            text.append("  ");
        } else {
            text.append("\u2502");
        }
        StringBuilder body = new StringBuilder();
        int tempCN = 0;
        for (int n = 0; n < outputText.length(); ++n) {
            char c = outputText.charAt(n);
            int add = EscUtil.isDoubleWidth(c) ? 2 : 1;
            if (c == '\n') {
                if (cell != null) {
                    cell.setOutputText(outputText.substring(n + 1));
                }
                this.rowRemain = adjustHeight;
                break;
            }
            if (tempCN + add > cn) {
                if (cell != null) {
                    cell.setOutputText(outputText.substring(n));
                }
                this.rowRemain = adjustHeight;
                break;
            }
            tempCN += add;
            body.append(c);
        }
        int leftSpaceNum = this.appendBlank(text, cn, body, tempCN, style != null ? style.getHorizontalAlign() : Styles.HorizontalAlignment.LEFT);
        if (rightBorder) {
            if (this.containsBorder) {
                text.append("\u2502");
            } else {
                text.append("  ");
            }
        }
        EText cellEText = new EText();
        this.setETextStyle(style, cellEText, false);
        cellEText.setText(text.toString());
        cellEText.setStart(1 + leftSpaceNum);
        cellEText.setEnd(1 + leftSpaceNum + body.length());
        return cellEText;
    }

    private void appendBorder(StringBuilder text, CellSymbol leftCell, CellSymbol centerCell, CellSymbol rightCell, CellSymbol singleCell, boolean rightBorder, int colIndex, int cn) {
        if (!this.containsBorder) {
            leftCell = CellSymbol.NO_BORDER_L;
            centerCell = CellSymbol.NO_BORDER_L;
            rightCell = CellSymbol.NO_BORDER_R;
            singleCell = CellSymbol.NO_BORDER_R;
        }
        if (text == null) {
            return;
        }
        if (colIndex == 0 && rightBorder) {
            this.appendCellBorder(text, cn, singleCell);
        } else if (colIndex == 0) {
            this.appendCellBorder(text, cn, leftCell);
        } else if (rightBorder) {
            if (text.toString().endsWith(" ")) {
                this.appendCellBorder(text, cn, singleCell);
            } else {
                this.appendCellBorder(text, cn, rightCell);
            }
        } else if (text.toString().endsWith(" ")) {
            this.appendCellBorder(text, cn, leftCell);
        } else {
            this.appendCellBorder(text, cn, centerCell);
        }
    }

    private void appendCellBorder(StringBuilder text, int cn, CellSymbol headLt) {
        text.append(headLt.start);
        for (int n = 0; n < cn / 2; ++n) {
            text.append(headLt.repeat);
        }
        text.append(headLt.end);
    }

    private static enum CellSymbol {
        NO_BORDER_L("  ", "  ", ""),
        NO_BORDER_R("  ", "  ", "  "),
        HEAD_LT("\u250c", "\u2500", ""),
        HEAD_CT("\u252c", "\u2500", ""),
        HEAD_RT("\u252c", "\u2500", "\u2510"),
        HEAD_SG("\u250c", "\u2500", "\u2510"),
        HEAD_CT_MGED("\u2500", "\u2500", ""),
        HEAD_RT_MGED("\u2500", "\u2500", "\u2510"),
        INNER_LM("\u251c", "\u2500", ""),
        INNER_CM("\u253c", "\u2500", ""),
        INNER_RM("\u253c", "\u2500", "\u2524"),
        INNER_SG("\u251c", "\u2500", "\u2524"),
        INNER_LM_VMG("\u2502", "  ", ""),
        INNER_CM_VMG("\u2524", "  ", ""),
        INNER_RM_VMG("\u2524", "  ", "\u2502"),
        INNER_SG_VMG("\u2502", "  ", "\u2502"),
        INNER_CM_HMGED("\u2534", "\u2500", ""),
        INNER_CM2_HMG("\u252c", "\u2500", ""),
        INNER_CM2_HMGED("\u2500", "\u2500", ""),
        INNER_RM_HMGED("\u2534", "\u2500", "\u2524"),
        INNER_RM2_HMG("\u252c", "\u2500", "\u2524"),
        INNER_RM2_HMGED("\u2500", "\u2500", "\u2524"),
        INNER_LM_VMGED("\u2502", "  ", ""),
        INNER_RM_VMGED("\u2502", "  ", "\u2502"),
        INNER_CM_HVMGED("  ", "  ", ""),
        INNER_RM_HVMGED("  ", "  ", "\u2502"),
        FOOT_LB("\u2514", "\u2500", ""),
        FOOT_CB("\u2534", "\u2500", ""),
        FOOT_RB("\u2534", "\u2500", "\u2518"),
        FOOT_SG("\u2514", "\u2500", "\u2518"),
        FOOT_CB_HMGED("\u2500", "\u2500", ""),
        FOOT_RB_HMGED("\u2500", "\u2500", "\u2518");

        final String start;
        final String repeat;
        final String end;

        private CellSymbol(String start, String repeat, String end) {
            this.start = start;
            this.repeat = repeat;
            this.end = end;
        }
    }

    static enum MergeType {
        NO_MERGED,
        H_MERGED,
        V_MERGED,
        HV_MERGED;

    }
}

