/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert.escp;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.ctrl.reportone.r1.print.common.R1PrintInfo;
import kd.bos.print.core.esc.convert.escp.BaseEscpConvert;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EPage;
import kd.bos.print.core.execute.render.painter.PaintPaperInfo;
import kd.bos.print.core.execute.render.painter.pwpainer.image.ImagePaperPainter;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWFooter;
import kd.bos.print.core.model.widget.PWPage;
import kd.bos.print.core.model.widget.PWidgetUtil;
import kd.bos.print.core.model.widget.PrintAtPage;
import kd.bos.print.core.model.widget.grid.tabletail.PWTableTail;

public class PWPageEscpConvert
extends BaseEscpConvert {
    private static final Log log = LogFactory.getLog(PWPageEscpConvert.class);

    public PWPageEscpConvert() {
        super(new BaseEscpConvert.EscpContext());
    }

    @Override
    public EPage convert(ImagePaperPainter painter) {
        PWPage page = (PWPage)painter.getPaintObj();
        if (page == null) {
            return null;
        }
        List children = page.getChildren();
        children = children.stream().sorted((c1, c2) -> {
            Rectangle r1 = c1.getRectangle();
            Rectangle r2 = c2.getRectangle();
            int compare = Double.compare(r1.getY(), r2.getY());
            if (compare == 0) {
                return Double.compare(r1.getX(), r2.getX());
            }
            return compare;
        }).collect(Collectors.toList());
        PaintPaperInfo paperInfo = painter.getPaperInfo();
        R1PrintInfo r1PrintInfo = paperInfo.getR1PrintInfo();
        Dimension paperSize = r1PrintInfo.getPaperSize();
        EPage ePage = new EPage();
        ePage.setWidth(paperSize.width);
        ePage.setHeight(paperSize.height);
        ArrayList<EBlock> blocks = new ArrayList<EBlock>(children.size());
        ePage.setBlocks(blocks);
        for (AbstractPrintWidget child : children) {
            try {
                if (child == null) continue;
                if (child instanceof PWFooter) {
                    PWFooter footer = (PWFooter)child;
                    List footerChildren = footer.getChildren();
                    for (AbstractPrintWidget footerChild : footerChildren) {
                        AbstractPrintWidget copy = PWidgetUtil.widgetCopyWithOutputValue(footerChild);
                        Rectangle rectangle = copy.getRectangle();
                        rectangle.y += footer.getRectangle().y;
                        this.convertWidget(painter, blocks, copy, true);
                    }
                    continue;
                }
                if (child instanceof PWTableTail) {
                    PWTableTail tableTail = (PWTableTail)child;
                    List<AbstractPrintWidget> tailChildren = tableTail.getChildren();
                    for (AbstractPrintWidget tailChild : tailChildren) {
                        Rectangle rectangle = tailChild.getRectangle();
                        rectangle.x += tableTail.getRectangle().x;
                        rectangle.y += tableTail.getRectangle().y;
                        this.convertWidget(painter, blocks, tailChild, false);
                    }
                }
                boolean fixed = child.getPrintAtPage() == PrintAtPage.All || child.getPrintAtPage() == PrintAtPage.First || child.getPrintAtPage() == PrintAtPage.Last;
                this.convertWidget(painter, blocks, child, fixed);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        this.context.reset();
        return ePage;
    }
}

