/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.convert.escp;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ctrl.kdf.util.style.LineStyle;
import kd.bos.print.core.ctrl.kdf.util.style.Style;
import kd.bos.print.core.ctrl.kdf.util.style.Styles;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.convert.escp.BaseEscpConvert;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.ETable;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.model.widget.AbstractPrintWidget;
import kd.bos.print.core.model.widget.PWText;

public class PWTextEscpConvert
extends BaseEscpConvert {
    public PWTextEscpConvert(BaseEscpConvert.EscpContext context) {
        super(context);
    }

    @Override
    public EBlock convert(AbstractPrintWidget widget, boolean fixed) {
        LineStyle lineStyle;
        PWText pwText = (PWText)widget;
        EBlock block = null;
        Rectangle childRect = pwText.getRectangle();
        Style style = pwText.getStyle();
        int borderStyle = 0;
        if (style != null && (lineStyle = style.getBorderLineStyle(Styles.Position.TOP)) != null && !lineStyle.isNullBorder()) {
            ++borderStyle;
        }
        if (style != null && (lineStyle = style.getBorderLineStyle(Styles.Position.RIGHT)) != null && !lineStyle.isNullBorder()) {
            borderStyle += 2;
        }
        if (style != null && (lineStyle = style.getBorderLineStyle(Styles.Position.BOTTOM)) != null && !lineStyle.isNullBorder()) {
            borderStyle += 4;
        }
        if (style != null && (lineStyle = style.getBorderLineStyle(Styles.Position.LEFT)) != null && !lineStyle.isNullBorder()) {
            borderStyle += 8;
        }
        boolean adjustHeight = pwText.isAdjustHeight();
        String outputText = pwText.getOutputText();
        boolean doubleSize = style != null && Float.compare(EscPosConst.FontSize._1.pxSize, style.getFontSizeF()) < 0;
        int cn = (int)(childRect.getWidth() / 10.0 / (doubleSize ? 4.238333384195964 : 2.119166692097982));
        cn -= cn % 2 == 0 ? 0 : 1;
        ArrayList<TextObject> textObjects = new ArrayList<TextObject>(4);
        int rn = (int)(childRect.getHeight() / 10.0 / (doubleSize ? 7.063888973659939 : 3.5319444868299694)) - 1;
        if (borderStyle == 0) {
            StringBuilder outputBuilder = new StringBuilder(outputText);
            int crn = 1;
            do {
                TextObject textObject = this.appendText(outputBuilder, cn, style != null ? style.getHorizontalAlign() : Styles.HorizontalAlignment.LEFT);
                textObjects.add(textObject);
            } while (outputBuilder.length() > 0 && adjustHeight || ++crn <= rn);
            block = textObjects.size() == 1 ? this.convertToEText(style, doubleSize, (TextObject)textObjects.get(0)) : this.textObjects2ETable(style, doubleSize, textObjects, textObjects.size());
        } else {
            StringBuilder head = new StringBuilder();
            BorderType borderType = BorderType.getBorderType(borderStyle);
            head.append(borderType.ltAngle.symbol);
            for (int n = 0; n < cn / 2; ++n) {
                head.append(borderType.topLine);
            }
            head.append(borderType.rtAngle.symbol);
            ArrayList<ETextLine> rows = new ArrayList<ETextLine>(4);
            rows.add(this.convertToETextLine(null, doubleSize, new TextObject(head)));
            StringBuilder outputBuilder = new StringBuilder(outputText);
            int crn = 1;
            do {
                TextObject textObject = this.appendText(outputBuilder, cn, style != null ? style.getHorizontalAlign() : Styles.HorizontalAlignment.LEFT);
                StringBuilder text = textObject.getText();
                text.insert(0, borderType.leftLine);
                text.append(borderType.rightLine);
                textObject.setStart(textObject.getStart() + borderType.leftLine.length());
                textObject.setEnd(textObject.getEnd() + borderType.leftLine.length());
                rows.add(this.convertToETextLine(style, doubleSize, textObject));
            } while (outputBuilder.length() > 0 && adjustHeight || ++crn <= rn);
            StringBuilder foot = new StringBuilder();
            foot.append(borderType.lbAngle.symbol);
            for (int n = 0; n < cn / 2; ++n) {
                foot.append(borderType.bottomLine);
            }
            foot.append(borderType.rbAngle.symbol);
            rows.add(this.convertToETextLine(null, doubleSize, new TextObject(foot)));
            ETable table = new ETable();
            table.setRows(rows);
            block = table;
        }
        this.setPosition(block, childRect.x, childRect.y, childRect.width, childRect.height, fixed);
        return block;
    }

    private ETable textObjects2ETable(Style style, boolean doubleSize, List<TextObject> textObjects, int size) {
        ETable table = new ETable();
        ArrayList<ETextLine> rows = new ArrayList<ETextLine>(size);
        table.setRows(rows);
        for (TextObject textObject : textObjects) {
            ETextLine textLine = this.convertToETextLine(style, doubleSize, textObject);
            rows.add(textLine);
        }
        return table;
    }

    private ETextLine convertToETextLine(Style style, boolean doubleSize, TextObject textObject) {
        ETextLine textLine = new ETextLine();
        textLine.getTexts().add(this.convertToEText(style, doubleSize, textObject));
        return textLine;
    }

    private EText convertToEText(Style style, boolean doubleSize, TextObject textObject) {
        EText eText = new EText();
        eText.setText(textObject.getText().toString());
        eText.setStart(textObject.getStart());
        eText.setEnd(textObject.getEnd());
        this.setETextStyle(style, eText, doubleSize);
        return eText;
    }

    private TextObject appendText(StringBuilder outputText, int cn, Styles.HorizontalAlignment horizontalAlignment) {
        StringBuilder text = new StringBuilder();
        int tempCN = 0;
        for (int n = 0; n < outputText.length(); ++n) {
            char c = outputText.charAt(n);
            int add = EscUtil.isDoubleWidth(c) ? 2 : 1;
            if (c == '\n') {
                String remainText = outputText.substring(n + 1);
                outputText.setLength(0);
                outputText.append(remainText);
                StringBuilder body = new StringBuilder();
                this.appendBlank(body, cn, text, tempCN, Styles.HorizontalAlignment.LEFT);
                return new TextObject(body, 0, body.length());
            }
            if (tempCN + add > cn) {
                String remainText = outputText.substring(n);
                outputText.setLength(0);
                outputText.append(remainText);
                if (tempCN < cn) {
                    for (int i = 0; i < cn - tempCN; ++i) {
                        text.append(" ");
                    }
                }
                return new TextObject(text, 0, text.length());
            }
            tempCN += add;
            text.append(c);
        }
        StringBuilder body = new StringBuilder();
        int leftSpaceNum = this.appendBlank(body, cn, text, tempCN, horizontalAlignment);
        TextObject textObject = new TextObject(body, leftSpaceNum, leftSpaceNum + text.length());
        outputText.setLength(0);
        text.setLength(0);
        return textObject;
    }

    static enum Line {
        BLANK(0, "  "),
        TOP(1, "\u2500"),
        RIGHT(2, "\u2502"),
        BOTTOM(4, "\u2500"),
        LEFT(8, "\u2502");

        public final int value;
        public final String symbol;

        private Line(int value, String symbol) {
            this.value = value;
            this.symbol = symbol;
        }
    }

    static enum Angle {
        BLANK(0, 0, "  "),
        L_T(Line.LEFT.value, Line.TOP.value, "\u250c"),
        R_T(Line.RIGHT.value, Line.TOP.value, "\u2510"),
        L_B(Line.LEFT.value, Line.BOTTOM.value, "\u2514"),
        R_B(Line.RIGHT.value, Line.BOTTOM.value, "\u2518");

        public final int h;
        public final int v;
        public final String symbol;

        private Angle(int h, int v, String symbol) {
            this.h = h;
            this.v = v;
            this.symbol = symbol;
        }
    }

    static enum BorderType {
        NULL(0),
        T(1),
        R(2),
        T_R(3),
        B(4),
        T_B(5),
        R_B(6),
        T_R_B(7),
        L(8),
        T_L(9),
        R_L(10),
        T_R_L(11),
        B_L(12),
        T_B_L(13),
        R_B_L(14),
        T_R_B_L(15);

        public final int style;
        public final String topLine;
        public final String rightLine;
        public final String bottomLine;
        public final String leftLine;
        public final Angle ltAngle;
        public final Angle rtAngle;
        public final Angle lbAngle;
        public final Angle rbAngle;

        private BorderType(int style) {
            this.style = style;
            this.topLine = (style & Line.TOP.value) == Line.TOP.value ? Line.TOP.symbol : Line.BLANK.symbol;
            this.rightLine = (style & Line.RIGHT.value) == Line.RIGHT.value ? Line.RIGHT.symbol : Line.BLANK.symbol;
            this.bottomLine = (style & Line.BOTTOM.value) == Line.BOTTOM.value ? Line.BOTTOM.symbol : Line.BLANK.symbol;
            this.leftLine = (style & Line.LEFT.value) == Line.LEFT.value ? Line.LEFT.symbol : Line.BLANK.symbol;
            this.ltAngle = (style & Angle.L_T.h) == Angle.L_T.h && (style & Angle.L_T.v) == Angle.L_T.v ? Angle.L_T : Angle.BLANK;
            this.rtAngle = (style & Angle.R_T.h) == Angle.R_T.h && (style & Angle.R_T.v) == Angle.R_T.v ? Angle.R_T : Angle.BLANK;
            this.lbAngle = (style & Angle.L_B.h) == Angle.L_B.h && (style & Angle.L_B.v) == Angle.L_B.v ? Angle.L_B : Angle.BLANK;
            this.rbAngle = (style & Angle.R_B.h) == Angle.R_B.h && (style & Angle.R_B.v) == Angle.R_B.v ? Angle.R_B : Angle.BLANK;
        }

        public static BorderType getBorderType(int style) {
            BorderType[] values = BorderType.values();
            if (style < 0 || style >= values.length) {
                return NULL;
            }
            return values[style];
        }
    }

    static class TextObject {
        private final StringBuilder text;
        private int start;
        private int end;

        public TextObject(StringBuilder text) {
            this.text = text == null ? new StringBuilder() : text;
            this.start = 0;
            this.end = this.text.length();
        }

        public TextObject(StringBuilder text, int start, int end) {
            this.text = text == null ? new StringBuilder() : text;
            this.start = start;
            this.end = end;
        }

        public StringBuilder getText() {
            return this.text;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }
}

