/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.io.IOException;
import java.io.OutputStream;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.writer.EscWriter;

public abstract class AbstractEscWriter<T extends EBlock>
implements EscWriter<EBlock>,
EscPosConst {
    protected final EscPos escPos;
    protected final OutputStream outputStream;

    public AbstractEscWriter(EscPos escPos) {
        this.escPos = escPos;
        this.outputStream = escPos.getOutputStream();
    }

    @Override
    public void write(EBlock block) throws IOException {
        if (block == null) {
            return;
        }
        this.movePosition(block);
        this.writeBlock(block);
    }

    protected void movePosition(EBlock block) throws IOException {
        int trd = block.getTrd();
        if (trd != 0) {
            if (trd > 255) {
                int loop = trd / 255;
                int remain = trd % 255;
                for (int i = 0; i < loop; ++i) {
                    this.escPos.moveY(255);
                }
                this.escPos.moveY(remain);
            } else {
                this.escPos.moveY(trd);
            }
        }
        int lrd = block.getLrd();
        if ((lrd = (int)((double)lrd / (double)254.3f * 203.0)) != 0) {
            this.escPos.moveX(lrd);
        }
    }

    protected abstract void writeBlock(T var1) throws IOException;
}

