/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.model.EBarcode;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.writer.AbstractEscWriter;

public class BarcodeEscWriter
extends AbstractEscWriter<EBarcode> {
    public BarcodeEscWriter(EscPos escPos) {
        super(escPos);
    }

    @Override
    protected void writeBlock(EBarcode block) throws IOException {
        byte[] bytes = this.getBytes(block);
        this.outputStream.write(bytes, 0, bytes.length);
    }

    @Override
    protected void movePosition(EBlock block) throws IOException {
        block.setLrd(0);
        super.movePosition(block);
    }

    public byte[] getBytes(EBarcode barcode) {
        String data = barcode.getText();
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        if (barcode.getSystem().regex.length() > 0 && !data.matches(barcode.getSystem().regex)) {
            throw new IllegalArgumentException(String.format("data must match with \"%s\"", barcode.getSystem().regex));
        }
        bytes.write(29);
        bytes.write(104);
        bytes.write(barcode.getHeight());
        bytes.write(29);
        bytes.write(119);
        bytes.write(barcode.getWidth());
        bytes.write(29);
        bytes.write(72);
        bytes.write(barcode.getHriPosition().value);
        bytes.write(29);
        bytes.write(102);
        bytes.write(barcode.getHriFont().value);
        bytes.write(27);
        bytes.write(97);
        bytes.write(EscPosConst.Align.Center.value);
        bytes.write(29);
        bytes.write(107);
        bytes.write(barcode.getSystem().code);
        if (barcode.getSystem().code <= 6) {
            bytes.write(data.getBytes(), 0, data.length());
            bytes.write(0);
        } else {
            bytes.write(data.length());
            bytes.write(data.getBytes(), 0, data.length());
        }
        return bytes.toByteArray();
    }
}

