/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kd.bos.print.core.ExecuteContext;
import kd.bos.print.core.ctrl.print.util.KPrintUtil;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.esc.model.image.bitonal.Bitonal;
import kd.bos.print.core.esc.model.image.bitonal.BitonalThreshold;
import kd.bos.print.core.esc.writer.AbstractEscWriter;

public class ImageEscWriter
extends AbstractEscWriter<EImage> {
    public ImageEscWriter(EscPos escPos) {
        super(escPos);
    }

    @Override
    protected void writeBlock(EImage image) throws IOException {
        if (image == null || image.getImage() == null) {
            return;
        }
        byte[] bytes = "escpos".equals(ExecuteContext.get().getExpType()) ? BitImageParser.getEscBytes(image) : RasterImageParser.getBytes(image);
        this.outputStream.write(bytes, 0, bytes.length);
        this.outputStream.write(10);
    }

    private static class RasterImageParser {
        private static final Bitonal bitonalAlgorithm = new BitonalThreshold();

        private RasterImageParser() {
        }

        public static byte[] getBytes(EImage eImage) {
            BufferedImage image = eImage.getImage();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write(29);
            bytes.write(118);
            bytes.write(48);
            bytes.write(0);
            int horizontalBytes = image.getWidth() % 8 > 0 ? image.getWidth() / 8 + 1 : image.getWidth() / 8;
            int xL = horizontalBytes & 0xFF;
            int xH = (horizontalBytes & 0xFF00) >> 8;
            int verticalBits = image.getHeight();
            int yL = verticalBits & 0xFF;
            int yH = (verticalBits & 0xFF00) >> 8;
            bytes.write(xL);
            bytes.write(xH);
            bytes.write(yL);
            bytes.write(yH);
            byte[] rasterBytes = RasterImageParser.image2EscPosRaster(image).toByteArray();
            bytes.write(rasterBytes, 0, rasterBytes.length);
            return bytes.toByteArray();
        }

        private static ByteArrayOutputStream image2EscPosRaster(BufferedImage image) {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            for (int y = 0; y < image.getHeight(); ++y) {
                int Byte2 = 0;
                int bit = 0;
                for (int x = 0; x < image.getWidth(); ++x) {
                    int val = bitonalAlgorithm.getBitonalVal(image, x, y);
                    Byte2 |= val << 7 - bit;
                    if (++bit != 8) continue;
                    byteArray.write(Byte2);
                    Byte2 = 0;
                    bit = 0;
                }
                if (bit <= 0) continue;
                byteArray.write(Byte2);
            }
            return byteArray;
        }
    }

    public static class BitImageParser {
        private static final Bitonal bitonalAlgorithm = new BitonalThreshold();

        public static byte[] getEscBytes(EImage eImage) {
            BufferedImage image = eImage.getImage();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            bytes.write(27);
            bytes.write(51);
            bytes.write(16);
            int nL = image.getWidth() & 0xFF;
            int nH = (image.getWidth() & 0xFF00) >> 8;
            List<ByteArrayOutputStream> RasterColumns = BitImageParser.image2Rows(image, bitonalAlgorithm, eImage.getMode().bitsForVerticalData);
            for (ByteArrayOutputStream rol : RasterColumns) {
                bytes.write(27);
                bytes.write(42);
                bytes.write(eImage.getMode().value);
                bytes.write(nL);
                bytes.write(nH);
                bytes.write(rol.toByteArray(), 0, rol.size());
                bytes.write(10);
                int lrd = eImage.getLrd();
                if ((lrd = (int)KPrintUtil.lomToPrintPoint(lrd)) <= 0) continue;
                byte[] moveX = EscUtil.moveXCmd(lrd);
                bytes.write(moveX, 0, moveX.length);
            }
            return bytes.toByteArray();
        }

        public static byte[] getEscpBytes(EImage eImage) {
            BufferedImage image = eImage.getImage();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            int ln = 24;
            bytes.write(27);
            bytes.write(51);
            bytes.write(ln);
            int nL = image.getWidth() & 0xFF;
            int nH = (image.getWidth() & 0xFF00) >> 8;
            List<ByteArrayOutputStream> RasterColumns = BitImageParser.image2Rows(image, bitonalAlgorithm, eImage.getMode().bitsForVerticalData);
            for (ByteArrayOutputStream rol : RasterColumns) {
                bytes.write(27);
                bytes.write(42);
                bytes.write(39);
                bytes.write(nL);
                bytes.write(nH);
                bytes.write(rol.toByteArray(), 0, rol.size());
                bytes.write(10);
                int x = eImage.getX();
                if (x <= 0) continue;
                x = BitImageParser.mm2moveUnit(x);
                byte[] fixXPosition = EscUtil.fixXPosition(x);
                bytes.write(fixXPosition, 0, fixXPosition.length);
            }
            for (int i = 0; i < RasterColumns.size(); ++i) {
                bytes.write(27);
                bytes.write(106);
                bytes.write(ln);
            }
            return bytes.toByteArray();
        }

        private static int mm2moveUnit(int mm) {
            return (int)((double)mm / 254.0 * 360.0);
        }

        private static List<ByteArrayOutputStream> image2Rows(BufferedImage image, Bitonal bitonalAlgorithm, int bitsPerColumn8Or24) {
            ArrayList<ByteArrayOutputStream> lRasterRows = new ArrayList<ByteArrayOutputStream>(10);
            ArrayList<BufferedImage> lRGBImageRows = new ArrayList<BufferedImage>(10);
            for (int y = 0; y < image.getHeight(); y += bitsPerColumn8Or24) {
                int height = bitsPerColumn8Or24;
                if (y + height > image.getHeight()) {
                    height = image.getHeight() - y;
                }
                BufferedImage row = image.getSubimage(0, y, image.getWidth(), height);
                lRGBImageRows.add(row);
            }
            int heightOffset = 0;
            for (BufferedImage RGBRow : lRGBImageRows) {
                ByteArrayOutputStream baColumBytes = new ByteArrayOutputStream();
                for (int x = 0; x < RGBRow.getWidth(); ++x) {
                    int col = 0;
                    int max_y = Integer.min(bitsPerColumn8Or24, RGBRow.getHeight());
                    int bit = 0;
                    int bitsWritten = 0;
                    for (int y = 0; y < max_y; ++y) {
                        int val = bitonalAlgorithm.getBitonalVal(image, x, y + heightOffset);
                        col |= val << 7 - bit;
                        if (++bit != 8) continue;
                        baColumBytes.write(col);
                        bitsWritten += 8;
                        col = 0;
                        bit = 0;
                    }
                    if (bit < 0 || max_y >= bitsPerColumn8Or24) continue;
                    baColumBytes.write(col);
                    bitsWritten += 8;
                    while (bitsWritten < bitsPerColumn8Or24) {
                        baColumBytes.write(0);
                        bitsWritten += 8;
                    }
                }
                lRasterRows.add(baColumBytes);
                heightOffset += bitsPerColumn8Or24;
            }
            return lRasterRows;
        }
    }
}

