/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.io.IOException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.model.EBarcode;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.esc.model.EPage;
import kd.bos.print.core.esc.model.EQRCode;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.esc.writer.AbstractEscWriter;
import kd.bos.print.core.esc.writer.BarcodeEscWriter;
import kd.bos.print.core.esc.writer.EscWriter;
import kd.bos.print.core.esc.writer.ImageEscWriter;
import kd.bos.print.core.esc.writer.QRCodeEscWriter;
import kd.bos.print.core.esc.writer.TextEscWriter;
import kd.bos.print.core.esc.writer.TextLineEscWriter;

public final class PageEscWriter
implements EscWriter,
EscPosConst {
    private static final Log log = LogFactory.getLog(PageEscWriter.class);
    private final EscPos escPos;

    public PageEscWriter(EscPos escPos) {
        this.escPos = escPos;
    }

    @Override
    public void write(EPage ePage) {
        if (ePage == null) {
            return;
        }
        this.initPage();
        for (EBlock block : ePage.getBlocks()) {
            AbstractEscWriter escWriter;
            if (block instanceof EText) {
                escWriter = new TextEscWriter(this.escPos);
            } else if (block instanceof EBarcode) {
                escWriter = new BarcodeEscWriter(this.escPos);
            } else if (block instanceof EQRCode) {
                escWriter = new QRCodeEscWriter(this.escPos);
            } else if (block instanceof EImage) {
                escWriter = new ImageEscWriter(this.escPos);
            } else if (block instanceof ETextLine) {
                escWriter = new TextLineEscWriter(this.escPos);
            } else {
                log.info(String.format("not support this kind of block [%s]", block.getClass().toString()));
                continue;
            }
            try {
                escWriter.write(block);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    private void initPage() {
        try {
            this.escPos.initializePrinter();
            this.escPos.write(28);
            this.escPos.write(38);
        }
        catch (IOException e) {
            log.error((Throwable)e);
        }
    }
}

