/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.model.EQRCode;
import kd.bos.print.core.esc.writer.AbstractEscWriter;

public class QRCodeEscWriter
extends AbstractEscWriter<EQRCode> {
    public QRCodeEscWriter(EscPos escPos) {
        super(escPos);
    }

    @Override
    protected void writeBlock(EQRCode block) throws IOException {
        byte[] bytes = this.getBytes(block);
        this.outputStream.write(bytes, 0, bytes.length);
    }

    public byte[] getBytes(EQRCode eqrCode) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        String data = eqrCode.getText();
        int i = data.lastIndexOf("\n");
        if (i > 0 && i < data.length()) {
            data = data.substring(0, data.length() - 1);
        }
        bytes.write(27);
        bytes.write(97);
        bytes.write(eqrCode.getAlign().value);
        bytes.write(29);
        bytes.write(40);
        bytes.write(107);
        bytes.write(4);
        bytes.write(0);
        bytes.write(49);
        bytes.write(65);
        bytes.write(eqrCode.getModel().value);
        bytes.write(0);
        bytes.write(29);
        bytes.write(40);
        bytes.write(107);
        bytes.write(3);
        bytes.write(0);
        bytes.write(49);
        bytes.write(67);
        bytes.write(eqrCode.getSize());
        bytes.write(29);
        bytes.write(40);
        bytes.write(107);
        bytes.write(3);
        bytes.write(0);
        bytes.write(49);
        bytes.write(69);
        bytes.write(eqrCode.getEcl().value);
        byte[] dataBytes = data.getBytes();
        int numberOfBytes = dataBytes.length + 3;
        int pL = numberOfBytes & 0xFF;
        int pH = (numberOfBytes & 0xFF00) >> 8;
        bytes.write(29);
        bytes.write(40);
        bytes.write(107);
        bytes.write(pL);
        bytes.write(pH);
        bytes.write(49);
        bytes.write(80);
        bytes.write(48);
        bytes.write(dataBytes, 0, dataBytes.length);
        bytes.write(29);
        bytes.write(40);
        bytes.write(107);
        bytes.write(3);
        bytes.write(0);
        bytes.write(49);
        bytes.write(81);
        bytes.write(48);
        return bytes.toByteArray();
    }
}

