/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.writer.AbstractEscWriter;

public class TextEscWriter
extends AbstractEscWriter<EText> {
    public TextEscWriter(EscPos escPos) {
        super(escPos);
    }

    @Override
    protected void writeBlock(EText eText) throws IOException {
        String text = eText.getText();
        if (text == null) {
            return;
        }
        byte[] configBytes = TextEscWriter.getConfigBytes(eText);
        this.outputStream.write(configBytes, 0, configBytes.length);
        byte[] bytes = text.getBytes(eText.getCharsetName());
        this.outputStream.write(bytes);
        this.outputStream.write(10);
    }

    public static byte[] getConfigBytes(EText text) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        bytes.write(27);
        bytes.write(77);
        bytes.write(text.getFontName().value);
        bytes.write(27);
        bytes.write(69);
        int n = text.isBold() ? 1 : 0;
        bytes.write(n);
        n = text.getFontWidth().value << 4 | text.getFontWidth().value;
        bytes.write(29);
        bytes.write(33);
        bytes.write(n);
        bytes.write(27);
        bytes.write(45);
        bytes.write(text.getUnderline().value);
        bytes.write(27);
        bytes.write(97);
        bytes.write(text.getAlign().value);
        if (text.isDefaultLineSpacing()) {
            bytes.write(27);
            bytes.write(50);
        } else {
            bytes.write(27);
            bytes.write(51);
            bytes.write(text.getLineSpacing());
        }
        bytes.write(28);
        bytes.write(45);
        bytes.write(text.getUnderline().value);
        return bytes.toByteArray();
    }
}

