/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer;

import java.io.IOException;
import java.util.List;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.esc.writer.AbstractEscWriter;
import kd.bos.print.core.esc.writer.TextEscWriter;

public class TextLineEscWriter
extends AbstractEscWriter<ETextLine> {
    public TextLineEscWriter(EscPos escPos) {
        super(escPos);
    }

    @Override
    protected void writeBlock(ETextLine textLine) throws IOException {
        List<EText> texts = textLine.getTexts();
        if (texts == null || texts.size() <= 0) {
            return;
        }
        for (EText text : texts) {
            if (text == null || text.getText() == null) continue;
            this.movePosition(text);
            byte[] configBytes = TextEscWriter.getConfigBytes(text);
            this.outputStream.write(configBytes, 0, configBytes.length);
            byte[] bytes = text.getText().getBytes(text.getCharsetName());
            this.outputStream.write(bytes);
        }
        this.outputStream.write(10);
    }
}

