/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer.escp;

import java.io.IOException;
import java.io.OutputStream;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.EscUtil;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.writer.EscWriter;

public abstract class AbstractEscpWriter<T extends EBlock>
implements EscWriter<EBlock>,
EscPosConst {
    protected final EscPos escPos;
    protected final OutputStream outputStream;

    public AbstractEscpWriter(EscPos escPos) {
        this.escPos = escPos;
        this.outputStream = escPos.getOutputStream();
    }

    @Override
    public void write(EBlock block) throws IOException {
        if (block == null) {
            return;
        }
        this.movePosition(block);
        this.writeBlock(block);
    }

    protected void movePosition(EBlock block) throws IOException {
        int trd = block.getTrd();
        if ((trd = this.mm2moveUnit(trd)) > 0) {
            this.outputStream.write(EscUtil.moveBottom(trd));
        } else {
            int y = block.getY();
            if (y > 0) {
                y = this.mm2moveUnit(y);
                this.outputStream.write(EscUtil.fixYPosition(y));
            }
        }
        int lrd = block.getLrd();
        if (lrd > 0) {
            if ((lrd = this.mm2moveUnit(lrd)) > 0) {
                this.outputStream.write(EscUtil.moveRight(lrd));
            } else if (lrd < 0) {
                this.outputStream.write(EscUtil.moveLeft(-1 * lrd));
            }
        } else {
            int x = block.getX();
            if (x > 0) {
                x = this.mm2moveUnit(x);
                this.outputStream.write(EscUtil.fixXPosition(x));
            }
        }
    }

    private int mm2moveUnit(int mm) {
        return (int)((double)mm / 254.0 * 360.0);
    }

    protected abstract void writeBlock(T var1) throws IOException;
}

