/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.esc.writer.escp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.esc.EscPos;
import kd.bos.print.core.esc.EscPosConst;
import kd.bos.print.core.esc.model.EBarcode;
import kd.bos.print.core.esc.model.EBlock;
import kd.bos.print.core.esc.model.EImage;
import kd.bos.print.core.esc.model.EPage;
import kd.bos.print.core.esc.model.ETable;
import kd.bos.print.core.esc.model.EText;
import kd.bos.print.core.esc.model.ETextLine;
import kd.bos.print.core.esc.writer.EscWriter;
import kd.bos.print.core.esc.writer.ImageEscWriter;
import kd.bos.print.core.esc.writer.escp.AbstractEscpWriter;

public final class PageEscpWriter
implements EscWriter,
EscPosConst {
    private static final Log log = LogFactory.getLog(PageEscpWriter.class);
    private final EscPos escPos;

    public PageEscpWriter(EscPos escPos) {
        this.escPos = escPos;
    }

    @Override
    public void write(EPage ePage) {
        if (ePage == null || CollectionUtils.isEmpty(ePage.getBlocks())) {
            return;
        }
        try {
            this.initPage(ePage);
            this.convertPageChild(ePage);
            this.endPage();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
    }

    private void convertPageChild(EPage ePage) throws IOException {
        for (EBlock block : ePage.getBlocks()) {
            AbstractEscpWriter<EBlock> escpWriter;
            if (block == null) continue;
            if (block instanceof EText) {
                escpWriter = new AbstractEscpWriter<EText>(this.escPos){

                    @Override
                    protected void writeBlock(EText eText) throws IOException {
                        String text = eText.getText();
                        if (text == null) {
                            return;
                        }
                        this.outputStream.write(27);
                        this.outputStream.write(51);
                        this.outputStream.write(25);
                        PageEscpWriter.this.writeETextWithStyle(this.outputStream, eText);
                    }
                };
            } else if (block instanceof ETable) {
                escpWriter = new AbstractEscpWriter<ETable>(this.escPos){

                    @Override
                    protected void writeBlock(ETable table) throws IOException {
                        int i;
                        List<ETextLine> rows;
                        if (table == null || (rows = table.getRows()) == null) {
                            return;
                        }
                        this.outputStream.write(27);
                        this.outputStream.write(51);
                        this.outputStream.write(table.getLineSpacing());
                        this.escPos.write(28);
                        this.escPos.write(118);
                        this.escPos.write(1);
                        for (i = 0; i < rows.size(); ++i) {
                            ETextLine row = rows.get(i);
                            if (row == null) continue;
                            this.movePosition(row);
                            for (EText text : row.getTexts()) {
                                PageEscpWriter.this.writeETextWithStyle(this.outputStream, text);
                            }
                            if (i == rows.size() - 1) {
                                this.outputStream.write(27);
                                this.outputStream.write(74);
                                this.outputStream.write(table.getLineSpacing());
                                continue;
                            }
                            this.outputStream.write(10);
                        }
                        for (i = 0; i < rows.size(); ++i) {
                            this.outputStream.write(27);
                            this.outputStream.write(106);
                            this.outputStream.write(table.getLineSpacing());
                        }
                    }
                };
            } else if (block instanceof EImage) {
                escpWriter = new AbstractEscpWriter<EImage>(this.escPos){

                    @Override
                    protected void writeBlock(EImage image) throws IOException {
                        byte[] bytes = ImageEscWriter.BitImageParser.getEscpBytes(image);
                        this.outputStream.write(bytes, 0, bytes.length);
                    }
                };
            } else if (block instanceof EBarcode) {
                escpWriter = new AbstractEscpWriter<EBarcode>(this.escPos){

                    @Override
                    protected void writeBlock(EBarcode eBarcode) throws IOException {
                        String barcode = eBarcode.getText();
                        if (barcode == null) {
                            return;
                        }
                        this.outputStream.write(27);
                        this.outputStream.write(97);
                        this.outputStream.write(eBarcode.getAlign().ordinal());
                        byte[] bytes = barcode.getBytes();
                        int cmdLen = bytes.length + 6;
                        int n1 = cmdLen & 0xFF;
                        int n2 = (cmdLen & 0xFF00) >> 8;
                        int height = eBarcode.getHeight();
                        int v1 = height & 0xFF;
                        int v2 = (height & 0xFF00) >> 8;
                        int c = 4;
                        if (eBarcode.getHriPosition() == EscPosConst.BarCodeHRIPosition.NotPrinted_Default) {
                            c += 2;
                        }
                        this.outputStream.write(27);
                        this.outputStream.write(40);
                        this.outputStream.write(66);
                        this.outputStream.write(n1);
                        this.outputStream.write(n2);
                        this.outputStream.write(eBarcode.getSystem().escpCode);
                        this.outputStream.write(2);
                        this.outputStream.write(3);
                        this.outputStream.write(v1);
                        this.outputStream.write(v2);
                        this.outputStream.write(c);
                        this.outputStream.write(bytes, 0, bytes.length);
                    }
                };
            } else {
                log.info(String.format("not support this kind of block [%s]", block.getClass().toString()));
                continue;
            }
            escpWriter.write((EBlock)((EText)block));
        }
    }

    private void endPage() throws IOException {
        this.escPos.write(10);
        this.escPos.write(12);
    }

    private void initPage(EPage ePage) throws IOException {
        this.escPos.initializePrinter();
        this.escPos.write(27);
        this.escPos.write(40);
        this.escPos.write(85);
        this.escPos.write(1);
        this.escPos.write(0);
        this.escPos.write(10);
        this.escPos.write(27);
        this.escPos.write(40);
        this.escPos.write(67);
        this.escPos.write(2);
        this.escPos.write(0);
        int pageHeight = ePage.getHeight();
        int n = (int)((double)pageHeight / 254.0 * 360.0);
        this.escPos.write(n & 0xFF);
        this.escPos.write((n & 0xFF00) >> 8);
        this.escPos.write(28);
        this.escPos.write(38);
    }

    private void writeETextWithStyle(OutputStream outputStream, EText eText) throws IOException {
        boolean withEscpStyle;
        String charsetName = eText.getCharsetName();
        int start = eText.getStart();
        int end = eText.getEnd();
        String originText = eText.getText();
        if (start > 0) {
            byte[] startBytes = originText.substring(0, start).getBytes(charsetName);
            outputStream.write(startBytes, 0, startBytes.length);
        }
        if (withEscpStyle = eText.isWithEscpStyle()) {
            outputStream.write(this.parseStyle(eText.getFontWidth(), eText.getFontHeight(), eText.getUnderline(), eText.isBold()));
        }
        byte[] styleBytes = originText.substring(start, end).getBytes(charsetName);
        outputStream.write(styleBytes, 0, styleBytes.length);
        if (withEscpStyle) {
            outputStream.write(this.parseBaseStyle(eText.getFontWidth(), eText.getFontHeight()));
        }
        if (end < originText.length()) {
            byte[] endBytes = originText.substring(end).getBytes(charsetName);
            outputStream.write(endBytes, 0, endBytes.length);
        }
    }

    private byte[] parseBaseStyle(EscPosConst.FontSize fontWidth, EscPosConst.FontSize fontHeight) {
        return this.parseStyle(fontWidth, fontHeight, EscPosConst.Underline.None_Default, false);
    }

    private byte[] parseStyle(EscPosConst.FontSize fontWidth, EscPosConst.FontSize fontHeight, EscPosConst.Underline underline, boolean bold) {
        int n = 0;
        int offset = 1;
        if (fontWidth == EscPosConst.FontSize._2) {
            n += offset << 2;
        }
        if (fontHeight == EscPosConst.FontSize._2) {
            n += offset << 3;
        }
        if (underline != EscPosConst.Underline.None_Default) {
            n += offset << 7;
        }
        byte[] result = new byte[5];
        result[0] = 28;
        result[1] = 33;
        result[2] = (byte)n;
        if (bold) {
            result[3] = 27;
            result[4] = 69;
        } else {
            result[3] = 27;
            result[4] = 70;
        }
        return result;
    }
}

