/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.print.core.ExecuteContext;

public class ExecuteLife {
    private AtomicBoolean computeSuccess = new AtomicBoolean(true);
    private AtomicBoolean consumeSuccess = new AtomicBoolean(true);
    private Long lastHeartBeat;
    private int maxIdleTime = 180000;
    private List<String> errMsg;
    private boolean stop;
    private boolean stopCompute;
    private static Map<String, ExecuteLife> lifePool = new ConcurrentHashMap<String, ExecuteLife>(16);

    private ExecuteLife(Long lastHeartBeat) {
        this.lastHeartBeat = lastHeartBeat;
    }

    public static synchronized ExecuteLife getOrCreate() {
        String key = ExecuteLife.getLifeKey(ExecuteContext.get().getTaskId());
        ExecuteLife executeLife = lifePool.get(key);
        if (executeLife == null) {
            executeLife = new ExecuteLife(System.currentTimeMillis());
            lifePool.put(key, executeLife);
        }
        return executeLife;
    }

    public static ExecuteLife get(String taskId) {
        String key = ExecuteLife.getLifeKey(taskId);
        ExecuteLife executeLife = lifePool.get(key);
        return executeLife;
    }

    private static String getLifeKey(String taskId) {
        return "ExecuteList:" + taskId;
    }

    public static void release() {
        String key = ExecuteLife.getLifeKey(ExecuteContext.get().getTaskId());
        lifePool.remove(key);
    }

    public boolean computeIsAlive() {
        return System.currentTimeMillis() - this.lastHeartBeat <= (long)this.maxIdleTime;
    }

    public boolean isRunSuccess() {
        return this.isComputeSuccess() && this.isConsumeSuccess();
    }

    public boolean isComputeSuccess() {
        return this.computeSuccess.get();
    }

    public boolean isConsumeSuccess() {
        return this.consumeSuccess.get();
    }

    public void setStop() {
        this.stop = true;
        this.setStopCompute();
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setComputeErr() {
        this.computeSuccess.set(false);
    }

    public void setConsumeErr() {
        this.consumeSuccess.set(false);
    }

    public void doHeartBeat() {
        this.lastHeartBeat = System.currentTimeMillis();
    }

    public List<String> getErrMsg() {
        return this.errMsg;
    }

    public synchronized void addErrMsg(String msg) {
        if (this.errMsg == null) {
            this.errMsg = new ArrayList<String>();
        }
        this.errMsg.add(msg);
    }

    public boolean isStopCompute() {
        return this.stopCompute;
    }

    public void setStopCompute() {
        this.stopCompute = true;
    }
}

