/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.limiter.exception.AcquireFailedException;
import kd.bos.limiter.impl.ConcurrencyLimiter;
import kd.bos.print.core.exception.PrintException;
import kd.bos.print.core.execute.LimitCallable;
import kd.bos.print.core.utils.PrintConst;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class PrintJobPool {
    private static ThreadPool threadPool = null;

    public static <T> Future<T> submit(Callable<T> callable) {
        if (callable instanceof LimitCallable) {
            String concurrentID = null;
            try {
                ConcurrencyLimiter limiter = ConcurrencyLimiter.acquire((String)"BOS_PRINT_LIMIT", (String)"printEngineTask");
                concurrentID = limiter.getConcurrentID();
                ((LimitCallable)callable).setConcurrentID(concurrentID);
                return threadPool.submit(callable);
            }
            catch (AcquireFailedException e) {
                throw new PrintException("5", ResManager.loadKDString((String)"\u5f53\u524d\u6253\u5370\u64cd\u4f5c\u9891\u7e41\uff0c\u7cfb\u7edf\u5bf9\u6253\u5370\u64cd\u4f5c\u8fdb\u884c\u4e86\u9650\u6d41\uff0c\u8bf7\u60a8\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExecuteEngine_0", (String)"bos-print-core", (Object[])new Object[0]));
            }
            catch (RejectedExecutionException e) {
                ConcurrencyLimiter.release(concurrentID);
                return null;
            }
        }
        return threadPool.submit(callable);
    }

    public void execute(Runnable runnable) {
        threadPool.execute(runnable);
    }

    static {
        int processors = PrintConst.getThreadPollSize();
        threadPool = ThreadPools.newFixedThreadPool((String)"PrintExecuteEnginePool", (int)processors);
    }
}

