/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.print.core.execute;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.watermark.WaterMark;
import kd.bos.print.core.data.IPrintDataProvider;
import kd.bos.print.core.data.MainDataVisitor;
import kd.bos.print.core.data.R1PDataVisitor;
import kd.bos.print.core.data.RefDataVisitor;
import kd.bos.print.core.data.datasource.CustomDataSource;
import kd.bos.print.core.data.datasource.FormDataSource;
import kd.bos.print.core.data.datasource.MainDataSource;
import kd.bos.print.core.data.datasource.PrtDataSource;
import kd.bos.print.core.data.datasource.RefDataSource;
import kd.bos.print.core.data.datasource.WorkflowDataSource;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.model.designer.ReportModel;
import kd.bos.print.core.plugin.PrintPluginProxy;

public class RuntimeModel {
    private ReportModel reportModel;
    private HashMap<String, R1PDataVisitor> mapDataVisitor;
    private String formId;
    private int pkIndex;
    private List<Object> pkIds;
    private String pdfName;
    private List<Object> fileName;
    private WaterMark waterMark;
    private IPrintDataProvider dataProvider;
    private PrintPluginProxy pluginProxy;
    private boolean splicePrint;
    private String tplVer;
    private String tplId;
    private String tplKey;

    public RuntimeModel(ReportModel metadata) {
        this.reportModel = metadata;
    }

    public ReportModel getReportModel() {
        return this.reportModel;
    }

    public void clear() {
        if (this.mapDataVisitor != null && this.mapDataVisitor.size() > 0) {
            this.mapDataVisitor.values().forEach(r1PDataVisitor -> r1PDataVisitor.clear());
            this.mapDataVisitor.clear();
        }
        this.mapDataVisitor = null;
        if (this.pkIds != null && this.pkIds.size() > 0) {
            try {
                this.pkIds.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            this.pkIds = null;
        }
        this.reportModel = null;
    }

    public void beginInit() {
        MainDataVisitor mainDataVisitor = (MainDataVisitor)this.getDataVisitor(this.getFormId());
        Field pkField = mainDataVisitor.getField("id");
        Object pkId = pkField.getValue();
        for (R1PDataVisitor visitor : this.getDataVisitors().values()) {
            PrtDataSource dataSource = visitor.getDataSource();
            if (visitor instanceof MainDataVisitor) continue;
            if (visitor instanceof RefDataVisitor) {
                ((RefDataVisitor)visitor).notifyRefDsUpdateParam();
            } else if (dataSource instanceof CustomDataSource) {
                CustomDataSource customDataSource = (CustomDataSource)dataSource;
                customDataSource.setPkId(pkId);
                customDataSource.setMainDataRow(mainDataVisitor.getDataRow());
            } else if (dataSource instanceof WorkflowDataSource) {
                WorkflowDataSource workflowDataSource = (WorkflowDataSource)dataSource;
                String formId = workflowDataSource.getFormId();
                if (StringUtils.isNotBlank((CharSequence)formId)) {
                    formId = formId.split("\\.")[0];
                    workflowDataSource.setFormId(formId);
                    R1PDataVisitor dataVisitor = this.getDataVisitor(formId);
                    if (dataVisitor instanceof RefDataVisitor) {
                        ((RefDataVisitor)dataVisitor).notifyRefDsUpdateParam();
                        dataVisitor.reset();
                        workflowDataSource.setBusinessKey(String.valueOf(dataVisitor.getField("id").getValue()));
                    } else {
                        workflowDataSource.setBusinessKey(String.valueOf(pkId));
                    }
                } else {
                    workflowDataSource.setFormId(this.getFormId());
                    workflowDataSource.setBusinessKey(String.valueOf(pkId));
                }
            }
            visitor.reset();
        }
    }

    public void hookDataProvider(IPrintDataProvider dataProvider, Map<String, PrtDataSource> dsMap) {
        List<RefDataSource> allRefDataSource;
        MainDataSource mainDataSource;
        this.dataProvider = dataProvider;
        if (this.mapDataVisitor != null) {
            return;
        }
        this.mapDataVisitor = new HashMap(16);
        dsMap.forEach((key, ds) -> {
            R1PDataVisitor dataVisitor;
            if (ds instanceof MainDataSource) {
                this.formId = ((MainDataSource)ds).getFormId();
                dataVisitor = new MainDataVisitor((PrtDataSource)ds);
                ((MainDataVisitor)dataVisitor).setPkIds(this.getPkIds());
            } else {
                dataVisitor = ds instanceof RefDataSource ? new RefDataVisitor((PrtDataSource)ds) : new R1PDataVisitor((PrtDataSource)ds);
            }
            dataVisitor.setDelegate(dataProvider);
            this.mapDataVisitor.put((String)key, dataVisitor);
            if (ds instanceof FormDataSource) {
                List<PrtDataSource> childrenDs = ((FormDataSource)ds).getChildrenDs();
                for (PrtDataSource child : childrenDs) {
                    this.mapDataVisitor.put(child.getDsName(), dataVisitor);
                }
            }
        });
        if (StringUtils.isNotEmpty((CharSequence)this.formId) && (mainDataSource = (MainDataSource)dsMap.get(this.formId)) != null && (allRefDataSource = mainDataSource.getAllRefDataSource()) != null && !allRefDataSource.isEmpty()) {
            R1PDataVisitor mainDataVisitor = this.mapDataVisitor.get(this.formId);
            allRefDataSource.forEach(item -> {
                String formId = item.getFormId();
                this.mapDataVisitor.get(formId).hookRelayMainVisitor(mainDataVisitor);
            });
        }
        if (this.getPluginProxy() != null) {
            this.getPluginProxy().initDataVisitor(this.getDataVisitors());
        }
    }

    private HashMap<String, R1PDataVisitor> getDataVisitors() {
        return this.mapDataVisitor;
    }

    public R1PDataVisitor getDataVisitor(String dataSource) {
        return this.getDataVisitors().get(dataSource);
    }

    public byte[] getImageByte(String imageKey) {
        byte[] imageByte = this.dataProvider.getImageByte(imageKey);
        return imageByte;
    }

    public PrintPluginProxy getPluginProxy() {
        return this.pluginProxy;
    }

    public void setPluginProxy(PrintPluginProxy pluginProxy) {
        this.pluginProxy = pluginProxy;
    }

    public Object getPkId() {
        if (this.pkIds != null && this.pkIds.size() > this.pkIndex) {
            return this.pkIds.get(this.pkIndex);
        }
        return null;
    }

    @Deprecated
    public void setPkId(Object pkId) {
    }

    public List<Object> getPkIds() {
        return this.pkIds;
    }

    public void setPkIds(List<Object> pkIds) {
        this.pkIds = pkIds;
        this.pkIndex = 0;
    }

    public WaterMark getWaterMark() {
        return this.waterMark;
    }

    public void setWaterMark(WaterMark waterMark) {
        this.waterMark = waterMark;
    }

    public String getFormId() {
        return this.formId;
    }

    public void setFormId(String formId) {
        this.formId = formId;
    }

    public String getPdfName() {
        return this.pdfName;
    }

    public void setPdfName(String pdfName) {
        this.pdfName = pdfName;
    }

    public boolean isSplicePrint() {
        return this.splicePrint;
    }

    public void setSplicePrint(boolean splicePrint) {
        this.splicePrint = splicePrint;
    }

    public String getTplVer() {
        return this.tplVer;
    }

    public void setTplVer(String tplVer) {
        this.tplVer = tplVer;
    }

    public List<Object> getFileName() {
        return this.fileName;
    }

    public void setFileNameData(List<Object> fileName) {
        this.fileName = fileName;
    }

    public String getTplId() {
        return this.tplId;
    }

    public void setTplId(String tplId) {
        this.tplId = tplId;
    }

    public String getTplKey() {
        return this.tplKey;
    }

    public void setTplKey(String tplKey) {
        this.tplKey = tplKey;
    }
}

